/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.wlpi;

import hu.iqsoft.otp.workflow.exceptions.GeneralWorkflowException;
import hu.iqsoft.otp.workflow.xml.XMLTools;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMapping {
    protected static final String mappingFileName = "WorkflowMapping.xml";
    public static final String ROOT_TAG = "WorkflowMapping";
    public static final String WORKFLOW_TAG = "Workflow";
    public static final String PARAMETER_TAG = "parameter";
    public static final String CLIENTWORKFLOWALIAS_ATTR = "client-alias-name";
    public static final String REALWORKFLOWNAME_ATTR = "workflow-real-name";
    public static final String CLIENTPARAMETERALIAS_ATTR = "client-form-name";
    public static final String REALPARAMETERNAME_ATTR = "workflow-input-name";
    protected static Document mappingDocument = null;
    public static Map workflowMapping = WMapping.extractWorkflowMapping();
    public static Map parameterMapping = WMapping.extractParameterMapping();

    protected static void loadMappingDocument() throws GeneralWorkflowException {
        if (mappingDocument == null) {
            try {
                DOMParser parser = new DOMParser();
                InputSource inp = new InputSource(new FileInputStream(mappingFileName));
                parser.parse(inp);
                mappingDocument = parser.getDocument();
            }
            catch (FileNotFoundException e) {
                try {
                    FileOutputStream fo = new FileOutputStream("WorkflowMapping.xml_shouldBeHere");
                    fo.write(0);
                    fo.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new GeneralWorkflowException("MAPPING_FILE_NOT_FOUND", mappingFileName);
            }
            catch (IOException e) {
                throw new GeneralWorkflowException("MAPPING_FILE_READ_ERROR", mappingFileName);
            }
            catch (SAXException e) {
                throw new GeneralWorkflowException("SAX_PARSER_ERROR", e.getMessage());
            }
        }
    }

    protected static Hashtable extractWorkflowMapping() {
        try {
            WMapping.loadMappingDocument();
        }
        catch (GeneralWorkflowException e) {
            e.printStackTrace();
            return null;
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            List workflows = XMLTools.getChildElements(mappingDocument.getDocumentElement(), WORKFLOW_TAG);
            for (int i = 0; i < workflows.size(); ++i) {
                Element workflow = (Element)workflows.get(i);
                String wClientAlias = workflow.getAttribute(CLIENTWORKFLOWALIAS_ATTR);
                String wRealName = workflow.getAttribute(REALWORKFLOWNAME_ATTR);
                if (wClientAlias == null || wRealName == null) continue;
                result.put(wClientAlias.toUpperCase(), wRealName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static Hashtable extractParameterMapping() {
        try {
            WMapping.loadMappingDocument();
        }
        catch (GeneralWorkflowException e) {
            e.printStackTrace();
            return null;
        }
        Hashtable<String, Hashtable> result = new Hashtable<String, Hashtable>();
        try {
            List workflows = XMLTools.getChildElements(mappingDocument.getDocumentElement(), WORKFLOW_TAG);
            for (int i = 0; i < workflows.size(); ++i) {
                Element workflow = (Element)workflows.get(i);
                String wRealName = workflow.getAttribute(REALWORKFLOWNAME_ATTR);
                if (wRealName == null) continue;
                Hashtable parametersMap = result.containsKey(wRealName) ? (Hashtable)result.get(wRealName) : new Hashtable();
                try {
                    List parameters = XMLTools.getChildElements(workflow, PARAMETER_TAG);
                    for (int j = 0; j < parameters.size(); ++j) {
                        Element parameterMap = (Element)parameters.get(j);
                        String pClientAlias = parameterMap.getAttribute(CLIENTPARAMETERALIAS_ATTR);
                        String pRealName = parameterMap.getAttribute(REALPARAMETERNAME_ATTR);
                        if (pClientAlias == null || pRealName == null) continue;
                        parametersMap.put(pClientAlias.toUpperCase(), pRealName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                result.put(wRealName, parametersMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getWorkflowRealName(String workflowAliasName) {
        String result = workflowAliasName = workflowAliasName.toUpperCase();
        if (workflowMapping.containsKey(workflowAliasName)) {
            result = (String)workflowMapping.get(workflowAliasName);
        }
        return result;
    }

    public static String getWorkflowParameterRealName(String workflowRealName, String parameterAliasName) {
        Map parameters;
        String result = parameterAliasName = parameterAliasName.toUpperCase();
        if (parameterMapping.containsKey(workflowRealName) && (parameters = (Map)parameterMapping.get(workflowRealName)).containsKey(parameterAliasName)) {
            result = (String)parameters.get(parameterAliasName);
        }
        return result;
    }
}

