/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop;

import hu.iqsoft.otp.webshop.WebShopService;
import hu.iqsoft.otp.webshop.mwaccess12.WorkflowState;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;

public class WebShopServiceSimulator
extends WebShopService {
    public static final String PROPERTY_SIMULATEDXMLDIR = "otp.webshop.SIMULATED_XML_DIR";

    public WebShopServiceSimulator() throws AxisFault {
        this(null);
        try {
            category.debug((Object)"OTPWebShopServices *** SZIMULATOR *** peldanyositas...");
            category.debug((Object)"OTPWebShopService *** SZIMULATOR ***  peldanyositas befejezve...");
        }
        catch (Exception e) {
            category.fatal((Object)"FATALISHIBA", (Throwable)e);
            e.printStackTrace();
            throw new AxisFault("FATALISHIBA", e.getMessage(), null, null);
        }
    }

    public WebShopServiceSimulator(Service service) throws AxisFault {
        super(service);
    }

    protected WorkflowState getSimulatedResult(String workflowName) throws AxisFault {
        WorkflowState result = new WorkflowState();
        SimpleDateFormat timeSdf = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss SSS");
        SimpleDateFormat instanceIdSdf = new SimpleDateFormat("yyMMddHHmmssSSS");
        Date now = new Date();
        result.setCompleted(true);
        result.setTimeout(false);
        result.setStartTime(timeSdf.format(now));
        result.setEndTime(timeSdf.format(now));
        result.setInstanceId(instanceIdSdf.format(now));
        result.setTemplateName(workflowName);
        try {
            Properties properties = WebShopServiceSimulator.getWebShopProperties();
            String simXmlFolder = properties.getProperty(PROPERTY_SIMULATEDXMLDIR);
            File simXmlFile = new File(simXmlFolder + File.separator + workflowName + "_output.xml");
            FileInputStream fis = new FileInputStream(simXmlFile);
            byte[] resultXml = new byte[(int)simXmlFile.length()];
            for (int i = 0; i < resultXml.length; i += fis.read(resultXml, i, resultXml.length - i)) {
            }
            result.setResult(resultXml);
        }
        catch (Exception e) {
            category.fatal((Object)"FATALISHIBA", (Throwable)e);
            e.printStackTrace();
            throw new AxisFault("FATALISHIBA", e.getMessage(), null, null);
        }
        return result;
    }

    @Override
    public WorkflowState startWorkflowSynch(String workflowName, String inputXml) throws RemoteException {
        return this.getSimulatedResult(workflowName);
    }

    @Override
    public void ping() throws AxisFault {
        try {
            category.debug((Object)"ping *** SZIMULATOR *** indul...");
            category.debug((Object)"ping *** SZIMULATOR *** befejez\u00f6d\u00f6tt.");
        }
        catch (Exception e) {
            category.warn((Object)"SZERVERHIBA", (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    @Override
    protected String getFuncNameToLog(String name) {
        return name + " *** SZIMULATOR ***";
    }
}

