/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatok;
import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatokLista;
import hu.iqsoft.otp.webshop.model.WebShopFizetesJovairasValasz;
import hu.iqsoft.otp.webshop.model.WebShopFizetesValasz;
import hu.iqsoft.otp.webshop.model.WebShopKulcsAdatok;
import hu.iqsoft.otp.webshop.model.WebShopKulcsAdatokLista;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Category;

public class TransactionLogger {
    private String logDir;
    private String logDirSuccess;
    private String logDirFailed;
    private Category category;
    private String logFileName;
    private static String LOG_DATE_FORMAT = "yyyy.MM.dd. HH:mm:ss";
    private static String LOG_EMPTY_VALUE = "";

    public TransactionLogger(String logDir, Category logCategory) {
        this.logDir = logDir == null ? "" : logDir.trim();
        this.category = logCategory;
    }

    public TransactionLogger(String[] logDirs, Category logCategory) {
        this(logDirs[0], logCategory);
        this.logDirSuccess = logDirs.length == 1 || logDirs[1] == null || logDirs[1].trim().length() == 0 ? null : logDirs[1];
        this.logDirFailed = logDirs.length == 2 || logDirs[2] == null || logDirs[2].trim().length() == 0 ? null : logDirs[2];
    }

    private String getLogFileName(String azonosito, String posId, boolean uj, String logDir) {
        return this.getLogFileName(posId + "_" + azonosito + ".log", uj, logDir);
    }

    private String getLogFileName(String logFileName, boolean uj, String logDir) {
        File logFileDir = new File(logDir);
        if (logFileDir.exists()) {
            if (!logFileDir.isDirectory()) {
                this.category.warn((Object)("Ervenytelen tranzakcio log konyvtar: " + logDir));
            }
        } else {
            this.category.warn((Object)("A tranzakcio log konyvtar nem letezik: " + logDir));
            boolean success = logFileDir.mkdirs();
            if (!success) {
                this.category.warn((Object)("A tranzakcio log konyvtar nem hozhato letre: " + logDir));
            }
        }
        File logFile = new File(logFileDir, logFileName);
        int i = 0;
        while (uj && logFile.exists()) {
            logFile = new File(logFileDir, logFileName + "_" + ++i);
        }
        return i == 0 ? logFileName : logFileName + "_" + i;
    }

    private String nvl(Object value) {
        return value == null ? LOG_EMPTY_VALUE : value.toString();
    }

    public void logHaromszereplosFizetesInditas(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, boolean nevKell, boolean orszagKell, boolean megyeKell, boolean telepulesKell, boolean iranyitoszamKell, boolean utcaHazszamKell, boolean mailCimKell, boolean kozlemenyKell, boolean vevoVisszaigazolasKell, boolean ugyfelRegisztracioKell, String regisztraltUgyfelId, String shopMegjegyzes, String backURL, Boolean ketlepcsosFizetes, String kereskedoiKozlemeny, String zsebAzonosito) {
        if (azonosito != null && azonosito.trim().length() > 0) {
            this.logFileName = this.logDir + File.separator + this.getLogFileName(azonosito, posId, true, this.logDir);
            try {
                PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName), false, "ISO-8859-2");
                ps.println("Haromszereplos fizetesi tranzakcio");
                ps.println("\nInditas: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                ps.println("\nIndito adatok");
                ps.println("  posId: " + this.nvl(posId));
                ps.println("  azonosito: " + this.nvl(azonosito));
                ps.println("  osszeg: " + this.nvl(osszeg));
                ps.println("  devizanem: " + this.nvl(devizanem));
                ps.println("  nyelvkod: " + this.nvl(nyelvkod));
                ps.println("  nevKell: " + nevKell);
                ps.println("  orszagKell: " + orszagKell);
                ps.println("  megyeKell: " + megyeKell);
                ps.println("  telepulesKell: " + telepulesKell);
                ps.println("  iranyitoszamKell: " + iranyitoszamKell);
                ps.println("  utcaHazszamKell: " + utcaHazszamKell);
                ps.println("  mailCimKell: " + mailCimKell);
                ps.println("  kozlemenyKell: " + kozlemenyKell);
                ps.println("  vevoVisszaigazolasKell: " + vevoVisszaigazolasKell);
                ps.println("  ugyfelRegisztracioKell: " + ugyfelRegisztracioKell);
                ps.println("  regisztraltUgyfelId: " + this.nvl(regisztraltUgyfelId));
                ps.println("  shopMegjegyzes: " + this.nvl(shopMegjegyzes));
                ps.println("  backURL: " + this.nvl(backURL));
                ps.println("  ketlepcsosFizetes: " + (ketlepcsosFizetes == null ? LOG_EMPTY_VALUE : ketlepcsosFizetes.toString()));
                ps.println("  kereskedoiKozlemeny: " + this.nvl(kereskedoiKozlemeny));
                ps.println("  zsebAzonosito: " + this.nvl(zsebAzonosito));
                ps.flush();
                ps.close();
            }
            catch (IOException e) {
                this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
            }
        } else {
            this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
        }
    }

    public void logHaromszereplosFizetesBefejezes(String posId, String azonosito, WebShopFizetesAdatokLista valasz) {
        block7: {
            if (azonosito != null && azonosito.trim().length() > 0) {
                try {
                    String newLoc;
                    PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName, true), true, "ISO-8859-2");
                    ps.println("\nBefejezes: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                    ps.println("\nValasz kod: " + valasz.getValaszKod());
                    if (valasz.getWebShopFizetesAdatok() != null && valasz.getWebShopFizetesAdatok().length > 0) {
                        WebShopFizetesAdatok fizetesAdatok = valasz.getWebShopFizetesAdatok()[0];
                        ps.println("\nValasz adatok");
                        ps.println("  posId: " + this.nvl(fizetesAdatok.getPosId()));
                        ps.println("  azonosito: " + this.nvl(fizetesAdatok.getAzonosito()));
                        ps.println("  posValaszkod: " + this.nvl(fizetesAdatok.getPosValaszkod()));
                        ps.println("  autorizaciosKod: " + this.nvl(fizetesAdatok.getAutorizaciosKod()));
                        ps.println("  statuszKod: " + this.nvl(fizetesAdatok.getStatuszKod()));
                        ps.println("  teljesites: " + this.nvl(fizetesAdatok.getTeljesites()));
                        ps.println("  nev: " + this.nvl(fizetesAdatok.getNev()));
                        ps.println("  orszag: " + this.nvl(fizetesAdatok.getOrszag()));
                        ps.println("  megye: " + this.nvl(fizetesAdatok.getMegye()));
                        ps.println("  varos: " + this.nvl(fizetesAdatok.getVaros()));
                        ps.println("  iranyitoszam: " + this.nvl(fizetesAdatok.getIranyitoszam()));
                        ps.println("  utcaHazszam: " + this.nvl(fizetesAdatok.getUtcaHazszam()));
                        ps.println("  mailCim: " + this.nvl(fizetesAdatok.getMailCim()));
                        ps.println("  kozlemeny: " + this.nvl(fizetesAdatok.getKozlemeny()));
                    }
                    ps.flush();
                    ps.close();
                    String string = newLoc = "SIKER".equals(valasz.getValaszKod()) ? this.logDirSuccess : this.logDirFailed;
                    if (newLoc == null) break block7;
                    String newLogFileName = this.getLogFileName(this.logFileName, true, newLoc);
                    try {
                        new File(this.logFileName).renameTo(new File(newLogFileName));
                    }
                    catch (Exception e) {
                        this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl atmozgatasa kozben: " + newLogFileName));
                    }
                }
                catch (IOException e) {
                    this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
                }
            } else {
                this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
            }
        }
    }

    public void logKetszereplosFizetesInditas(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, String regisztraltUgyfelId, String kartyaszam, String cvc2cvv2, String kartyaLejarat, String vevoNev, String vevoPostaCim, String vevoIPCim, String ertesitoMail, String ertesitoTel, Boolean ketlepcsosFizetes, String kereskedoiKozlemeny, String zsebAzonosito) {
        if (azonosito != null && azonosito.trim().length() > 0) {
            this.logFileName = this.logDir + File.separator + this.getLogFileName(azonosito, posId, true, this.logDir);
            try {
                PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName), false, "ISO-8859-2");
                ps.println("Ketszereplos fizetesi tranzakcio");
                ps.println("\nInditas: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                ps.println("\nIndito adatok");
                ps.println("  posId: " + this.nvl(posId));
                ps.println("  azonosito: " + this.nvl(azonosito));
                ps.println("  osszeg: " + this.nvl(osszeg));
                ps.println("  devizanem: " + this.nvl(devizanem));
                ps.println("  nyelvkod: " + this.nvl(nyelvkod));
                ps.println("  regisztraltUgyfelId: " + this.nvl(regisztraltUgyfelId));
                ps.println("  vevoNev: " + this.nvl(vevoNev));
                ps.println("  vevoPostaCim: " + this.nvl(vevoPostaCim));
                ps.println("  vevoIPCim: " + this.nvl(vevoIPCim));
                ps.println("  ertesitoMail: " + this.nvl(ertesitoMail));
                ps.println("  ertesitoTel: " + this.nvl(ertesitoTel));
                ps.println("  ketlepcsos: " + (ketlepcsosFizetes == null ? LOG_EMPTY_VALUE : ketlepcsosFizetes.toString()));
                ps.println("  kereskedoiKozlemeny: " + this.nvl(kereskedoiKozlemeny));
                ps.println("  zsebAzonosito: " + this.nvl(zsebAzonosito));
                ps.flush();
                ps.close();
            }
            catch (IOException e) {
                this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
            }
        } else {
            this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
        }
    }

    public void logKetszereplosFizetesBefejezes(String posId, String azonosito, WebShopFizetesValasz valasz) {
        block6: {
            if (azonosito != null && azonosito.trim().length() > 0) {
                try {
                    String newLoc;
                    PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName, true), true, "ISO-8859-2");
                    ps.println("\nBefejezes: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                    ps.println("\nValasz kod: " + valasz.getValaszKod());
                    ps.println("\nValasz adatok");
                    ps.println("  posId: " + this.nvl(valasz.getPosId()));
                    ps.println("  azonosito: " + this.nvl(valasz.getAzonosito()));
                    ps.println("  posValaszkod: " + this.nvl(valasz.getValaszKod()));
                    ps.println("  autorizaciosKod: " + this.nvl(valasz.getAuthorizaciosKod()));
                    ps.println("  teljesites: " + this.nvl(valasz.getTeljesites()));
                    ps.flush();
                    ps.close();
                    String string = newLoc = "SIKER".equals(valasz.getValaszKod()) ? this.logDirSuccess : this.logDirFailed;
                    if (newLoc == null) break block6;
                    String newLogFileName = this.getLogFileName(this.logFileName, true, newLoc);
                    try {
                        new File(this.logFileName).renameTo(new File(newLogFileName));
                    }
                    catch (Exception e) {
                        this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl atmozgatasa kozben: " + newLogFileName));
                    }
                }
                catch (IOException e) {
                    this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
                }
            } else {
                this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
            }
        }
    }

    public void logFizetesLezarasInditas(String posId, String azonosito, boolean jovahagyo, String osszeg) {
        if (azonosito != null && azonosito.trim().length() > 0) {
            this.logFileName = this.logDir + File.separator + this.getLogFileName(azonosito, posId, true, this.logDir);
            try {
                PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName), false, "ISO-8859-2");
                ps.println("Ketlepcsos fizetes lezaras tranzakcio");
                ps.println("\nInditas: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                ps.println("\nIndito adatok");
                ps.println("  posId: " + this.nvl(posId));
                ps.println("  azonosito: " + this.nvl(azonosito));
                ps.println("  jovahagyo: " + jovahagyo);
                ps.println("  ossszeg: " + this.nvl(osszeg));
                ps.flush();
                ps.close();
            }
            catch (IOException e) {
                this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
            }
        } else {
            this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
        }
    }

    public void logFizetesLezarasBefejezes(String azonosito, WebShopFizetesValasz valasz) {
        block6: {
            if (azonosito != null && azonosito.trim().length() > 0) {
                try {
                    String newLoc;
                    PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName, true), true, "ISO-8859-2");
                    ps.println("\nBefejezes: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                    ps.println("\nValasz kod: " + valasz.getValaszKod());
                    ps.println("\nValasz adatok");
                    ps.println("  posId: " + this.nvl(valasz.getPosId()));
                    ps.println("  azonosito: " + this.nvl(valasz.getAzonosito()));
                    ps.println("  posValaszkod: " + this.nvl(valasz.getValaszKod()));
                    ps.println("  autorizaciosKod: " + this.nvl(valasz.getAuthorizaciosKod()));
                    ps.println("  teljesites: " + this.nvl(valasz.getTeljesites()));
                    ps.flush();
                    ps.close();
                    String string = newLoc = "SIKER".equals(valasz.getValaszKod()) ? this.logDirSuccess : this.logDirFailed;
                    if (newLoc == null) break block6;
                    String newLogFileName = this.getLogFileName(this.logFileName, true, newLoc);
                    try {
                        new File(this.logFileName).renameTo(new File(newLogFileName));
                    }
                    catch (Exception e) {
                        this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl atmozgatasa kozben: " + newLogFileName));
                    }
                }
                catch (IOException e) {
                    this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
                }
            } else {
                this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
            }
        }
    }

    public void logFizetesJovairasInditas(String posId, String azonosito, String osszeg) {
        if (azonosito != null && azonosito.trim().length() > 0) {
            this.logFileName = this.logDir + File.separator + this.getLogFileName(azonosito, posId, true, this.logDir);
            try {
                PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName), false, "ISO-8859-2");
                ps.println("Fizetes jovairas tranzakcio");
                ps.println("\nInditas: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                ps.println("\nIndito adatok");
                ps.println("  posId: " + this.nvl(posId));
                ps.println("  azonosito: " + this.nvl(azonosito));
                ps.println("  ossszeg: " + this.nvl(osszeg));
                ps.flush();
                ps.close();
            }
            catch (IOException e) {
                this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
            }
        } else {
            this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
        }
    }

    public void logFizetesJovairasBefejezes(String azonosito, WebShopFizetesJovairasValasz valasz) {
        block6: {
            if (azonosito != null && azonosito.trim().length() > 0) {
                try {
                    String newLoc;
                    PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName, true), true, "ISO-8859-2");
                    ps.println("\nBefejezes: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                    ps.println("\nValasz kod: " + valasz.getValaszKod());
                    ps.println("\nValasz adatok");
                    ps.println("  posValaszkod: " + this.nvl(valasz.getValaszKod()));
                    ps.println("  autorizaciosKod: " + this.nvl(valasz.getAuthorizaciosKod()));
                    ps.println("  middlewareTrid: " + this.nvl(valasz.getMwAzonosito()));
                    ps.flush();
                    ps.close();
                    String string = newLoc = "SIKER".equals(valasz.getValaszKod()) ? this.logDirSuccess : this.logDirFailed;
                    if (newLoc == null) break block6;
                    String newLogFileName = this.getLogFileName(this.logFileName, true, newLoc);
                    try {
                        new File(this.logFileName).renameTo(new File(newLogFileName));
                    }
                    catch (Exception e) {
                        this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl atmozgatasa kozben: " + newLogFileName));
                    }
                }
                catch (IOException e) {
                    this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
                }
            } else {
                this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak,' az azonosito nincs megadva.");
            }
        }
    }

    public void logKulcsLekerdezesInditas(String posId, String muvelet) {
        if (muvelet != null && muvelet.trim().length() > 0) {
            this.logFileName = this.logDir + File.separator + this.getLogFileName(muvelet, posId, true, this.logDir);
            try {
                PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName), false, "ISO-8859-2");
                ps.println("Kulcs lekerdezes tranzakcio");
                ps.println("\nInditas: " + new SimpleDateFormat(LOG_DATE_FORMAT).format(new Date()));
                ps.println("\nIndito adatok");
                ps.println("  posId: " + this.nvl(posId));
                ps.println("  muvelet: " + this.nvl(muvelet));
                ps.flush();
                ps.close();
            }
            catch (IOException e) {
                this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
            }
        } else {
            this.category.warn((Object)"A tranzakcio adatai nem naplozhatoak, a muvelet nincs megadva.");
        }
    }

    public void logKulcsLekerdezesBefejezes(String posId, WebShopKulcsAdatokLista valasz) {
        try {
            String newLoc;
            PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.logFileName, true), true, "ISO-8859-2");
            SimpleDateFormat sdfIn = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat sdfOut = new SimpleDateFormat(LOG_DATE_FORMAT);
            ps.println("\nBefejezes: " + sdfOut.format(new Date()));
            ps.println("\nValasz kod: " + valasz.getValaszKod());
            ps.println("\nValasz adatok");
            ps.println("  posId: " + this.nvl(posId));
            String privKeyMsg = valasz.getPrivateKey() != null && !"".equals(valasz.getPrivateKey()) ? "keszult" : "nem keszult";
            ps.println("  privateKey: " + privKeyMsg);
            WebShopKulcsAdatok[] lejaratok = valasz.getWebShopKulcsAdatok();
            if (lejaratok != null) {
                for (int i = 0; i < lejaratok.length; ++i) {
                    try {
                        ps.println(i + 1 + ".  lejarat: " + sdfOut.format(sdfIn.parse(lejaratok[i].getLejarat())));
                        continue;
                    }
                    catch (Exception e) {
                        ps.println(i + 1 + ".  lejarat: " + lejaratok[i].getLejarat());
                    }
                }
            }
            ps.flush();
            ps.close();
            String string = newLoc = "SIKER".equals(valasz.getValaszKod()) ? this.logDirSuccess : this.logDirFailed;
            if (newLoc != null) {
                String newLogFileName = this.getLogFileName(this.logFileName, true, newLoc);
                try {
                    new File(this.logFileName).renameTo(new File(newLogFileName));
                }
                catch (Exception e) {
                    this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl atmozgatasa kozben: " + newLogFileName));
                }
            }
        }
        catch (IOException e) {
            this.category.warn((Object)("Hiba tortent a tranzakcios naplo fajl letrehozasa vagy irasa kozben: " + this.logFileName));
        }
    }
}

