/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TransactionState
implements Serializable {
    private static final String SIMPLE_DATE_FORMAT_PATTERN = "yyyy.MM.dd. HH:mm:ss";
    private Date m_start = null;
    private Date m_end = null;
    private byte[] m_result = null;
    private String m_strInstanceId = null;
    private boolean m_bTimeout = false;
    private String m_strTemplateName = null;
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyy.MM.dd. HH:mm:ss");

    public TransactionState() {
    }

    public TransactionState(String strInstanceId, String start, String end, byte[] result, String bTimeout) {
        this.m_strInstanceId = strInstanceId;
        this.setStartTime(start);
        this.setEndTime(end);
        this.m_result = result;
        this.m_bTimeout = "true".equals(bTimeout) && this.m_end == null;
    }

    public void setTemplateName(String strTemplateName) {
        this.m_strTemplateName = strTemplateName;
    }

    public String getTemplateName() {
        return this.m_strTemplateName;
    }

    public boolean isCompleted() {
        return this.m_end != null;
    }

    public void setCompleted(boolean b) {
    }

    public byte[] getResult() {
        return this.m_result;
    }

    public void setResult(byte[] b) {
        this.m_result = b;
    }

    public void setTimeout(boolean b) {
        this.m_bTimeout = b;
    }

    public boolean isTimeout() {
        return this.m_bTimeout;
    }

    public String getInstanceId() {
        return this.m_strInstanceId;
    }

    public void setInstanceId(String s) {
        this.m_strInstanceId = s;
    }

    public String getStartTime() {
        if (this.m_start == null) {
            return null;
        }
        return this.m_dateFormat.format(this.m_start);
    }

    public void setStartTime(String t) {
        try {
            this.m_start = this.m_dateFormat.parse(t);
        }
        catch (Exception e) {
            this.m_start = null;
        }
    }

    public String getEndTime() {
        if (this.m_end == null) {
            return null;
        }
        return this.m_dateFormat.format(this.m_end);
    }

    public void setEndTime(String t) {
        try {
            this.m_end = this.m_dateFormat.parse(t);
        }
        catch (Exception e) {
            this.m_end = null;
        }
    }

    public Document returnXmlResult() throws Exception {
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(new ByteArrayInputStream(this.m_result)));
        return parser.getDocument();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("State of " + this.m_strInstanceId + ": ");
        sb.append("Started: " + this.m_start);
        sb.append("; Completed: " + this.m_end);
        if (this.m_result != null) {
            sb.append("; Result: ok");
        } else {
            sb.append("; Result: null");
        }
        sb.append("; Timeout: " + this.m_bTimeout);
        return sb.toString();
    }
}

