/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebShopXmlUtils {
    public static String WF_TRANZAZONGENERALAS = "WEBSHOPTRANZAZONGENERALAS";
    public static String WF_HAROMSZEREPLOSFIZETES = "WEBSHOPFIZETES";
    public static String WF_HAROMSZEREPLOSFIZETESINDITAS = "WEBSHOPFIZETESINDITAS";
    public static String WF_KETSZEREPLOSFIZETES = "WEBSHOPFIZETESKETSZEREPLOS";
    public static String WF_TRANZAKCIOSTATUSZ = "WEBSHOPTRANZAKCIOLEKERDEZES";
    public static String WF_KETLEPCSOSFIZETESLEZARAS = "WEBSHOPFIZETESLEZARAS";
    public static String WF_WEBSHOPFIZETESJOVAIRAS = "WEBSHOPFIZETESJOVAIRAS";
    public static String WF_WEBSHOPKULCSLEKERDEZES = "WEBSHOPKULCSLEKERDEZES";
    public static String ROOTELEMENT_TAG = "answer";
    public static String MESSAGELIST_PATH = ROOTELEMENT_TAG + "/messagelist";
    public static String MESSAGEITEM = "message";
    public static String AMOUNT = "isAmount";
    public static String BACKURL = "isBackURL";
    public static String CONSUMERRECEIPTNEEDED = "isConsumerReceiptNeeded";
    public static String COUNTRYNEEDED = "isCountryNeeded";
    public static String COUNTYNEEDED = "isCountyNeeded";
    public static String EXCHANGE = "isExchange";
    public static String LANGUAGECODE = "isLanguageCode";
    public static String MAILADDRESSNEEDED = "isMailAddressNeeded";
    public static String NAMENEEDED = "isNameNeeded";
    public static String NARRATIONNEEDED = "isNarrationNeeded";
    public static String POSID = "isPOSID";
    public static String SETTLEMENTNEEDED = "isSettlementNeeded";
    public static String SHOPCOMMENT = "isShopComment";
    public static String STREETNEEDED = "isStreetNeeded";
    public static String TRANSACTIONID = "isTransactionID";
    public static String ZIPCODENEEDED = "isZipcodeNeeded";
    public static String CLIENTSIGNATURE = "isClientSignature";
    public static String CONSUMERREGISTRATIONNEEDED = "isConsumerRegistrationNeeded";
    public static String CONSUMERREGISTRATIONID = "isConsumerRegistrationID";
    public static String TWOSTAGED = "isTwoStaged";
    public static String MERCHANTNOTICE = "isMerchantNotice";
    public static String CARDPOCKETID = "isCardPocketId";
    public static String MUVELET = "isMuvelet";
    public static String ALGORITHM = "algorithm";
    public static String SHA2 = "SHA512";
    public static String CARDNUMBER = "isCardNumber";
    public static String CVCCVV = "isCVCCVV";
    public static String EXPIRATIONDATE = "isExpirationDate";
    public static String NAME = "isName";
    public static String FULLADDRESS = "isFullAddress";
    public static String IPADDRESS = "isIPAddress";
    public static String MAILADDRESS = "isMailAddress";
    public static String TELEPHONE = "isTelephone";
    public static String QUERYMAXRECORDS = "isMaxRecords";
    public static String QUERYSTARTDATE = "isStartDate";
    public static String QUERYENDDATE = "isEndDate";
    public static String QUERYTRANSTATE = "isState";
    public static String APPROVED = "isApproval";
    public static String REQUEST_DATEFORMAT = "yyyy.MM.dd HH:mm:ss";
    public static String REQUEST_SKELETON = "<?xml version=\"1.0\" encoding=\"ISO-8859-2\"?><StartWorkflow>  <TemplateName/>  <Variables>    <isClientCode>WEBSHOP</isClientCode>  </Variables></StartWorkflow>";
    public static String TEMPLATENAME_TAGNAME = "TemplateName";
    public static String VARIABLES_TAGNAME = "Variables";

    public static String DOMToXMLString(Document domContent) throws IOException {
        ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setLineSeparator("\n");
        format.setIndenting(false);
        format.setIndent(2);
        format.setOmitXMLDeclaration(false);
        format.setEncoding("ISO-8859-2");
        XMLSerializer serializer = new XMLSerializer((OutputStream)outStrm, format);
        serializer.serialize(domContent);
        return outStrm.toString();
    }

    public static final Document byteArrayToDOM(byte[] arrayValue) throws SAXException, IOException {
        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new ByteArrayInputStream(arrayValue));
        parser.parse(is);
        Document doc = parser.getDocument();
        return doc;
    }

    public static Document getRequestSkeleton() throws IOException, SAXException {
        return WebShopXmlUtils.byteArrayToDOM(REQUEST_SKELETON.getBytes());
    }

    public static void addParameter(Document dom, Node variables, String name, String value) {
        Text nodeText = dom.createTextNode(name);
        nodeText.setNodeValue(value);
        Element node = null;
        if (dom.getDocumentElement().getNamespaceURI() != null) {
            node = dom.createElementNS(dom.getDocumentElement().getNamespaceURI(), name);
            node.setPrefix(dom.getDocumentElement().getPrefix());
        } else {
            node = dom.createElement(name);
        }
        variables.appendChild(node);
        node.appendChild(nodeText);
    }

    public static void addParameter(Document dom, Node variables, String name, boolean value) {
        WebShopXmlUtils.addParameter(dom, variables, name, value ? "TRUE" : "FALSE");
    }

    public static void addParameterWithAttrs(Document dom, Node variables, String name, String value, Map attrs) {
        Text nodeText = dom.createTextNode(name);
        nodeText.setNodeValue(value);
        Element node = null;
        if (dom.getDocumentElement().getNamespaceURI() != null) {
            node = dom.createElementNS(dom.getDocumentElement().getNamespaceURI(), name);
            node.setPrefix(dom.getDocumentElement().getPrefix());
        } else {
            node = dom.createElement(name);
        }
        Element element = node;
        for (String key : attrs.keySet()) {
            element.setAttribute(key, (String)attrs.get(key));
        }
        variables.appendChild(node);
        node.appendChild(nodeText);
    }

    public static String getTagTextByPath(Document doc, String path) {
        Element elmt = WebShopXmlUtils.getElementByPath(doc, path);
        if (elmt == null) {
            return null;
        }
        if (elmt != null && elmt.getFirstChild() != null) {
            return WebShopXmlUtils.getElementLongText(elmt);
        }
        return "";
    }

    public static Element getElementByPath(Document doc, String path) {
        String pathElement;
        int startIndex = 0;
        int endIndex = 0;
        Element domElement = doc.getDocumentElement();
        endIndex = path.indexOf(47, startIndex);
        if (endIndex == 0) {
            startIndex = 1;
            endIndex = path.indexOf(47, startIndex);
        }
        String string = pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
        if (!pathElement.equals(domElement.getTagName())) {
            return null;
        }
        startIndex = endIndex + 1;
        while (endIndex != -1 && startIndex < path.length()) {
            endIndex = path.indexOf(47, startIndex);
            String string2 = pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
            startIndex = endIndex + 1;
            if (endIndex == startIndex) continue;
            Element child = WebShopXmlUtils.getChildOfElement(domElement, pathElement);
            if (child == null) {
                return null;
            }
            domElement = child;
        }
        return domElement;
    }

    public static Element getElementByPath(Element element, String path) {
        int startIndex = 0;
        int endIndex = 0;
        Element domElement = element;
        endIndex = path.indexOf(47, startIndex);
        if (endIndex == 0) {
            startIndex = 1;
            endIndex = path.indexOf(47, startIndex);
        } else if (endIndex == -1) {
            endIndex = 0;
        }
        while (endIndex != -1) {
            endIndex = path.indexOf(47, startIndex);
            String pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
            Element child = WebShopXmlUtils.getChildOfElement(domElement, pathElement);
            if (child == null) {
                return null;
            }
            domElement = child;
            startIndex = endIndex + 1;
        }
        return domElement;
    }

    public static String getElementLongText(Element elmt) {
        StringBuffer result = new StringBuffer("");
        Node child = elmt.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                result.append(child.getNodeValue());
            }
            if ((child = child.getNextSibling()) == null) continue;
            result.append("\n");
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public static Element getChildOfElement(Node elmt, String childTag) {
        NodeList nodes = elmt.getChildNodes();
        Node found = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1 || childTag != null && !childTag.equals(child.getLocalName())) continue;
            if (found == null) {
                found = child;
                continue;
            }
            return (Element)found;
        }
        return (Element)found;
    }

    public static List getChildElements(Element elmt, String childTag) {
        Vector<Node> result = new Vector<Node>();
        NodeList nodes = elmt.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1 || childTag != null && !childTag.equals(child.getLocalName())) continue;
            result.add(child);
        }
        return result;
    }

    public static List extractMessages(Document answerXml) {
        Vector<String> messages = null;
        Element messageList = WebShopXmlUtils.getElementByPath(answerXml, MESSAGELIST_PATH);
        if (messageList != null) {
            messages = new Vector<String>();
            List messagesList = WebShopXmlUtils.getChildElements(messageList, MESSAGEITEM);
            for (int i = 0; i < messagesList.size(); ++i) {
                Element message = (Element)messagesList.get(i);
                String messageText = WebShopXmlUtils.getElementLongText(message);
                messages.add(messageText);
            }
        }
        return messages;
    }
}

