/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;

public class NoClientAuthJSSESocketFactory
extends DefaultSocketFactory
implements SecureSocketFactory {
    public NoClientAuthJSSESocketFactory(Hashtable attributes) {
        super(attributes);
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        if (port == -1) {
            port = 443;
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create((String)"https");
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        Socket sslSocket = null;
        if (tcp.getProxyHost().length() == 0 || hostInNonProxyList) {
            sslSocket = NoClientAuthJSSESocketFactory.createSSLFactory().createSocket(host, port);
        } else {
            int tunnelPort;
            int n = tunnelPort = tcp.getProxyPort().length() == 0 ? 80 : Integer.parseInt(tcp.getProxyPort());
            if (tunnelPort < 0) {
                tunnelPort = 80;
            }
            Socket tunnel = new Socket(tcp.getProxyHost(), tunnelPort);
            OutputStream tunnelOutputStream = tunnel.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
            out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: AxisClient");
            if (tcp.getProxyUser().length() != 0 && tcp.getProxyPassword().length() != 0) {
                String encodedPassword = XMLUtils.base64encode((byte[])(tcp.getProxyUser() + ":" + tcp.getProxyPassword()).getBytes());
                out.print("\nProxy-Authorization: Basic " + encodedPassword);
            }
            out.print("\nContent-Length: 0");
            out.print("\nPragma: no-cache");
            out.print("\r\n\r\n");
            out.flush();
            InputStream tunnelInputStream = tunnel.getInputStream();
            if (DefaultSocketFactory.log.isDebugEnabled()) {
                DefaultSocketFactory.log.debug((Object)Messages.getMessage((String)"isNull00", (String)"tunnelInputStream", (String)("" + (tunnelInputStream == null))));
            }
            String replyStr = "";
            int newlinesSeen = 0;
            boolean headerDone = false;
            while (newlinesSeen < 2) {
                int i = tunnelInputStream.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone) continue;
                replyStr = replyStr + String.valueOf((char)i);
            }
            if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
                throw new IOException(Messages.getMessage((String)"cantTunnel00", (String[])new String[]{tcp.getProxyHost(), "" + tunnelPort, replyStr}));
            }
            sslSocket = NoClientAuthJSSESocketFactory.createSSLFactory().createSocket(tunnel, host, port, true);
            if (DefaultSocketFactory.log.isDebugEnabled()) {
                DefaultSocketFactory.log.debug((Object)Messages.getMessage((String)"setupTunnel00", (String)tcp.getProxyHost(), (String)("" + tunnelPort)));
            }
        }
        ((SSLSocket)sslSocket).startHandshake();
        if (DefaultSocketFactory.log.isDebugEnabled()) {
            DefaultSocketFactory.log.debug((Object)Messages.getMessage((String)"createdSSL00"));
        }
        return sslSocket;
    }

    public static SSLSocketFactory createSSLFactory() {
        SSLSocketFactory factory = null;
        try {
            SSLContext ctx = SSLContext.getInstance("SSLv3", "SunJSSE");
            ctx.init(null, new TrustManager[]{new unauthenticatedClientTM()}, null);
            factory = ctx.getSocketFactory();
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class unauthenticatedClientTM
    implements TrustManager,
    X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

