/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class SignatureUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] generateSignature(byte[] data, byte[] pkcs8PrivateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(pkcs8PrivateKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
        Signature sig = Signature.getInstance("SHA512withRSA");
        sig.initSign(privKey);
        sig.update(data);
        byte[] signature = sig.sign();
        return signature;
    }

    public static String toHex(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int j = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte k = ba[i];
            buf[j++] = hexDigits[k >>> 4 & 0xF];
            buf[j++] = hexDigits[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] loadPrivateKey(String privKeyFileName) throws FileNotFoundException, IOException {
        byte[] result = null;
        File privKeyFile = new File(privKeyFileName);
        FileInputStream privKeyInputStream = new FileInputStream(privKeyFile);
        result = new byte[(int)privKeyFile.length()];
        privKeyInputStream.read(result);
        privKeyInputStream.close();
        return result;
    }

    public static byte[] getByteArray(String[] fields) {
        int length = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            length += fields[i].getBytes().length;
        }
        byte[] result = new byte[length += fields.length - 1];
        length = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != null) {
                byte[] bytes = fields[i].getBytes();
                for (int j = 0; j < bytes.length; ++j) {
                    result[length++] = bytes[j];
                }
            }
            if (i >= fields.length - 1) continue;
            result[length++] = 124;
        }
        return result;
    }
}

