/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SSLUtils {
    public static String SOAPSERVER_URL = "https://www.otpbankdirekt.hu/mwaccesspublic/mwaccess";
    public static String WSDL_URL = "https://www.otpbankdirekt.hu/mwaccesspublic/MWAccessBean/wsdl.jsp";
    public static String HTTPSPROXY_HOST = null;
    public static String HTTPSPROXY_PORT = null;

    private static SSLSocketFactory createSSLFactory() {
        SSLSocketFactory factory = null;
        try {
            SSLContext ctx = SSLContext.getInstance("SSLv3", "SunJSSE");
            ctx.init(null, new TrustManager[]{new unauthenticatedClientTM()}, null);
            factory = ctx.getSocketFactory();
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpURLConnection createHttpsSoapConnection(String soapServerUrl, String httpsProxyHost, String httpsProxyPort, String httpsProxyUser, String httpsProxyPassword) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection conn = null;
        try {
            if (httpsProxyHost != null) {
                System.setProperty("https.proxyHost", httpsProxyHost);
            }
            if (httpsProxyPort != null) {
                System.setProperty("https.proxyPort", httpsProxyPort);
            }
            if (httpsProxyUser != null) {
                System.setProperty("https.proxyUser", httpsProxyUser);
            }
            if (httpsProxyPassword != null) {
                System.setProperty("https.proxyPassword", httpsProxyPassword);
            }
            URL url = new URL(null, soapServerUrl);
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return conn;
    }

    public static HttpURLConnection createHttpsSoapConnection(String soapServerUrl, String httpsProxyHost, String httpsProxyPort) throws MalformedURLException, ProtocolException, IOException {
        return SSLUtils.createHttpsSoapConnection(soapServerUrl, httpsProxyHost, httpsProxyPort, null, null);
    }

    public static SOAPMessage sendMessageViaHtpps(SOAPMessage request) throws IOException, SOAPException, ProtocolException {
        HttpURLConnection conn = SSLUtils.createHttpsSoapConnection(SOAPSERVER_URL, HTTPSPROXY_HOST, HTTPSPROXY_PORT);
        return SSLUtils.sendMessageViaURLConnection(request, conn);
    }

    public static SOAPMessage sendMessageViaURLConnection(SOAPMessage request, HttpURLConnection conn) throws IOException, SOAPException, ProtocolException {
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        conn.connect();
        OutputStream out = conn.getOutputStream();
        request.writeTo(out);
        out.flush();
        out.close();
        InputStream in = conn.getInputStream();
        MimeHeaders mh = new MimeHeaders();
        mh.addHeader("Content-Type", conn.getContentType());
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage response = mf.createMessage(mh, in);
        return response;
    }

    public static class unauthenticatedClientTM
    implements TrustManager,
    X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

