/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.wlpi;

import hu.iqsoft.otp.workflow.exceptions.GeneralWorkflowException;
import hu.iqsoft.otp.workflow.wlpi.WAnswer;
import hu.iqsoft.otp.workflow.wlpi.WAnswerFactory;
import hu.iqsoft.otp.workflow.wlpi.WContext;
import hu.iqsoft.otp.workflow.xml.XMLTools;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WResponse
implements Serializable {
    public static String ROOTELEMENT_TAG = "answer";
    public static String MESSAGELIST_PATH = ROOTELEMENT_TAG + "/messagelist";
    public static String MESSAGEITEM = "message";
    public static String INFOLIST_PATH = ROOTELEMENT_TAG + "/infolist";
    public static String INFOITEM = "info";
    public static String[] SUCCESS_TEXTS = new String[]{"SIKER", "SIKERESBEJELENTKEZES", "PARKOLAS", "ALAIRASSZUKSEGES", "JOVAHAGYASSZUKSEGES"};
    public static String[] PARKING_TEXTS = new String[]{"PARKOLAS"};
    public static String[] SMSCONFIRM_TEXTS = new String[]{"JOVAHAGYASSZUKSEGES"};
    public static String[] SIGNATURENEEDED_TEXTS = new String[]{"ALAIRASSZUKSEGES"};
    protected static final long WAIT_TILL_STARTED = 10000L;
    protected static final long MS_WAIT_OF_STARTING = 250L;
    protected static final long WAIT_TILL_FINISHED = 10000L;
    protected static final long MS_WAIT_OF_FINISHING = 250L;
    protected String clientTransactionId = null;
    protected boolean acquired;
    protected String instanceId = null;
    protected String templateId = null;
    protected byte[] originalResponse = null;
    protected transient Node originalResponseDOM = null;
    protected WAnswer answer = null;
    Vector messages = new Vector();
    Vector infos = new Vector();
    Boolean hasSuccessfulAnswer = null;
    Boolean hasParkingAnswer = null;
    Boolean hasSmsConfirmAnswer = null;
    Boolean hasSignatureNeededAnswer = null;
    protected static HashSet successTexts = WResponse.loadSuccessTexts();
    protected static HashSet parkingTexts = WResponse.loadParkingTexts();
    protected static HashSet smsConfirmTexts = WResponse.loadSmsConfirmTexts();
    protected static HashSet signatureNeededTexts = WResponse.loadSignatureNeededTexts();

    protected static HashSet loadSuccessTexts() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < SUCCESS_TEXTS.length; ++i) {
            result.add(SUCCESS_TEXTS[i]);
        }
        return result;
    }

    protected static HashSet loadParkingTexts() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < PARKING_TEXTS.length; ++i) {
            result.add(PARKING_TEXTS[i]);
        }
        return result;
    }

    protected static HashSet loadSmsConfirmTexts() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < SMSCONFIRM_TEXTS.length; ++i) {
            result.add(SMSCONFIRM_TEXTS[i]);
        }
        return result;
    }

    protected static HashSet loadSignatureNeededTexts() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < SIGNATURENEEDED_TEXTS.length; ++i) {
            result.add(SIGNATURENEEDED_TEXTS[i]);
        }
        return result;
    }

    public WResponse() {
    }

    public WResponse(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public WResponse(String clientTransactionId, String templateId) {
        this.clientTransactionId = clientTransactionId;
        this.templateId = templateId;
    }

    public abstract boolean acquire(WContext var1, boolean var2, WAnswerFactory var3) throws GeneralWorkflowException;

    public boolean acquire(WContext context, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        return this.acquire(context, false, answerFactory);
    }

    public abstract boolean isFinished();

    public boolean isAcquired() {
        return this.acquired;
    }

    protected void extractMessages() throws GeneralWorkflowException {
        if (!this.acquired) {
            // empty if block
        }
        if (this.messages.size() > 0 || this.hasSuccessfulAnswer != null) {
            return;
        }
        Element messageList = XMLTools.getElementByPath(this.getOriginalResponseDOM(), MESSAGELIST_PATH);
        if (messageList != null) {
            this.hasSuccessfulAnswer = new Boolean(false);
            this.hasParkingAnswer = new Boolean(false);
            this.hasSmsConfirmAnswer = new Boolean(false);
            this.hasSignatureNeededAnswer = new Boolean(false);
            List messagesList = XMLTools.getChildElements(messageList, MESSAGEITEM);
            for (int i = 0; i < messagesList.size(); ++i) {
                Element message = (Element)messagesList.get(i);
                String messageText = XMLTools.getElementText(message);
                if (messageText == null || !successTexts.contains(messageText)) {
                    this.messages.add(messageText);
                } else {
                    this.hasSuccessfulAnswer = new Boolean(true);
                }
                if (messageText != null && parkingTexts.contains(messageText)) {
                    this.hasParkingAnswer = new Boolean(true);
                }
                if (messageText != null && smsConfirmTexts.contains(messageText)) {
                    this.hasSmsConfirmAnswer = new Boolean(true);
                }
                if (messageText == null || !signatureNeededTexts.contains(messageText)) continue;
                this.hasSignatureNeededAnswer = new Boolean(true);
            }
        } else {
            throw new GeneralWorkflowException("INVALID_RESPONSE_FORMAT", this.clientTransactionId);
        }
        Element infoList = XMLTools.getElementByPath(this.getOriginalResponseDOM(), INFOLIST_PATH);
        if (infoList != null) {
            List infosList = XMLTools.getChildElements(infoList, INFOITEM);
            for (int i = 0; i < infosList.size(); ++i) {
                Element info = (Element)infosList.get(i);
                String infoText = XMLTools.getElementText(info);
                if (infoText == null) continue;
                this.infos.add(infoText);
            }
        }
    }

    public boolean hasErrors() {
        if (!this.isFinished()) {
            return false;
        }
        return !this.isSuccessful() && this.messages.size() > 0;
    }

    public Vector getErrors() {
        if (!this.isFinished()) {
            return null;
        }
        if (this.messages == null) {
            try {
                this.extractMessages();
            }
            catch (GeneralWorkflowException generalWorkflowException) {
                // empty catch block
            }
        }
        return this.messages;
    }

    public Vector getInfos() {
        if (!this.isFinished()) {
            return null;
        }
        if (this.messages == null) {
            try {
                this.extractMessages();
            }
            catch (GeneralWorkflowException generalWorkflowException) {
                // empty catch block
            }
        }
        return this.infos;
    }

    public String extractAnswer() throws GeneralWorkflowException {
        if (!this.isValidResponse()) {
            throw new GeneralWorkflowException("INVALID_RESPONSE_FORMAT", this.clientTransactionId);
        }
        return "originalResponse";
    }

    protected void extractOriginalResponseDOM() throws GeneralWorkflowException {
        if (!this.acquired) {
            // empty if block
        }
        try {
            if (this.originalResponseDOM == null) {
                this.originalResponseDOM = XMLTools.byteArrayToDOM(this.originalResponse);
            }
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e.getMessage(), this.clientTransactionId);
        }
    }

    public boolean isValidResponse() {
        if (!this.acquired) {
            return false;
        }
        Element messageList = null;
        try {
            messageList = XMLTools.getElementByPath(this.getOriginalResponseDOM(), MESSAGELIST_PATH);
        }
        catch (GeneralWorkflowException e) {
            return false;
        }
        return messageList != null;
    }

    public boolean isSuccessful() {
        try {
            this.extractMessages();
        }
        catch (GeneralWorkflowException e) {
            return false;
        }
        return this.hasSuccessfulAnswer;
    }

    public boolean isParking() {
        try {
            this.extractMessages();
        }
        catch (GeneralWorkflowException e) {
            return false;
        }
        return this.hasParkingAnswer;
    }

    public boolean isSmsConfirm() {
        try {
            this.extractMessages();
        }
        catch (GeneralWorkflowException e) {
            return false;
        }
        return this.hasSmsConfirmAnswer;
    }

    public boolean isSignatureNeeded() {
        try {
            this.extractMessages();
        }
        catch (GeneralWorkflowException e) {
            return false;
        }
        return this.hasSignatureNeededAnswer;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getClientTransactionId() {
        return this.clientTransactionId;
    }

    public WAnswer getAnswer() {
        return this.answer;
    }

    public byte[] getOriginalResponse() {
        return this.originalResponse;
    }

    public Node getOriginalResponseDOM() throws GeneralWorkflowException {
        this.extractOriginalResponseDOM();
        return this.originalResponseDOM;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("clientTransactionId: " + this.clientTransactionId + "\n");
        buf.append("acquired: " + this.acquired + "\n");
        buf.append("instanceId: " + this.instanceId + "\n");
        buf.append("templateId: " + this.templateId + "\n");
        buf.append("hasSuccessfulAnswer: " + this.hasSuccessfulAnswer + "\n");
        buf.append("hasParkingAnswer: " + this.hasParkingAnswer + "\n");
        buf.append("hasSmsConfirmAnswer: " + this.hasSmsConfirmAnswer + "\n");
        buf.append("isFinished(): " + this.isFinished() + "\n");
        buf.append("messages: [");
        for (i = 0; i < this.messages.size(); ++i) {
            buf.append(this.messages.get(i));
        }
        buf.append("]\n");
        buf.append("infos: [");
        for (i = 0; i < this.infos.size(); ++i) {
            buf.append(this.infos.get(i));
        }
        buf.append("]\n");
        if (this.answer != null) {
            buf.append("answer.data: " + this.answer.getData() + "\n");
        }
        return buf.toString();
    }
}

