/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.wlpi.starters;

import com.bea.document.DocumentFactory;
import com.bea.document.IDocument;
import hu.iqsoft.otp.mw.access.LoadBalancer;
import hu.iqsoft.otp.mw.access.WorkflowState;
import hu.iqsoft.otp.workflow.exceptions.GeneralWorkflowException;
import hu.iqsoft.otp.workflow.exceptions.XMLFormatException;
import hu.iqsoft.otp.workflow.wlpi.WAnswerFactory;
import hu.iqsoft.otp.workflow.wlpi.WContext;
import hu.iqsoft.otp.workflow.wlpi.WResponseOfEJB;
import hu.iqsoft.otp.workflow.wlpi.WStarter;
import hu.iqsoft.otp.workflow.xml.XMLTools;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WStarterOfXMLEvent
extends WStarter {
    public static final String GENERATEDINSTANCEID_TAG = "GeneratedInstanceId";
    public static final String TEMPLATEID_TAG = "TemplateId";
    public static final String TEMPLATENAME_TAG = "TemplateName";
    public static final String ROOTELEMENT_TAG = "StartWorkflow";
    public static final String VARIABLEROOT_TAG = "Variables";
    public static final String VARIABLE_TAG = "Variable";
    public static final String VARIABLENAME_TAG = "Name";
    public static final String VARIABLEVALUE_TAG = "Value";
    public static final String TECHVARIABLES_TAG = "TechnicalInfo";
    private static final String JMS_FACTORY = "com.bea.wlpi.QueueConnectionFactory";
    private static final String JMS_QUEUE = "com.bea.wlpi.EventQueue";
    public static boolean XMLLOGPARAMS_ENABLED = false;
    public static final String XMLLOGPARAMS_FILE = "WorkflowXmlLogParams.properties";
    public static final String XMLLOGPARAMS_PATH_URL = "file:/C:/";
    public static boolean alwaysRefreshLoaderPathFiles = true;
    public static boolean debug = false;
    private static String toSync = "";
    private static ResourceBundle XMLLOGPARAMS_PROPS = null;
    protected static final Category log = Category.getInstance((String)(class$hu$iqsoft$otp$workflow$wlpi$starters$WStarterOfXMLEvent == null ? (class$hu$iqsoft$otp$workflow$wlpi$starters$WStarterOfXMLEvent = WStarterOfXMLEvent.class$("hu.iqsoft.otp.workflow.wlpi.starters.WStarterOfXMLEvent")) : class$hu$iqsoft$otp$workflow$wlpi$starters$WStarterOfXMLEvent).getName());
    static /* synthetic */ Class class$hu$iqsoft$otp$workflow$wlpi$starters$WStarterOfXMLEvent;

    public static void loadLoaderPathClasses() {
        if (debug) {
            System.out.println("*** Loading WorkflowXmlLog property file...");
        }
        URL propsURL = ClassLoader.getSystemResource(XMLLOGPARAMS_FILE);
        try {
            if (propsURL == null) {
                propsURL = new URL("file:/C:/WorkflowXmlLogParams.properties");
                if (debug) {
                    System.out.println("*** Loading " + propsURL);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (propsURL != null) {
            try {
                XMLLOGPARAMS_PROPS = new PropertyResourceBundle(propsURL.openStream());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        if (XMLLOGPARAMS_PROPS == null) {
            System.out.println("*** Warning: file cannot be found: 'WorkflowXmlLogParams.properties'");
        }
    }

    public WStarterOfXMLEvent(WContext context) {
        this.context = context;
    }

    public String startWorkflow(String templateId, Map mapParams, Map techParams) throws GeneralWorkflowException {
        try {
            mapParams.put(TEMPLATENAME_TAG, templateId);
            String xmlMessage = WStarterOfXMLEvent.createXMLEventFromMap(mapParams, techParams);
            return this.startWorkflow(templateId, xmlMessage);
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public String startWorkflow(String templateId, String organization, Map mapParams) throws GeneralWorkflowException {
        try {
            mapParams.put(TEMPLATENAME_TAG, templateId);
            String xmlMessage = WStarterOfXMLEvent.createXMLEventFromMap(mapParams, null);
            return this.startWorkflowOrg(templateId, organization, xmlMessage);
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public void startWorkflowSync(String templateId, Map mapParams, Map techParams, WResponseOfEJB response, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        try {
            mapParams.put(TEMPLATENAME_TAG, templateId);
            String xmlMessage = WStarterOfXMLEvent.createXMLEventFromMap(mapParams, techParams);
            this.startWorkflowSync(templateId, xmlMessage, response, answerFactory);
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public String startWorkflow(String templateId, String xmlParams) throws GeneralWorkflowException {
        try {
            String templateName = templateId;
            LoadBalancer loadBalancer = this.context.getLoadBalancer();
            String strInstanceId = loadBalancer.startWorkflow(templateName, xmlParams);
            WStarterOfXMLEvent.doWorkflowXmlLog(true, xmlParams, templateName, strInstanceId);
            return strInstanceId;
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public String startWorkflowOrg(String templateId, String organization, String xmlParams) throws GeneralWorkflowException {
        try {
            String templateName = templateId;
            LoadBalancer loadBalancer = this.context.getLoadBalancer();
            String strInstanceId = loadBalancer.startWorkflowOrg(templateName, xmlParams, organization);
            WStarterOfXMLEvent.doWorkflowXmlLog(true, xmlParams, templateName, strInstanceId);
            return strInstanceId;
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public void startWorkflowSync(String templateId, String xmlParams, WResponseOfEJB response, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        try {
            String templateName = templateId;
            LoadBalancer loadBalancer = this.context.getLoadBalancer();
            WorkflowState state = loadBalancer.startWorkflowSync(templateName, xmlParams);
            WStarterOfXMLEvent.doWorkflowXmlLog(true, xmlParams, templateName, state.getInstanceId());
            WStarterOfXMLEvent.doWorkflowXmlLog(false, new String(state.getResult()), templateName, state.getInstanceId());
            response.acquireSync(this.context, state, answerFactory);
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public static String createXMLEventFromMap(Map params, Map techParams) throws GeneralWorkflowException {
        try {
            char[] spaces = new char[64];
            boolean indent = false;
            IDocument idoc = DocumentFactory.createDocument();
            idoc.addElement("", ROOTELEMENT_TAG);
            idoc.addElement("/StartWorkflow", TEMPLATENAME_TAG, (String)params.get(TEMPLATENAME_TAG));
            Element variablesTag = idoc.addElement("/StartWorkflow", VARIABLEROOT_TAG);
            Vector keys = new Vector(params.keySet());
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                String name = (String)keys.get(i);
                if (name.equals(GENERATEDINSTANCEID_TAG) || name.equals(TEMPLATEID_TAG) || name.equals(TEMPLATENAME_TAG) || params.get(name) == null) continue;
                if (!(params.get(name) instanceof Node)) {
                    String text = params.get(name).toString();
                    idoc.addElement("/StartWorkflow/Variables", name, text);
                    continue;
                }
                if (params.get(name) instanceof Document) {
                    Document doc = (Document)params.get(name);
                    idoc.addElement("/StartWorkflow/Variables", name);
                    idoc.addNode("/StartWorkflow/Variables/" + name, (Node)doc.getDocumentElement());
                    continue;
                }
                if (!(params.get(name) instanceof Node)) continue;
                Node node = (Node)params.get(name);
                idoc.addNode("/StartWorkflow/Variables", node);
            }
            if (techParams != null) {
                idoc.addElement("/StartWorkflow", TECHVARIABLES_TAG);
                Vector techKeys = new Vector(techParams.keySet());
                for (int i = 0; i < techKeys.size(); ++i) {
                    String paramName = (String)techKeys.get(i);
                    String paramValue = techParams.get(paramName).toString();
                    idoc.addElement("/StartWorkflow/TechnicalInfo", paramName, paramValue);
                }
            }
            StringWriter sw = new StringWriter();
            idoc.toXML((Writer)sw, 1, "ISO-8859-2");
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneralWorkflowException(e);
        }
    }

    public static Map XMLEventToMap(String xmlText) throws GeneralWorkflowException {
        try {
            return WStarterOfXMLEvent.XMLEventToMap(XMLTools.XMLStringToDOM(xmlText, null));
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public String startWorkflow(String templateId, String organization, Map mapParams, String generatedInstanceId) throws GeneralWorkflowException {
        mapParams.put(GENERATEDINSTANCEID_TAG, generatedInstanceId);
        return this.startWorkflow(templateId, organization, mapParams);
    }

    protected static Map XMLEventToMap(Document domContent) throws GeneralWorkflowException {
        try {
            String text;
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            Element root = domContent.getDocumentElement();
            if (!root.getTagName().equals(ROOTELEMENT_TAG)) {
                throw new XMLFormatException("BAD_ROOT_ELEMENT", root.getTagName());
            }
            Element child = XMLTools.getChildOfElement(root, GENERATEDINSTANCEID_TAG);
            if (child != null && (text = XMLTools.getElementText(child)) != null) {
                map.put(GENERATEDINSTANCEID_TAG, text);
            }
            if ((child = XMLTools.getChildOfElement(root, TEMPLATENAME_TAG)) != null && (text = XMLTools.getElementText(child)) != null) {
                map.put(TEMPLATENAME_TAG, text);
            }
            if ((root = XMLTools.getChildOfElement(root, VARIABLEROOT_TAG)) == null) {
                throw new XMLFormatException("MISSING_VARIABLE_PART", null);
            }
            NodeList childs = root.getChildNodes();
            int n = childs.getLength();
            for (int i = 0; i < n; ++i) {
                if (childs.item(i).getNodeType() != 1) continue;
                child = (Element)childs.item(i);
                Element childContent = XMLTools.getChildOfElement(child, null);
                if (childContent != null) {
                    map.put(child.getTagName(), childContent);
                    continue;
                }
                text = XMLTools.getElementText(child);
                if (text != null) {
                    map.put(child.getTagName(), text);
                    continue;
                }
                map.put(child.getTagName(), "");
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneralWorkflowException(e);
        }
    }

    public void startWorkflowProcessSync(String templateId, Map mapParams, Map techParams, WResponseOfEJB response, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        try {
            mapParams.put(TEMPLATENAME_TAG, templateId);
            String xmlMessage = WStarterOfXMLEvent.createXMLEventFromMap(mapParams, techParams);
            this.startWorkflowProcessSync(templateId, xmlMessage, response, answerFactory);
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    public void startWorkflowProcessSync(String templateId, String xmlParams, WResponseOfEJB response, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        try {
            String templateName = templateId;
            LoadBalancer loadBalancer = this.context.getLoadBalancer();
            WorkflowState state = loadBalancer.startProcess(templateName, xmlParams);
            WStarterOfXMLEvent.doWorkflowXmlLog(true, xmlParams, templateName, state.getInstanceId());
            WStarterOfXMLEvent.doWorkflowXmlLog(false, new String(state.getResult()), templateName, state.getInstanceId());
            response.acquireSync(this.context, state, answerFactory);
        }
        catch (Exception e) {
            throw new GeneralWorkflowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWorkflowXmlLog(boolean isInput, String xmlParams, String templateName, String strInstanceId) {
        boolean toLog;
        if (!XMLLOGPARAMS_ENABLED) {
            return;
        }
        String string = toSync;
        synchronized (string) {
            if (XMLLOGPARAMS_PROPS != null && alwaysRefreshLoaderPathFiles) {
                XMLLOGPARAMS_PROPS = null;
            }
            if (XMLLOGPARAMS_PROPS == null) {
                WStarterOfXMLEvent.loadLoaderPathClasses();
            }
        }
        boolean bl = toLog = XMLLOGPARAMS_PROPS != null;
        if (toLog) {
            String propValue = XMLLOGPARAMS_PROPS.getString("toLog");
            boolean bl2 = toLog = propValue != null && propValue.toUpperCase().equals("TRUE");
        }
        if (toLog) {
            try {
                String keyPostfix = ".inputXml";
                if (!isInput) {
                    keyPostfix = ".outputXml";
                }
                String destDir = XMLLOGPARAMS_PROPS.getString("destRootDir" + keyPostfix);
                String dateFormat = XMLLOGPARAMS_PROPS.getString("dateFormatInFileName");
                String fileNamePattern = XMLLOGPARAMS_PROPS.getString("fileNamePattern" + keyPostfix);
                String pathPattern = XMLLOGPARAMS_PROPS.getString("pathPattern" + keyPostfix);
                SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                String formattedDate = formatter.format(new Date());
                Object[] args = new Object[10];
                args[0] = templateName;
                args[1] = formattedDate;
                StringBuffer buf = new StringBuffer(strInstanceId);
                int j = 2;
                for (int i = 0; i < strInstanceId.length(); ++i) {
                    char c = strInstanceId.charAt(i);
                    if (c == ';' || c == ':') {
                        args[j] = buf.toString();
                        buf.setLength(0);
                        ++j;
                        continue;
                    }
                    buf.append(c);
                }
                String path = MessageFormat.format(pathPattern, args);
                String fileName = MessageFormat.format(fileNamePattern, args);
                File theDir = new File(destDir + '\\' + path);
                theDir.mkdirs();
                String theFileName = destDir + '\\' + path + '\\' + fileName;
                StringBuffer theFileNameBuf = new StringBuffer(theFileName.length());
                for (int i = 0; i < theFileName.length(); ++i) {
                    char c = theFileName.charAt(i);
                    if (c == ';' || c == ':') {
                        c = '_';
                    }
                    theFileNameBuf.append(c);
                }
                System.out.println("Generating " + theFileName);
                PrintWriter writer2 = new PrintWriter(new FileWriter(theFileName));
                writer2.println(xmlParams);
                writer2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

