/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLTools {
    public static final Document XMLStringToDOM(String strValue, String encoding) throws Exception {
        DOMParser parser = new DOMParser();
        InputSource inp = new InputSource(new StringReader(strValue));
        if (encoding != null) {
            inp.setEncoding(encoding);
        }
        parser.parse(inp);
        Document domContent = parser.getDocument();
        return domContent;
    }

    public static final Document byteArrayToDOM(byte[] arrayValue) throws Exception {
        DOMParser parser = new DOMParser();
        InputSource inp = new InputSource(new ByteArrayInputStream(arrayValue));
        parser.parse(inp);
        Document domContent = parser.getDocument();
        return domContent;
    }

    public static final byte[] DOMToByteArray(Document domContent, String encoding) throws Exception {
        ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setLineSeparator("\n");
        format.setIndenting(true);
        format.setIndent(2);
        format.setLineSeparator("\n");
        format.setLineWidth(80);
        format.setPreserveSpace(false);
        if (encoding != null) {
            format.setEncoding(encoding);
        }
        XMLSerializer serializer = new XMLSerializer((OutputStream)outStrm, format);
        serializer.serialize(domContent);
        return outStrm.toByteArray();
    }

    public static final String DOMToXMLString(Document domContent, String encoding) throws Exception {
        return XMLTools.DOMToXMLString(domContent, encoding, true);
    }

    public static final String DOMToXMLString(Document domContent, String encoding, boolean xmlDeclaration) throws Exception {
        return XMLTools.DOMToXMLString(domContent.getDocumentElement(), encoding, xmlDeclaration);
    }

    public static final String DOMToXMLString(Element domContent, String encoding) throws Exception {
        return XMLTools.DOMToXMLString(domContent, encoding, true);
    }

    public static final String DOMToXMLString(Element domContent, String encoding, boolean xmlDeclaration) throws Exception {
        ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setLineSeparator("\n");
        format.setIndenting(true);
        format.setIndent(2);
        format.setOmitXMLDeclaration(!xmlDeclaration);
        if (encoding != null) {
            format.setEncoding(encoding);
        }
        XMLSerializer serializer = new XMLSerializer((OutputStream)outStrm, format);
        serializer.serialize(domContent);
        return outStrm.toString();
    }

    public static final String formatXML(String strValue) {
        try {
            Document domContent = XMLTools.XMLStringToDOM(strValue, null);
            return XMLTools.DOMToXMLString(domContent, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "***  " + e.getMessage() + " ***";
        }
    }

    public static String getTagByPath(Document doc, String path) {
        Element elmt = XMLTools.getElementByPath(doc, path);
        if (elmt == null) {
            return null;
        }
        if (elmt != null && elmt.getFirstChild() != null) {
            return XMLTools.getElementLongText(elmt);
        }
        return "";
    }

    public static Element getElementByPath(Document doc, String path) {
        String pathElement;
        int startIndex = 0;
        int endIndex = 0;
        Element domElement = doc.getDocumentElement();
        endIndex = path.indexOf(47, startIndex);
        if (endIndex == 0) {
            startIndex = 1;
            endIndex = path.indexOf(47, startIndex);
        }
        String string = pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
        if (!pathElement.equals(domElement.getTagName())) {
            return null;
        }
        startIndex = endIndex + 1;
        while (endIndex != -1 && startIndex < path.length()) {
            endIndex = path.indexOf(47, startIndex);
            String string2 = pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
            startIndex = endIndex + 1;
            if (endIndex == startIndex) continue;
            Element child = XMLTools.getChildOfElement(domElement, pathElement);
            if (child == null) {
                return null;
            }
            domElement = child;
        }
        return domElement;
    }

    public static Element getElementByPath(Element element, String path) {
        int startIndex = 0;
        int endIndex = 0;
        Element domElement = element;
        endIndex = path.indexOf(47, startIndex);
        if (endIndex == 0) {
            startIndex = 1;
            endIndex = path.indexOf(47, startIndex);
        } else if (endIndex == -1) {
            endIndex = 0;
        }
        while (endIndex != -1) {
            endIndex = path.indexOf(47, startIndex);
            String pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
            Element child = XMLTools.getChildOfElement(domElement, pathElement);
            if (child == null) {
                return null;
            }
            domElement = child;
            startIndex = endIndex + 1;
        }
        return domElement;
    }

    public static Element getElementByPath(Node element, String path) {
        int startIndex = 0;
        int endIndex = 0;
        int level = 0;
        Node domElement = element;
        endIndex = path.indexOf(47, startIndex);
        if (endIndex == 0) {
            startIndex = 1;
            endIndex = 1;
        } else if (endIndex == -1) {
            endIndex = 0;
        }
        while (endIndex != -1) {
            endIndex = path.indexOf(47, startIndex);
            String pathElement = endIndex == -1 ? path.substring(startIndex) : path.substring(startIndex, endIndex);
            Node child = XMLTools.getChildOfElement(domElement, pathElement);
            if (child == null) {
                if (level == 0 && domElement.getNodeName().equals(pathElement)) {
                    child = domElement;
                } else {
                    return null;
                }
            }
            domElement = child;
            startIndex = endIndex + 1;
            ++level;
        }
        return (Element)domElement;
    }

    public static Element getChildOfElement(Node elmt, String childTag) {
        NodeList nodes = elmt.getChildNodes();
        Node found = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1 || childTag != null && !childTag.equals(child.getNodeName())) continue;
            if (found == null) {
                found = child;
                continue;
            }
            return (Element)found;
        }
        return (Element)found;
    }

    public static List getChildElements(Element elmt) {
        Vector<Node> result = new Vector<Node>();
        NodeList nodes = elmt.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            result.add(child);
        }
        return result;
    }

    public static List getChildElements(Element elmt, String childTag) {
        Vector<Node> result = new Vector<Node>();
        NodeList nodes = elmt.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1 || childTag != null && !childTag.equals(child.getNodeName())) continue;
            result.add(child);
        }
        return result;
    }

    public static String getElementText(Element elmt) {
        Node child;
        for (child = elmt.getFirstChild(); child != null && !XMLTools.isNodeTextOrCdata(child); child = child.getNextSibling()) {
        }
        if (child == null) {
            return null;
        }
        return child.getNodeValue();
    }

    public static String getElementLongText(Element elmt) {
        StringBuffer result = new StringBuffer("");
        Node child = elmt.getFirstChild();
        while (child != null) {
            if (XMLTools.isNodeTextOrCdata(child)) {
                result.append(child.getNodeValue());
            }
            if ((child = child.getNextSibling()) == null) continue;
            result.append("\n");
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public static void setElementText(Element elmt, String text) {
        Node child;
        for (child = elmt.getFirstChild(); child != null && child.getNodeType() != 3; child = child.getNextSibling()) {
        }
        if (child == null) {
            elmt.appendChild(elmt.getOwnerDocument().createTextNode(text));
        } else {
            child.setNodeValue(text);
        }
    }

    public static String getRecursiveCDATA(Node node, String name) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 4 && node.getParentNode().getNodeName().equals(name)) {
            return node.getNodeValue();
        }
        node = node.getFirstChild() != null ? node.getFirstChild() : (node.getNextSibling() != null ? node.getNextSibling() : node.getParentNode().getNextSibling());
        return XMLTools.getRecursiveCDATA(node, name);
    }

    private static boolean isNodeTextOrCdata(Node node) {
        return node.getNodeType() == 3 || node.getNodeType() == 4;
    }
}

