/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.AxisServiceConfig;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.bytecode.ParamNameExtractor;
import org.apache.commons.logging.Log;

public class ServiceDesc {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$description$ServiceDesc == null ? (class$org$apache$axis$description$ServiceDesc = ServiceDesc.class$("org.apache.axis.description.ServiceDesc")) : class$org$apache$axis$description$ServiceDesc).getName());
    private String name = null;
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Style style = Style.RPC;
    private Use use = Use.ENCODED;
    private boolean useSet = false;
    private Class implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private String endpointURL = null;
    private HashMap properties = null;
    private boolean isSkeletonClass = false;
    private Method skelMethod = null;
    private ArrayList stopClasses = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private HashMap method2ParamsMap = new HashMap();
    private OperationDesc messageServiceDefaultOp = null;
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = DefaultTypeMappingImpl.getSingleton();
    private TypeMappingRegistry tmr = null;
    private boolean haveAllSkeletonMethods = false;
    private boolean introspectionComplete = false;
    static /* synthetic */ Class class$org$apache$axis$description$ServiceDesc;
    static /* synthetic */ Class class$org$apache$axis$wsdl$Skeleton;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class array$Lorg$w3c$dom$Element;
    static /* synthetic */ Class array$Lorg$apache$axis$message$SOAPBodyElement;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$org$apache$axis$message$SOAPEnvelope;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        if (!this.useSet) {
            this.use = style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use use) {
        this.useSet = true;
        this.use = use;
    }

    public boolean isWrapped() {
        return this.style == Style.RPC || this.style == Style.WRAPPED;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public void setImplClass(Class implClass) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = implClass;
        if ((class$org$apache$axis$wsdl$Skeleton == null ? (class$org$apache$axis$wsdl$Skeleton = ServiceDesc.class$("org.apache.axis.wsdl.Skeleton")) : class$org$apache$axis$wsdl$Skeleton).isAssignableFrom(implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
    }

    private void loadSkeletonOperations() {
        Method method = null;
        try {
            method = this.implClass.getDeclaredMethod("getOperationDescs", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (method == null) {
            return;
        }
        try {
            Collection opers = (Collection)method.invoke((Object)this.implClass, null);
            Iterator i = opers.iterator();
            while (i.hasNext()) {
                OperationDesc skelDesc = (OperationDesc)i.next();
                this.addOperationDesc(skelDesc);
            }
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (InvocationTargetException e) {
            return;
        }
        this.haveAllSkeletonMethods = true;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList stopClasses) {
        this.stopClasses = stopClasses;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List disallowedMethods) {
        this.disallowedMethods = disallowedMethods;
    }

    public void addOperationDesc(OperationDesc operation) {
        String name;
        ArrayList<OperationDesc> overloads;
        this.operations.add(operation);
        operation.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((overloads = (ArrayList<OperationDesc>)this.name2OperationsMap.get(name = operation.getName())) == null) {
            overloads = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(name, overloads);
        }
        overloads.add(operation);
    }

    public ArrayList getOperations() {
        this.loadServiceDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    public OperationDesc getOperationByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        return (OperationDesc)overloads.get(0);
    }

    public OperationDesc getOperationByElementQName(QName qname) {
        OperationDesc[] overloads = this.getOperationsByQName(qname);
        if (overloads != null && overloads.length > 0) {
            return overloads[0];
        }
        return null;
    }

    public OperationDesc[] getOperationsByQName(QName qname) {
        this.initQNameMap();
        ArrayList overloads = (ArrayList)this.qname2OperationsMap.get(qname);
        if (overloads == null) {
            if ((this.isWrapped() || this.style == Style.MESSAGE && this.getDefaultNamespace() == null) && this.name2OperationsMap != null) {
                overloads = (ArrayList)this.name2OperationsMap.get(qname.getLocalPart());
            }
            if (this.style == Style.MESSAGE && this.messageServiceDefaultOp != null) {
                return new OperationDesc[]{this.messageServiceDefaultOp};
            }
            if (overloads == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)overloads.get(0)).getName());
        Collections.sort(overloads, new Comparator(){

            public int compare(Object o1, Object o2) {
                Method meth1 = ((OperationDesc)o1).getMethod();
                Method meth2 = ((OperationDesc)o2).getMethod();
                return meth1.getParameterTypes().length - meth2.getParameterTypes().length;
            }
        });
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadServiceDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator i = this.operations.iterator();
            while (i.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)i.next();
                QName qname = operationDesc.getElementQName();
                ArrayList<OperationDesc> list = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(qname);
                if (list == null) {
                    list = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(qname, list);
                }
                list.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc oper, Class implClass) {
        if (oper.getMethod() != null) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        Method possibleMatch = null;
        int i = 0;
        while (i < methods.length) {
            block18: {
                Class<?>[] paramTypes;
                Method method;
                block19: {
                    method = methods[i];
                    if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(oper.getName()) || this.method2OperationMap.get(method) != null) break block18;
                    if (this.style != Style.MESSAGE) break block19;
                    int messageOperType = this.checkMessageMethod(method);
                    if (messageOperType == -4) break block18;
                    if (messageOperType == -1) {
                        throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
                    }
                    oper.setMessageOperationStyle(messageOperType);
                }
                if ((paramTypes = method.getParameterTypes()).length == oper.getNumParams()) {
                    boolean conversionNecessary = false;
                    int j = 0;
                    while (j < paramTypes.length) {
                        ParameterDesc param;
                        QName typeQName;
                        Class type;
                        Class actualType = type = paramTypes[j];
                        if ((class$javax$xml$rpc$holders$Holder == null ? ServiceDesc.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type)) {
                            actualType = JavaUtils.getHolderValueType(type);
                        }
                        if ((typeQName = (param = oper.getParameter(j)).getTypeQName()) == null) {
                            typeQName = this.tm.getTypeQName(actualType);
                            param.setTypeQName(typeQName);
                        } else {
                            Class paramClass = param.getJavaType();
                            if (paramClass != null && JavaUtils.getHolderValueType(paramClass) != null) {
                                paramClass = JavaUtils.getHolderValueType(paramClass);
                            }
                            if (paramClass == null) {
                                paramClass = this.tm.getClassForQName(param.getTypeQName());
                            }
                            if (!JavaUtils.isConvertable(paramClass, actualType)) break;
                            if (!actualType.isAssignableFrom(paramClass)) {
                                conversionNecessary = true;
                            }
                        }
                        param.setJavaType(type);
                        ++j;
                    }
                    if (j == paramTypes.length) {
                        possibleMatch = method;
                        if (!conversionNecessary) break;
                    }
                }
            }
            ++i;
        }
        if (possibleMatch != null) {
            oper.setReturnClass(possibleMatch.getReturnType());
            this.createFaultMetadata(possibleMatch, oper);
            oper.setMethod(possibleMatch);
            this.method2OperationMap.put(possibleMatch, oper);
            return;
        }
        Class superClass = implClass.getSuperclass();
        if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
            this.syncOperationToClass(oper, superClass);
        }
        if (oper.getMethod() == null) {
            InternalException ie = new InternalException(Messages.getMessage("serviceDescOperSync00", oper.getName(), implClass.getName()));
            throw ie;
        }
    }

    private int checkMessageMethod(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1) {
            if (params[0] == (array$Lorg$w3c$dom$Element == null ? (array$Lorg$w3c$dom$Element = ServiceDesc.class$("[Lorg.w3c.dom.Element;")) : array$Lorg$w3c$dom$Element) && method.getReturnType() == (array$Lorg$w3c$dom$Element == null ? (array$Lorg$w3c$dom$Element = ServiceDesc.class$("[Lorg.w3c.dom.Element;")) : array$Lorg$w3c$dom$Element)) {
                return 3;
            }
            if (params[0] == (array$Lorg$apache$axis$message$SOAPBodyElement == null ? (array$Lorg$apache$axis$message$SOAPBodyElement = ServiceDesc.class$("[Lorg.apache.axis.message.SOAPBodyElement;")) : array$Lorg$apache$axis$message$SOAPBodyElement) && method.getReturnType() == (array$Lorg$apache$axis$message$SOAPBodyElement == null ? (array$Lorg$apache$axis$message$SOAPBodyElement = ServiceDesc.class$("[Lorg.apache.axis.message.SOAPBodyElement;")) : array$Lorg$apache$axis$message$SOAPBodyElement)) {
                return 1;
            }
            if (params[0] == (class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = ServiceDesc.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document) && method.getReturnType() == (class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = ServiceDesc.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document)) {
                return 4;
            }
        } else if (params.length == 2 && params[0] == (class$org$apache$axis$message$SOAPEnvelope == null ? (class$org$apache$axis$message$SOAPEnvelope = ServiceDesc.class$("org.apache.axis.message.SOAPEnvelope")) : class$org$apache$axis$message$SOAPEnvelope) && params[1] == (class$org$apache$axis$message$SOAPEnvelope == null ? (class$org$apache$axis$message$SOAPEnvelope = ServiceDesc.class$("org.apache.axis.message.SOAPEnvelope")) : class$org$apache$axis$message$SOAPEnvelope) && method.getReturnType() == Void.TYPE) {
            return 2;
        }
        if (null != this.allowedMethods && !this.allowedMethods.isEmpty()) {
            throw new InternalException(Messages.getMessage("badMsgMethodParams", method.getName()));
        }
        return -4;
    }

    public void loadServiceDescByIntrospection() {
        this.loadServiceDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    public void loadServiceDescByIntrospection(Class implClass) {
        String allowedMethodsStr;
        if (this.introspectionComplete || implClass == null) {
            return;
        }
        this.implClass = implClass;
        if ((class$org$apache$axis$wsdl$Skeleton == null ? (class$org$apache$axis$wsdl$Skeleton = ServiceDesc.class$("org.apache.axis.wsdl.Skeleton")) : class$org$apache$axis$wsdl$Skeleton).isAssignableFrom(implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        AxisServiceConfig axisConfig = null;
        try {
            Method method = implClass.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                axisConfig = (AxisServiceConfig)method.invoke(null, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (axisConfig != null && (allowedMethodsStr = axisConfig.getAllowedMethods()) != null && !"*".equals(allowedMethodsStr)) {
            ArrayList<String> methodList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(allowedMethodsStr, " ,");
            while (tokenizer.hasMoreTokens()) {
                methodList.add(tokenizer.nextToken());
            }
            this.setAllowedMethods(methodList);
        }
        this.loadServiceDescByIntrospectionRecursive(implClass);
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            OperationDesc operation = (OperationDesc)iterator.next();
            if (operation.getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", operation.getName(), "" + operation.getNumParams()));
        }
        if (this.style == Style.MESSAGE && this.operations.size() == 1) {
            this.messageServiceDefaultOp = (OperationDesc)this.operations.get(0);
        }
        this.introspectionComplete = true;
    }

    private void loadServiceDescByIntrospectionRecursive(Class implClass) {
        if ((class$org$apache$axis$wsdl$Skeleton == null ? (class$org$apache$axis$wsdl$Skeleton = ServiceDesc.class$("org.apache.axis.wsdl.Skeleton")) : class$org$apache$axis$wsdl$Skeleton).equals(implClass)) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                this.getSyncedOperationsForName(implClass, methods[i].getName());
            }
            ++i;
        }
        if (implClass.isInterface()) {
            Class<?>[] superClasses = implClass.getInterfaces();
            int i2 = 0;
            while (i2 < superClasses.length) {
                Class<?> superClass = superClasses[i2];
                if (!(superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
                    this.loadServiceDescByIntrospectionRecursive(superClass);
                }
                ++i2;
            }
        } else {
            Class superClass = implClass.getSuperclass();
            if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
                this.loadServiceDescByIntrospectionRecursive(superClass);
            }
        }
    }

    public void loadServiceDescByIntrospection(Class cls, TypeMapping tm) {
        this.implClass = cls;
        this.tm = tm;
        if ((class$org$apache$axis$wsdl$Skeleton == null ? (class$org$apache$axis$wsdl$Skeleton = ServiceDesc.class$("org.apache.axis.wsdl.Skeleton")) : class$org$apache$axis$wsdl$Skeleton).isAssignableFrom(this.implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        this.loadServiceDescByIntrospection();
    }

    private void getSyncedOperationsForName(Class implClass, String methodName) {
        ArrayList currentOverloads;
        Iterator i;
        if (this.isSkeletonClass && (methodName.equals("getOperationDescByName") || methodName.equals("getOperationDescs"))) {
            return;
        }
        if (implClass == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(methodName)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(methodName)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(methodName)) {
            return;
        }
        if (this.isSkeletonClass && !this.haveAllSkeletonMethods) {
            if (this.skelMethod == null) {
                try {
                    this.skelMethod = implClass.getDeclaredMethod("getOperationDescByName", class$java$lang$String == null ? (class$java$lang$String = ServiceDesc.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (this.skelMethod == null) {
                    return;
                }
            }
            try {
                List skelList = (List)this.skelMethod.invoke((Object)implClass, methodName);
                if (skelList != null) {
                    i = skelList.iterator();
                    while (i.hasNext()) {
                        this.addOperationDesc((OperationDesc)i.next());
                    }
                }
            }
            catch (IllegalAccessException e) {
                return;
            }
            catch (IllegalArgumentException e) {
                return;
            }
            catch (InvocationTargetException e) {
                return;
            }
        }
        if (this.name2OperationsMap != null && (currentOverloads = (ArrayList)this.name2OperationsMap.get(methodName)) != null) {
            i = currentOverloads.iterator();
            while (i.hasNext()) {
                OperationDesc oper = (OperationDesc)i.next();
                if (oper.getMethod() != null) continue;
                this.syncOperationToClass(oper, implClass);
            }
        }
        this.createOperationsForName(implClass, methodName);
        this.completedNames.add(methodName);
    }

    private void createOperationsForName(Class implClass, String methodName) {
        if (this.isSkeletonClass && (methodName.equals("getOperationDescByName") || methodName.equals("getOperationDescs"))) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().equals(methodName)) {
                this.createOperationForMethod(method);
            }
            ++i;
        }
        Class superClass = implClass.getSuperclass();
        if (superClass != null && !superClass.getName().startsWith("java.") && !superClass.getName().startsWith("javax.")) {
            this.createOperationsForName(superClass, methodName);
        }
    }

    private void createOperationForMethod(Method method) {
        ArrayList overloads;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList arrayList = overloads = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (overloads != null && !overloads.isEmpty()) {
            int i = 0;
            while (i < overloads.size()) {
                Class<?>[] others;
                OperationDesc op = (OperationDesc)overloads.get(i);
                Method checkMethod = op.getMethod();
                if (checkMethod != null && paramTypes.length == (others = checkMethod.getParameterTypes()).length) {
                    int j = 0;
                    while (j < others.length) {
                        if (!others[j].equals(paramTypes[j])) break;
                        ++j;
                    }
                    if (j == others.length) {
                        return;
                    }
                }
                ++i;
            }
        }
        OperationDesc operation = new OperationDesc();
        operation.setName(method.getName());
        String defaultNS = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            defaultNS = (String)this.namespaceMappings.get(0);
        }
        operation.setElementQName(new QName(defaultNS, method.getName()));
        operation.setMethod(method);
        if (this.style == Style.MESSAGE) {
            int messageOperType = this.checkMessageMethod(method);
            if (messageOperType == -4) {
                return;
            }
            if (messageOperType == -1) {
                throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
            }
            operation.setMessageOperationStyle(messageOperType);
            operation.setReturnClass(class$java$lang$Object == null ? (class$java$lang$Object = ServiceDesc.class$("java.lang.Object")) : class$java$lang$Object);
            operation.setReturnType(Constants.XSD_ANYTYPE);
        } else {
            Class<?> retClass = method.getReturnType();
            operation.setReturnClass(retClass);
            operation.setReturnType(this.tm.getTypeQName(method.getReturnType()));
            String[] paramNames = this.getParamNames(method);
            int k = 0;
            while (k < paramTypes.length) {
                Class<?> type = paramTypes[k];
                ParameterDesc paramDesc = new ParameterDesc();
                if (paramNames != null && paramNames[k] != null && paramNames[k].length() > 0) {
                    paramDesc.setName(paramNames[k]);
                } else {
                    paramDesc.setName("in" + k);
                }
                Class heldClass = JavaUtils.getHolderValueType(type);
                if (heldClass != null) {
                    paramDesc.setMode((byte)3);
                    paramDesc.setTypeQName(this.tm.getTypeQName(heldClass));
                } else {
                    paramDesc.setMode((byte)1);
                    paramDesc.setTypeQName(this.tm.getTypeQName(type));
                }
                paramDesc.setJavaType(type);
                operation.addParameter(paramDesc);
                ++k;
            }
        }
        this.createFaultMetadata(method, operation);
        this.addOperationDesc(operation);
        this.method2OperationMap.put(method, operation);
    }

    private void createFaultMetadata(Method method, OperationDesc operation) {
        Class[] exceptionTypes = new Class[method.getExceptionTypes().length];
        exceptionTypes = method.getExceptionTypes();
        int i = 0;
        while (i < exceptionTypes.length) {
            Class ex = exceptionTypes[i];
            if (ex != (class$java$rmi$RemoteException == null ? ServiceDesc.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException) && ex != (class$org$apache$axis$AxisFault == null ? ServiceDesc.class$("org.apache.axis.AxisFault") : class$org$apache$axis$AxisFault) && !ex.getName().startsWith("java.") && !ex.getName().startsWith("javax.")) {
                QName xmlType;
                FaultDesc fault = operation.getFaultByClass(ex);
                if (fault == null) {
                    fault = new FaultDesc();
                }
                if ((xmlType = fault.getXmlType()) == null) {
                    fault.setXmlType(this.tm.getTypeQName(ex));
                }
                String pkgAndClsName = ex.getName();
                if (fault.getClassName() == null) {
                    fault.setClassName(pkgAndClsName);
                }
                if (fault.getName() == null) {
                    String name = pkgAndClsName.substring(pkgAndClsName.lastIndexOf(46) + 1, pkgAndClsName.length());
                    fault.setName(name);
                }
                if (fault.getParameters() == null) {
                    QName qname;
                    if (xmlType == null) {
                        xmlType = this.tm.getTypeQName(ex);
                    }
                    if ((qname = fault.getQName()) == null) {
                        qname = new QName("", "fault");
                    }
                    ParameterDesc param = new ParameterDesc(qname, 1, xmlType);
                    param.setJavaType(ex);
                    ArrayList<ParameterDesc> exceptionParams = new ArrayList<ParameterDesc>();
                    exceptionParams.add(param);
                    fault.setParameters(exceptionParams);
                }
                if (fault.getQName() == null) {
                    fault.setQName(new QName(pkgAndClsName));
                }
                operation.addFault(fault);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getParamNames(Method method) {
        HashMap hashMap = this.method2ParamsMap;
        synchronized (hashMap) {
            String[] paramNames = (String[])this.method2ParamsMap.get(method);
            if (paramNames != null) {
                return paramNames;
            }
            paramNames = ParamNameExtractor.getParameterNamesFromDebugInfo(method);
            this.method2ParamsMap.put(method, paramNames);
            return paramNames;
        }
    }

    public void setNamespaceMappings(List namespaces) {
        this.namespaceMappings = namespaces;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String namespace) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, namespace);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry tmr) {
        this.tmr = tmr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

