/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBeanHelperWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaBeanWriter
extends JavaClassWriter {
    private TypeEntry type;
    private Vector elements;
    private Vector attributes;
    private TypeEntry extendType;
    protected JavaBeanHelperWriter helper;
    protected Vector names = new Vector();
    protected String simpleValueType = null;
    protected PrintWriter pw;
    protected boolean enableDefaultConstructor = true;
    protected boolean enableFullConstructor = false;
    protected boolean enableSimpleConstructors = false;
    protected boolean enableToString = false;
    protected boolean enableSetters = true;
    protected boolean enableGetters = true;
    protected boolean enableEquals = true;
    protected boolean enableHashCode = true;

    protected JavaBeanWriter(Emitter emitter, TypeEntry type, Vector elements, TypeEntry extendType, Vector attributes, JavaWriter helper) {
        super(emitter, type.getName(), "complexType");
        this.type = type;
        this.elements = elements;
        this.attributes = attributes;
        this.extendType = extendType;
        this.helper = (JavaBeanHelperWriter)helper;
        if (type.isSimpleType()) {
            this.enableSimpleConstructors = true;
            this.enableToString = true;
        }
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.pw = pw;
        this.preprocess();
        this.writeMemberFields();
        if (this.enableDefaultConstructor) {
            this.writeDefaultConstructor();
        }
        if (this.enableFullConstructor) {
            this.writeFullConstructor();
        }
        if (this.enableSimpleConstructors) {
            this.writeSimpleConstructors();
        }
        if (this.enableToString) {
            this.writeToStringMethod();
        }
        this.writeAccessMethods();
        if (this.enableEquals) {
            this.writeEqualsMethod();
        }
        if (this.enableHashCode) {
            this.writeHashCodeMethod();
        }
        if (!this.emitter.isHelperWanted()) {
            this.helper.setPrintWriter(pw);
        }
        this.helper.generate();
    }

    protected void preprocess() {
        String variableName;
        int i;
        if (this.elements != null) {
            i = 0;
            while (i < this.elements.size()) {
                ElementDecl elem = (ElementDecl)this.elements.get(i);
                String typeName = elem.getType().getName();
                if (elem.getAnyElement()) {
                    typeName = "org.apache.axis.message.MessageElement []";
                    variableName = "_any";
                } else {
                    String elemName = elem.getName().getLocalPart();
                    variableName = Utils.xmlNameToJava(elemName);
                }
                this.names.add(typeName);
                this.names.add(variableName);
                if (this.type.isSimpleType() && variableName.equals("value")) {
                    this.simpleValueType = typeName;
                }
                ++i;
            }
        }
        if (this.attributes != null) {
            i = 0;
            while (i < this.attributes.size()) {
                String typeName = ((TypeEntry)this.attributes.get(i)).getName();
                QName xmlName = (QName)this.attributes.get(i + 1);
                variableName = Utils.xmlNameToJava(xmlName.getLocalPart());
                this.names.add(typeName);
                this.names.add(variableName);
                if (this.type.isSimpleType() && variableName.equals("value")) {
                    this.simpleValueType = typeName;
                }
                i += 2;
            }
        }
    }

    protected String getClassModifiers() {
        Node node = this.type.getNode();
        if (node != null && JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "abstract"))) {
            return super.getClassModifiers() + "abstract ";
        }
        return super.getClassModifiers();
    }

    protected String getExtendsText() {
        String extendsText = "";
        if (this.extendType != null && !this.type.isSimpleType()) {
            extendsText = " extends " + this.extendType.getName() + " ";
        }
        return extendsText;
    }

    protected String getImplementsText() {
        String implementsText = " implements java.io.Serializable";
        if (this.type.isSimpleType()) {
            implementsText = implementsText + ", org.apache.axis.encoding.SimpleType";
        }
        implementsText = implementsText + " ";
        return implementsText;
    }

    protected void writeMemberFields() {
        int i = 0;
        while (i < this.names.size()) {
            String typeName = (String)this.names.get(i);
            String variable = (String)this.names.get(i + 1);
            this.pw.print("    private " + typeName + " " + variable + ";");
            if (this.elements == null || i >= this.elements.size() * 2) {
                this.pw.println("  // attribute");
            } else {
                this.pw.println();
            }
            i += 2;
        }
        this.pw.println();
    }

    protected void writeDefaultConstructor() {
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        this.pw.println();
    }

    protected void writeFullConstructor() {
        Vector<TypeEntry> extendList = new Vector<TypeEntry>();
        extendList.add(this.type);
        TypeEntry parent = this.extendType;
        while (parent != null) {
            extendList.add(parent);
            parent = SchemaUtils.getComplexElementExtensionBase(parent.getNode(), this.emitter.getSymbolTable());
        }
        Vector<String> paramTypes = new Vector<String>();
        Vector<String> paramNames = new Vector<String>();
        int i = extendList.size() - 1;
        while (i >= 0) {
            Vector elements;
            Vector attributes;
            TypeEntry te = (TypeEntry)extendList.elementAt(i);
            String mangle = "";
            if (i > 0) {
                mangle = "_" + Utils.xmlNameToJava(te.getQName().getLocalPart()) + "_";
            }
            if ((attributes = SchemaUtils.getContainedAttributeTypes(te.getNode(), this.emitter.getSymbolTable())) != null) {
                int j = 0;
                while (j < attributes.size()) {
                    paramTypes.add(((TypeEntry)attributes.get(j)).getName());
                    String name = ((QName)attributes.get(j + 1)).getLocalPart();
                    paramNames.add(mangle + Utils.xmlNameToJava(name));
                    j += 2;
                }
            }
            if ((elements = SchemaUtils.getContainedElementDeclarations(te.getNode(), this.emitter.getSymbolTable())) != null) {
                int j = 0;
                while (j < elements.size()) {
                    ElementDecl elem = (ElementDecl)elements.get(j);
                    paramTypes.add(elem.getType().getName());
                    paramNames.add(mangle + Utils.xmlNameToJava(elem.getName().getLocalPart()));
                    ++j;
                }
            }
            --i;
        }
        int localParams = paramTypes.size() - this.names.size() / 2;
        if (paramTypes.size() > 0) {
            this.pw.println("    public " + this.className + "(");
            int i2 = 0;
            while (i2 < paramTypes.size()) {
                this.pw.print("           " + paramTypes.elementAt(i2) + " " + paramNames.elementAt(i2));
                if (i2 + 1 < paramTypes.size()) {
                    this.pw.println(",");
                } else {
                    this.pw.println(") {");
                }
                ++i2;
            }
            if (this.extendType != null && localParams > 0) {
                this.pw.println("        super(");
                int j = 0;
                while (j < localParams) {
                    this.pw.print("            " + paramNames.elementAt(j));
                    if (j + 1 < localParams) {
                        this.pw.println(",");
                    } else {
                        this.pw.println(");");
                    }
                    ++j;
                }
            }
            int j = localParams;
            while (j < paramNames.size()) {
                this.pw.println("        this." + paramNames.elementAt(j) + " = " + paramNames.elementAt(j) + ";");
                ++j;
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeSimpleConstructors() {
        if (this.type.isSimpleType() && this.simpleValueType != null) {
            if (!this.simpleValueType.equals("java.lang.String")) {
                this.pw.println("    public " + this.className + "(" + this.simpleValueType + " value) {");
                this.pw.println("        this.value = value;");
                this.pw.println("    }");
                this.pw.println();
            }
            this.pw.println("    // " + Messages.getMessage("needStringCtor"));
            this.pw.println("    public " + this.className + "(java.lang.String value) {");
            String wrapper = JavaUtils.getWrapper(this.simpleValueType);
            if (wrapper != null) {
                this.pw.println("        this.value = new " + wrapper + "(value)." + this.simpleValueType + "Value();");
            } else if (this.simpleValueType.equals("byte[]")) {
                this.pw.println("        this.value = org.apache.axis.types.HexBinary.decode(value);");
            } else if (this.simpleValueType.equals("org.apache.axis.types.URI")) {
                this.pw.println("        try {");
                this.pw.println("            this.value = new org.apache.axis.types.URI(value);");
                this.pw.println("        }");
                this.pw.println("        catch (org.apache.axis.types.URI.MalformedURIException mue) {");
                this.pw.println("            this.value = new org.apache.axis.types.URI();");
                this.pw.println("       }");
            } else if (this.simpleValueType.equals("java.util.Date")) {
                this.pw.println("        try {");
                this.pw.println("            this.value = (java.text.DateFormat.getDateTimeInstance()).parse(value);");
                this.pw.println("        }");
                this.pw.println("        catch (java.text.ParseException e){");
                this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
                this.pw.println("        }");
            } else if (this.simpleValueType.equals("java.util.Calendar")) {
                this.pw.println("        java.util.Calendar cal = java.util.Calendar.getInstance();");
                this.pw.println("        try {");
                this.pw.println("          java.util.Date dt = (java.text.DateFormat.getDateTimeInstance()).parse(value);");
                this.pw.println("          cal.setTime(dt);");
                this.pw.println("          this.value = cal;");
                this.pw.println("        }");
                this.pw.println("        catch (java.text.ParseException e){");
                this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
                this.pw.println("        }");
            } else {
                this.pw.println("        this.value = new " + this.simpleValueType + "(value);");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeToStringMethod() {
        if (this.type.isSimpleType() && this.simpleValueType != null) {
            this.pw.println("    // " + Messages.getMessage("needToString"));
            String wrapper = JavaUtils.getWrapper(this.simpleValueType);
            this.pw.println("    public java.lang.String toString() {");
            if (wrapper != null) {
                this.pw.println("        return new " + wrapper + "(value).toString();");
            } else if (this.simpleValueType.equals("byte[]")) {
                this.pw.println("        return value == null ? null : org.apache.axis.types.HexBinary.encode(value);");
            } else {
                this.pw.println("        return value == null ? null : value.toString();");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeAccessMethods() {
        int j = 0;
        int i = 0;
        while (i < this.names.size()) {
            ElementDecl elem;
            String typeName = (String)this.names.get(i);
            String name = (String)this.names.get(i + 1);
            String capName = Utils.capitalizeFirstChar(name);
            String get = "get";
            if (typeName.equals("boolean")) {
                get = "is";
            }
            if (this.enableGetters) {
                this.pw.println("    public " + typeName + " " + get + capName + "() {");
                this.pw.println("        return " + name + ";");
                this.pw.println("    }");
                this.pw.println();
            }
            if (this.enableSetters) {
                this.pw.println("    public void set" + capName + "(" + typeName + " " + name + ") {");
                this.pw.println("        this." + name + " = " + name + ";");
                this.pw.println("    }");
                this.pw.println();
            }
            if (this.elements != null && j < this.elements.size() && (elem = (ElementDecl)this.elements.get(j)).getType().getQName().getLocalPart().indexOf("[") > 0) {
                String compName = typeName.substring(0, typeName.lastIndexOf("["));
                if (this.enableGetters) {
                    this.pw.println("    public " + compName + " " + get + capName + "(int i) {");
                    this.pw.println("        return " + name + "[i];");
                    this.pw.println("    }");
                    this.pw.println();
                }
                if (this.enableSetters) {
                    this.pw.println("    public void set" + capName + "(int i, " + compName + " value) {");
                    this.pw.println("        this." + name + "[i] = value;");
                    this.pw.println("    }");
                    this.pw.println();
                }
            }
            i += 2;
            ++j;
        }
    }

    protected void writeEqualsMethod() {
        this.pw.println("    private java.lang.Object __equalsCalc = null;");
        this.pw.println("    public synchronized boolean equals(java.lang.Object obj) {");
        this.pw.println("        if (!(obj instanceof " + this.className + ")) return false;");
        this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
        this.pw.println("        if (obj == null) return false;");
        this.pw.println("        if (this == obj) return true;");
        this.pw.println("        if (__equalsCalc != null) {");
        this.pw.println("            return (__equalsCalc == obj);");
        this.pw.println("        }");
        this.pw.println("        __equalsCalc = obj;");
        String truth = "true";
        if (this.extendType != null && !this.type.isSimpleType()) {
            truth = "super.equals(obj)";
        }
        this.pw.println("        boolean _equals;");
        if (this.names.size() == 0) {
            this.pw.println("        _equals = " + truth + ";");
        } else {
            this.pw.println("        _equals = " + truth + " && ");
            int i = 0;
            while (i < this.names.size()) {
                String variableType = (String)this.names.get(i);
                String variable = (String)this.names.get(i + 1);
                String get = "get";
                if (variableType.equals("boolean")) {
                    get = "is";
                }
                if (variableType.equals("int") || variableType.equals("long") || variableType.equals("short") || variableType.equals("float") || variableType.equals("double") || variableType.equals("boolean") || variableType.equals("byte")) {
                    this.pw.print("            this." + variable + " == other." + get + Utils.capitalizeFirstChar(variable) + "()");
                } else if (variableType.indexOf("[") >= 0) {
                    this.pw.println("            ((this." + variable + "==null && other." + get + Utils.capitalizeFirstChar(variable) + "()==null) || ");
                    this.pw.println("             (this." + variable + "!=null &&");
                    this.pw.print("              java.util.Arrays.equals(this." + variable + ", other." + get + Utils.capitalizeFirstChar(variable) + "())))");
                } else {
                    this.pw.println("            ((this." + variable + "==null && other." + get + Utils.capitalizeFirstChar(variable) + "()==null) || ");
                    this.pw.println("             (this." + variable + "!=null &&");
                    this.pw.print("              this." + variable + ".equals(other." + get + Utils.capitalizeFirstChar(variable) + "())))");
                }
                if (i == this.names.size() - 2) {
                    this.pw.println(";");
                } else {
                    this.pw.println(" &&");
                }
                i += 2;
            }
        }
        this.pw.println("        __equalsCalc = null;");
        this.pw.println("        return _equals;");
        this.pw.println("    }");
        this.pw.println("");
    }

    protected void writeHashCodeMethod() {
        this.pw.println("    private boolean __hashCodeCalc = false;");
        this.pw.println("    public synchronized int hashCode() {");
        this.pw.println("        if (__hashCodeCalc) {");
        this.pw.println("            return 0;");
        this.pw.println("        }");
        this.pw.println("        __hashCodeCalc = true;");
        String start = "1";
        if (this.extendType != null && !this.type.isSimpleType()) {
            start = "super.hashCode()";
        }
        this.pw.println("        int _hashCode = " + start + ";");
        int i = 0;
        while (i < this.names.size()) {
            String variableType = (String)this.names.get(i);
            String variable = (String)this.names.get(i + 1);
            String get = "get";
            if (variableType.equals("boolean")) {
                get = "is";
            }
            if (variableType.equals("int") || variableType.equals("short") || variableType.equals("byte")) {
                this.pw.println("        _hashCode += " + get + Utils.capitalizeFirstChar(variable) + "();");
            } else if (variableType.equals("boolean")) {
                this.pw.println("        _hashCode += new Boolean(" + get + Utils.capitalizeFirstChar(variable) + "()).hashCode();");
            } else if (variableType.equals("long")) {
                this.pw.println("        _hashCode += new Long(" + get + Utils.capitalizeFirstChar(variable) + "()).hashCode();");
            } else if (variableType.equals("float")) {
                this.pw.println("        _hashCode += new Float(" + get + Utils.capitalizeFirstChar(variable) + "()).hashCode();");
            } else if (variableType.equals("double")) {
                this.pw.println("        _hashCode += new Double(" + get + Utils.capitalizeFirstChar(variable) + "()).hashCode();");
            } else if (variableType.indexOf("[") >= 0) {
                this.pw.println("        if (" + get + Utils.capitalizeFirstChar(variable) + "() != null) {");
                this.pw.println("            for (int i=0;");
                this.pw.println("                 i<java.lang.reflect.Array.getLength(" + get + Utils.capitalizeFirstChar(variable) + "());");
                this.pw.println("                 i++) {");
                this.pw.println("                java.lang.Object obj = java.lang.reflect.Array.get(" + get + Utils.capitalizeFirstChar(variable) + "(), i);");
                this.pw.println("                if (obj != null &&");
                this.pw.println("                    !obj.getClass().isArray()) {");
                this.pw.println("                    _hashCode += obj.hashCode();");
                this.pw.println("                }");
                this.pw.println("            }");
                this.pw.println("        }");
            } else {
                this.pw.println("        if (" + get + Utils.capitalizeFirstChar(variable) + "() != null) {");
                this.pw.println("            _hashCode += " + get + Utils.capitalizeFirstChar(variable) + "().hashCode();");
                this.pw.println("        }");
            }
            i += 2;
        }
        this.pw.println("        __hashCodeCalc = false;");
        this.pw.println("        return _hashCode;");
        this.pw.println("    }");
        this.pw.println("");
    }
}

