/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathProcessor;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtil {
    private static XMLParserLiaison s_xpathSupport = null;
    private static XPathProcessor s_xpathParser = null;

    public static XPath getMatchPatternXPath(String xpath) {
        try {
            XPath xp = new XPath();
            XPathUtil.getProcessor().initMatchPattern(xp, xpath, null);
            return xp;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static XPath getExecutableXPath(String xpath) {
        try {
            XPath xp = new XPath();
            XPathUtil.getProcessor().initXPath(xp, xpath, null);
            return xp;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Vector executePatterns(Document xml, Hashtable patterns) {
        Vector<Vector> result = new Vector<Vector>();
        if (xml != null) {
            Enumeration keys = patterns.keys();
            while (keys.hasMoreElements()) {
                try {
                    Object key = keys.nextElement();
                    Object val = patterns.get(key);
                    XPath xpath = (XPath)key;
                    Vector res = XPathUtil.executePattern(xpath, xml.getDocumentElement());
                    result.add(res);
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    private static Vector executePattern(XPath xpath, Node node) {
        Vector<String> result = new Vector<String>();
        try {
            XObject xpresult = xpath.execute((XPathSupport)XPathUtil.getSupport(), node, null);
            if (xpresult.getType() == 4) {
                NodeList xpresultlist = xpath.execute((XPathSupport)XPathUtil.getSupport(), node, null).nodeset();
                for (int i = 0; i < xpresultlist.getLength(); ++i) {
                    result.add(xpresultlist.item(i).getNodeName());
                }
            } else if (xpresult.getType() == 3) {
                result.add(xpresult.str());
            } else if (xpresult.getType() == 2) {
                result.add(new Double(xpresult.num()).toString());
            } else {
                result.add(xpresult.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Vector matchPatterns(Document xml, Hashtable patterns) {
        Vector result = new Vector();
        if (xml != null) {
            Enumeration keys = patterns.keys();
            while (keys.hasMoreElements()) {
                try {
                    Object key = keys.nextElement();
                    Object val = patterns.get(key);
                    XPath xpath = (XPath)key;
                    if (!XPathUtil.matchPattern(xpath, xml.getDocumentElement())) continue;
                    result.add(val);
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    private static boolean matchPattern(XPath xpath, Node node) {
        return XPathUtil.getMatchScore(xpath, node) != Double.NEGATIVE_INFINITY;
    }

    private static double getMatchScore(XPath xpath, Node node) {
        double result = Double.NEGATIVE_INFINITY;
        try {
            result = xpath.getMatchScore((XPathSupport)XPathUtil.getSupport(), node);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    private static XMLParserLiaison getSupport() {
        if (s_xpathSupport == null) {
            s_xpathSupport = new XMLParserLiaisonDefault();
        }
        return s_xpathSupport;
    }

    private static XPathProcessor getProcessor() {
        if (s_xpathParser == null) {
            s_xpathParser = new XPathProcessorImpl((XPathSupport)XPathUtil.getSupport());
        }
        return s_xpathParser;
    }
}

