/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.Callback;
import org.apache.axis.encoding.CallbackTarget;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.SOAPFaultBuilder;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultDetailsBuilder
extends SOAPHandler
implements Callback {
    protected SOAPFaultBuilder builder;

    public SOAPFaultDetailsBuilder(SOAPFaultBuilder builder) {
        this.builder = builder;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Detail"), null, null, null);
            throw new SAXException(fault);
        }
        super.startElement(namespace, localName, prefix, attributes, context);
    }

    public SOAPHandler onStartChild(String namespace, String name, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName qn = new QName(namespace, name);
        if (name.equals("exceptionName")) {
            Deserializer dser = context.getDeserializerForType(Constants.XSD_STRING);
            dser.registerValueTarget(new CallbackTarget(this, "exceptionName"));
            return (SOAPHandler)((Object)dser);
        }
        MessageContext msgContext = context.getMessageContext();
        SOAPConstants soapConstants = msgContext.getSOAPConstants();
        OperationDesc op = msgContext.getOperation();
        if (op != null) {
            QName type;
            FaultDesc faultDesc = op.getFaultByQName(qn);
            if (faultDesc == null && (type = context.getTypeFromAttributes(namespace, name, attributes)) != null) {
                faultDesc = op.getFaultByXmlType(type);
            }
            if (faultDesc != null) {
                try {
                    Class faultClass = ClassUtils.forName(faultDesc.getClassName());
                    this.builder.setFaultClass(faultClass);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                this.builder.setWaiting(true);
                Deserializer dser = null;
                if (attributes.getValue(soapConstants.getAttrHref()) == null) {
                    dser = context.getDeserializerForType(faultDesc.getXmlType());
                } else {
                    dser = new DeserializerImpl();
                    dser.setDefaultType(faultDesc.getXmlType());
                }
                if (dser != null) {
                    dser.registerValueTarget(new CallbackTarget(this, "faultData"));
                }
                return (SOAPHandler)((Object)dser);
            }
        }
        return null;
    }

    public void setValue(Object value, Object hint) {
        block3: {
            block2: {
                if (!"faultData".equals(hint)) break block2;
                this.builder.setFaultData(value);
                break block3;
            }
            if (!"exceptionName".equals(hint)) break block3;
            String faultClassName = (String)value;
            try {
                Class faultClass = ClassUtils.forName(faultClassName);
                this.builder.setFaultClass(faultClass);
            }
            catch (ClassNotFoundException e) {}
        }
    }
}

