/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$encoding$ser$ArraySerializer == null ? (class$org$apache$axis$encoding$ser$ArraySerializer = ArraySerializer.class$("org.apache.axis.encoding.ser.ArraySerializer")) : class$org$apache$axis$encoding$ser$ArraySerializer).getName());
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$ArraySerializer;
    static /* synthetic */ Class class$java$lang$Object;

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean maxOccursUsage;
        if (value == null) {
            throw new IOException(Messages.getMessage("cantDoNullArray00"));
        }
        MessageContext msgContext = context.getMessageContext();
        SchemaVersion schema = SchemaVersion.SCHEMA_2001;
        SOAPConstants soap = SOAPConstants.SOAP11_CONSTANTS;
        if (msgContext != null) {
            schema = msgContext.getSchemaVersion();
            soap = msgContext.getSOAPConstants();
        }
        Class<?> cls = value.getClass();
        Collection list = null;
        if (!cls.isArray()) {
            if (!(value instanceof Collection)) {
                throw new IOException(Messages.getMessage("cantSerialize00", cls.getName()));
            }
            list = (Collection)value;
        }
        Class componentType = list == null ? cls.getComponentType() : (class$java$lang$Object == null ? (class$java$lang$Object = ArraySerializer.class$("java.lang.Object")) : class$java$lang$Object);
        String dims = "";
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
            dims = soap == SOAPConstants.SOAP12_CONSTANTS ? dims + "* " : dims + "[]";
        }
        QName componentQName = context.getQNameForClass(componentType);
        if (componentQName == null) {
            Class searchCls = componentType;
            while (searchCls != null && componentQName == null) {
                searchCls = searchCls.getSuperclass();
                componentQName = context.getQNameForClass(searchCls);
            }
            if (componentQName != null) {
                componentType = searchCls;
            }
        }
        if (componentQName == null) {
            throw new IOException(Messages.getMessage("noType00", componentType.getName()));
        }
        String prefix = context.getPrefixForURI(componentQName.getNamespaceURI());
        String compType = prefix + ":" + componentQName.getLocalPart();
        int len = list == null ? Array.getLength(value) : list.size();
        String arrayType = soap == SOAPConstants.SOAP12_CONSTANTS ? dims + len : dims + "[" + len + "]";
        boolean enable2Dim = false;
        if (msgContext != null) {
            enable2Dim = JavaUtils.isTrueExplicitly(msgContext.getAxisEngine().getOption("enable2DArrayEncoding"));
        }
        int dim2Len = -1;
        if (enable2Dim && !dims.equals("") && cls.isArray() && len > 0) {
            boolean okay = true;
            int i = 0;
            while (i < len && okay) {
                Object elementValue = Array.get(value, i);
                if (elementValue == null) {
                    okay = false;
                } else if (dim2Len < 0) {
                    dim2Len = Array.getLength(elementValue);
                    if (dim2Len <= 0) {
                        okay = false;
                    }
                } else if (dim2Len != Array.getLength(elementValue)) {
                    okay = false;
                }
                ++i;
            }
            if (okay) {
                dims = dims.substring(0, dims.length() - 2);
                arrayType = soap == SOAPConstants.SOAP12_CONSTANTS ? dims + len + " " + dim2Len : dims + "[" + len + "," + dim2Len + "]";
            } else {
                dim2Len = -1;
            }
        }
        boolean bl = maxOccursUsage = msgContext != null && !msgContext.isEncoded() && componentQName.equals(context.getCurrentXMLType());
        if (!maxOccursUsage) {
            int typeI;
            AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
            if (attrs.getIndex(soap.getEncodingURI(), soap.getAttrItemType()) == -1) {
                String encprefix = context.getPrefixForURI(soap.getEncodingURI());
                if (soap != SOAPConstants.SOAP12_CONSTANTS) {
                    compType = compType + arrayType;
                    attrs.addAttribute(soap.getEncodingURI(), soap.getAttrItemType(), encprefix + ":arrayType", "CDATA", compType);
                } else {
                    attrs.addAttribute(soap.getEncodingURI(), soap.getAttrItemType(), encprefix + ":itemType", "CDATA", compType);
                    attrs.addAttribute(soap.getEncodingURI(), "arraySize", encprefix + ":arraySize", "CDATA", arrayType);
                }
            }
            if ((typeI = attrs.getIndex(schema.getXsiURI(), "type")) != -1) {
                String qname = context.getPrefixForURI(schema.getXsiURI(), "xsi") + ":type";
                QName soapArray = soap == SOAPConstants.SOAP12_CONSTANTS ? Constants.SOAP_ARRAY12 : Constants.SOAP_ARRAY;
                attrs.setAttribute(typeI, schema.getXsiURI(), "type", qname, "CDATA", context.qName2String(soapArray));
            }
            attributes = attrs;
        }
        QName elementName = name;
        Attributes serializeAttr = attributes;
        if (!maxOccursUsage) {
            serializeAttr = null;
            context.startElement(name, attributes);
            elementName = Constants.QNAME_LITERAL_ITEM;
        }
        if (dim2Len < 0) {
            Object aValue;
            if (list == null) {
                int index = 0;
                while (index < len) {
                    aValue = Array.get(value, index);
                    context.serialize(elementName, serializeAttr, aValue, componentQName, true, Boolean.FALSE);
                    ++index;
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    aValue = iterator.next();
                    context.serialize(elementName, serializeAttr, aValue, componentQName, true, Boolean.FALSE);
                }
            }
        } else {
            int index = 0;
            while (index < len) {
                int index2 = 0;
                while (index2 < dim2Len) {
                    Object aValue = Array.get(Array.get(value, index), index2);
                    context.serialize(elementName, null, aValue);
                    ++index2;
                }
                ++index;
            }
        }
        if (!maxOccursUsage) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        String componentTypeName = null;
        Class<?> componentType = null;
        if (javaType.isArray()) {
            String dimString = "[]";
            componentType = javaType.getComponentType();
            if (componentType.isArray()) {
                while (componentType.isArray()) {
                    dimString = dimString + "[]";
                    componentType = componentType.getComponentType();
                }
            } else {
                types.writeType(componentType, null);
            }
            componentTypeName = types.getQNameString(types.getTypeQName(componentType)) + dimString;
        }
        return types.createArrayElement(componentTypeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

