/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;

public class HandlerChainImpl
extends ArrayList
implements HandlerChain {
    private String[] _roles;
    protected List handlerInfos = new ArrayList();
    String[] roles = null;

    public String[] getRoles() {
        return this._roles;
    }

    public void setRoles(String[] roles) {
        this._roles = roles;
    }

    public void init(Map map) {
    }

    public HandlerChainImpl() {
    }

    public HandlerChainImpl(List handlerInfos) {
        this.handlerInfos = handlerInfos;
        int i = 0;
        while (i < handlerInfos.size()) {
            this.add(this.newHandler(this.getHandlerInfo(i)));
            ++i;
        }
    }

    public void addNewHandler(String className, Map config) {
        try {
            HandlerInfo handlerInfo = new HandlerInfo(ClassUtils.forName(className), config, null);
            this.handlerInfos.add(handlerInfo);
            this.add(this.newHandler(handlerInfo));
        }
        catch (Exception ex) {
            String messageText = Messages.getMessage("NoJAXRPCHandler00", className);
            throw new JAXRPCException(messageText, ex);
        }
    }

    public boolean handleFault(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext)_context;
        int i = this.size() - 1;
        while (i >= 0) {
            if (!this.getHandlerInstance(i).handleFault(context)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean handleRequest(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext)_context;
        boolean processFault = false;
        int i = 0;
        while (i < this.size()) {
            Handler currentHandler = this.getHandlerInstance(i);
            if (!currentHandler.handleRequest(context)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (!this.getHandlerInstance(i).handleResponse(context)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public void destroy() {
        int i = 0;
        while (i < this.size()) {
            this.getHandlerInstance(i).destroy();
            ++i;
        }
        this.clear();
    }

    private Handler getHandlerInstance(int index) {
        return (Handler)this.get(index);
    }

    private HandlerInfo getHandlerInfo(int index) {
        return (HandlerInfo)this.handlerInfos.get(index);
    }

    private Handler newHandler(HandlerInfo handlerInfo) {
        try {
            Handler handler = (Handler)handlerInfo.getHandlerClass().newInstance();
            handler.init(handlerInfo);
            return handler;
        }
        catch (Exception ex) {
            String messageText = Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString());
            throw new JAXRPCException(messageText, ex);
        }
    }
}

