/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.wlpi;

import hu.iqsoft.otp.mw.access.LoadBalancer;
import java.io.Serializable;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;

public class WContext
implements Serializable {
    public static final String clientCharacterEncoding = "ISO-8859-2";
    public static final String serverCharacterEncoding = "ISO-8859-2";
    private String WLPIUserName;
    private String WLPIPassword;
    private String WLPIURL;
    private String WLPIOrganization;
    private LoadBalancer loadBalancer = null;
    protected QueueConnectionFactory queueConnectionFactory;
    protected Queue queue;
    private static final String JMS_FACTORY = "weblogic.jms.ConnectionFactory";
    private static final String JMS_QUEUE = "hu.iqsys.EventQueue";

    public void setup(boolean adminPreload) throws Exception {
        this.loadBalancer = new LoadBalancer();
        this.WLPIUserName = this.loadBalancer.getUserName();
        this.WLPIPassword = this.loadBalancer.getPassword();
        this.WLPIOrganization = this.loadBalancer.getOrganization();
        String[] list = this.loadBalancer.getUrlList();
        Context context = null;
        Exception exp = null;
        for (int i = 0; i < list.length; ++i) {
            try {
                this.WLPIURL = list[i];
                context = this.getContext();
            }
            catch (Exception e) {
                exp = e;
            }
            if (context != null) break;
        }
        if (context == null && exp != null) {
            exp.printStackTrace();
        }
    }

    public WContext(String propertyFile, boolean adminPreload) throws Exception {
        ResourceBundle wlpiConnectParameters = ResourceBundle.getBundle(propertyFile);
        this.WLPIUserName = wlpiConnectParameters.getString("WLPIUserName");
        this.WLPIPassword = wlpiConnectParameters.getString("WLPIPassword");
        this.WLPIURL = wlpiConnectParameters.getString("WLPIURL");
        this.WLPIOrganization = wlpiConnectParameters.getString("WLPIOrganization");
        this.setup(adminPreload);
    }

    public WContext(boolean adminPreload) throws Exception {
        this.setup(adminPreload);
    }

    public void initWLPIConnection(boolean adminPreload) throws Exception {
        this.setup(adminPreload);
    }

    public static Context getInitialContext(String user, String password, String url) throws Exception {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        props.put("java.naming.provider.url", url);
        if (user != null) {
            props.put("java.naming.security.principal", user);
            if (password == null) {
                password = "";
            }
            props.put("java.naming.security.credentials", password);
        }
        return new InitialContext(props);
    }

    public void close() {
    }

    public Context getContext() throws Exception {
        Context context = null;
        if (context == null) {
            context = WContext.getInitialContext(this.WLPIUserName, this.WLPIPassword, this.WLPIURL);
        }
        return context;
    }

    public String getWLPIUserName() {
        return this.WLPIUserName;
    }

    public String getWLPIPassword() {
        return this.WLPIPassword;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public String getWLPIOrganization() {
        return this.WLPIOrganization;
    }

    public String getWLPIURL() {
        return this.WLPIURL;
    }

    protected QueueConnectionFactory getQueueConnectionFactory(Context context) throws Exception {
        QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)context.lookup(JMS_FACTORY);
        return queueConnectionFactory;
    }

    public QueueConnectionFactory getQueueConnectionFactory() throws Exception {
        if (this.queueConnectionFactory == null) {
            this.queueConnectionFactory = this.getQueueConnectionFactory(this.getContext());
        }
        return this.queueConnectionFactory;
    }

    protected Queue getQueue(Context context) throws Exception {
        Queue queue = (Queue)context.lookup(JMS_QUEUE);
        return queue;
    }

    public Queue getQueue() throws Exception {
        if (this.queue == null) {
            this.queue = this.getQueue(this.getContext());
        }
        return this.queue;
    }
}

