/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.workflow.wlpi;

import hu.iqsoft.otp.mw.access.LoadBalancer;
import hu.iqsoft.otp.mw.access.WorkflowState;
import hu.iqsoft.otp.workflow.exceptions.GeneralWorkflowException;
import hu.iqsoft.otp.workflow.wlpi.WAnswerFactory;
import hu.iqsoft.otp.workflow.wlpi.WContext;
import hu.iqsoft.otp.workflow.wlpi.WResponse;
import java.io.Serializable;

public class WResponseOfEJB
extends WResponse
implements Serializable {
    private WorkflowState state = null;

    public WResponseOfEJB(String clientTransactionId) {
        super(clientTransactionId);
    }

    public WResponseOfEJB(String clientTransactionId, String templateId) {
        super(clientTransactionId, templateId);
    }

    public boolean acquire(WContext context, boolean blocking, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        LoadBalancer loadBalancer = context.getLoadBalancer();
        long startTime = System.currentTimeMillis();
        try {
            this.state = loadBalancer.getWorkflowState(this.clientTransactionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneralWorkflowException("CANNOT_GET_WORKFLOW_ANSWER", e.getMessage());
        }
        if (this.state.isCompleted()) {
            try {
                this.originalResponse = this.state.getResult();
                this.extractOriginalResponseDOM();
                this.answer = answerFactory.getAnswerInstance(this.state.getTemplateName());
                this.answer.load(this.getOriginalResponseDOM());
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new GeneralWorkflowException("UNKNOWN_WORKFLOW_ANSWER_SCHEMA", e.getMessage());
            }
        }
        if (this.state.isTimeout()) {
            throw new GeneralWorkflowException("WORKFLOW_ANSWER_POLLING_TIMEOUT", "Timeout");
        }
        return false;
    }

    public void acquireSync(WContext context, WorkflowState st, WAnswerFactory answerFactory) throws GeneralWorkflowException {
        this.state = st;
        this.clientTransactionId = this.state.getInstanceId();
        this.instanceId = this.state.getInstanceId();
        try {
            this.originalResponse = this.state.getResult();
            this.extractOriginalResponseDOM();
            this.answer = answerFactory.getAnswerInstance(this.state.getTemplateName());
            this.answer.load(this.getOriginalResponseDOM());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneralWorkflowException("UNKNOWN_WORKFLOW_ANSWER_SCHEMA", e.getMessage());
        }
    }

    public boolean isFinished() {
        if (this.state != null) {
            return this.state.isCompleted();
        }
        return false;
    }

    public String getInstanceId() {
        return this.state.getInstanceId();
    }

    public String getTemplateName() {
        if (this.state == null) {
            return null;
        }
        return this.state.getTemplateName();
    }
}

