/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop;

import com.sun.net.ssl.internal.ssl.Provider;
import hu.iqsoft.otp.webshop.factory.WSAnswerFactory;
import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatokLista;
import hu.iqsoft.otp.webshop.model.WebShopFizetesJovairasValasz;
import hu.iqsoft.otp.webshop.model.WebShopFizetesValasz;
import hu.iqsoft.otp.webshop.model.WebShopKulcsAdatokLista;
import hu.iqsoft.otp.webshop.model.WebShopTranzAzon;
import hu.iqsoft.otp.webshop.mwaccess12.MWAccessPublicSoapBindingStub;
import hu.iqsoft.otp.webshop.mwaccess12.WorkflowState;
import hu.iqsoft.otp.webshop.util.SignatureUtils;
import hu.iqsoft.otp.webshop.util.TransactionLogger;
import hu.iqsoft.otp.webshop.util.WebShopXmlUtils;
import hu.iqsoft.otp.workflow.wlpi.WAnswerFactory;
import hu.iqsoft.otp.workflow.wlpi.WResponse;
import hu.iqsoft.otp.workflow.wlpi.WResponseByDOM;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.Security;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class WebShopService
extends MWAccessPublicSoapBindingStub {
    public static final String WEBSHOP_LIB_VER = "3.4";
    public static final String RESOURCE_BUNDLE = "otp_webshop_client.properties";
    public static final String PROPERTY_PRIVATEKEYFILE = "otp.webshop.PRIVATE_KEY_FILE";
    public static final String PROPERTY_OTPMWSERVERURL = "otp.webshop.OTPMW_SERVER_URL";
    public static final String PROPERTY_HTTPSPROXYHOST = "otp.webshop.client.HTTPS_PROXYHOST";
    public static final String PROPERTY_HTTPSPROXYPORT = "otp.webshop.client.HTTPS_PROXYPORT";
    public static final String PROPERTY_HTTPSPROXYUSER = "otp.webshop.client.HTTPS_PROXYUSER";
    public static final String PROPERTY_HTTPSPROXYPASSWORD = "otp.webshop.client.HTTPS_PROXYPASSWORD";
    public static final String PROPERTY_TRANSACTIONLOGDIR = "otp.webshop.TRANSACTION_LOG_DIR";
    public static final String PROPERTY_MULTIPRIVATEKEY_PREFIX = "otp.webshop.PRIVATE_KEY_FILE_";
    public static final String PROPERTY_MULTITRANSACTIONLOG_PREFIX = "otp.webshop.TRANSACTION_LOG_DIR_";
    public static final String PROPERTY_TRANSACTIONLOG_SUCCESS_DIR = "otp.webshop.transaction_log_dir.SUCCESS_DIR";
    public static final String PROPERTY_TRANSACTIONLOG_FAILED_DIR = "otp.webshop.transaction_log_dir.FAILED_DIR";
    public static final String SERVICEERROR_RESOURCE_NOTFOUND = "EROFORRASLEIROFILE_NEMLETEZIK";
    public static final String SERVICEERROR_PRIVATEKEYFILE_NOTFOUND = "PRIVATKULCSFILE_NEMLETEZIK";
    public static final String LOG_FATALERROR = "FATALISHIBA";
    public static final String SYSTEM_FATALERROR = "RENDSZERHIBA";
    public static final String SERVERERROR_INFO = "SZERVERHIBA";
    protected static final String DEFAULT_DEVIZANEM = "HUF";
    protected static final int RESENDCOUNT = 20;
    protected static final int RESENDDELAY = 500;
    protected static final String[] RESEND_ERRORPATTERN = new String[]{"Maximum workflow number is reached"};
    protected static final WSAnswerFactory ANSWERFACTORY = new WSAnswerFactory();
    protected static Category category = null;
    private static Properties webShopClientProperties;

    public WebShopService() throws AxisFault {
        this(null);
        try {
            String proxyPassword;
            String proxyUser;
            String proxyPort;
            category.debug((Object)"OTPWebShopService p\u00e9ld\u00e1nyos\u00edt\u00e1s...");
            Properties property = WebShopService.getWebShopProperties();
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
            String mwURL = property.getProperty(PROPERTY_OTPMWSERVERURL);
            this.cachedEndpoint = new URL(mwURL);
            category.info((Object)("OTPMW szerver url: " + mwURL));
            String proxyHost = property.getProperty(PROPERTY_HTTPSPROXYHOST);
            if (proxyHost != null && proxyHost.trim().length() != 0) {
                System.setProperty("https.proxyHost", proxyHost);
                category.info((Object)("Kliens https proxy host: " + proxyHost));
            }
            if ((proxyPort = property.getProperty(PROPERTY_HTTPSPROXYPORT)) != null && proxyPort.trim().length() != 0) {
                System.setProperty("https.proxyPort", proxyPort);
                category.info((Object)("Kliens https proxy port: " + proxyPort));
            }
            if ((proxyUser = property.getProperty(PROPERTY_HTTPSPROXYUSER)) != null && proxyUser.trim().length() != 0) {
                System.setProperty("https.proxyUser", proxyUser);
                category.info((Object)("Kliens https proxy user: " + proxyUser));
            }
            if ((proxyPassword = property.getProperty(PROPERTY_HTTPSPROXYPASSWORD)) != null && proxyPassword.trim().length() != 0) {
                System.setProperty("https.proxyPassword", proxyPassword);
                category.info((Object)"Kliens https proxy password: ******");
            }
            category.debug((Object)"OTPWebShopService p\u00e9ld\u00e1nyos\u00edt\u00e1s befejezve...");
        }
        catch (Exception e) {
            category.fatal((Object)LOG_FATALERROR, (Throwable)e);
            e.printStackTrace();
            throw new AxisFault(LOG_FATALERROR, e.getMessage(), null, null);
        }
    }

    public WebShopService(Service service) throws AxisFault {
        super(service);
    }

    protected WResponse getResponse(byte[] response, String worfklow) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(new InputSource(new ByteArrayInputStream(response)));
        WResponseByDOM result = new WResponseByDOM(dom.getDocumentElement(), worfklow);
        return result;
    }

    protected String getErrorsAsList(WResponse response) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < response.getErrors().size(); ++i) {
            result.append((String)response.getErrors().get(i));
            if (i >= response.getErrors().size() - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    protected static Properties getWebShopProperties() throws AxisFault {
        if (webShopClientProperties != null) {
            return webShopClientProperties;
        }
        try {
            InputStream is = WebShopService.class.getClassLoader().getResourceAsStream(RESOURCE_BUNDLE);
            if (is == null) {
                throw new AxisFault(SERVICEERROR_RESOURCE_NOTFOUND, RESOURCE_BUNDLE, null, null);
            }
            Properties props = new Properties();
            props.load(is);
            is.close();
            if (props.getProperty("otp.webshop.debug.ALWAYS_REFRESH_PROPERTIES") == null) {
                webShopClientProperties = props;
            }
            return props;
        }
        catch (IOException ioe) {
            throw new AxisFault(SERVICEERROR_RESOURCE_NOTFOUND, (Throwable)ioe);
        }
    }

    protected String getPrivKeyFileName(Properties properties, String posId) {
        String privKeyFileName = properties.getProperty(PROPERTY_MULTIPRIVATEKEY_PREFIX + posId, null);
        if (privKeyFileName == null || privKeyFileName.trim().length() == 0) {
            privKeyFileName = properties.getProperty(PROPERTY_PRIVATEKEYFILE);
        }
        return privKeyFileName;
    }

    protected String[] getTranLogDir(Properties properties, String posId) {
        String tranLogFailedDir;
        String tranLogSuccessDir;
        String tranLogDir = properties.getProperty(PROPERTY_MULTITRANSACTIONLOG_PREFIX + posId, null);
        if (tranLogDir == null || tranLogDir.trim().length() == 0) {
            tranLogDir = properties.getProperty(PROPERTY_TRANSACTIONLOGDIR);
        }
        if ((tranLogSuccessDir = properties.getProperty("otp.webshop.transaction_log_dir.SUCCESS_DIR_" + posId, null)) == null || tranLogSuccessDir.trim().length() == 0) {
            tranLogSuccessDir = properties.getProperty(PROPERTY_TRANSACTIONLOG_SUCCESS_DIR);
        }
        if ((tranLogFailedDir = properties.getProperty("otp.webshop.transaction_log_dir.FAILED_DIR_" + posId, null)) == null || tranLogFailedDir.trim().length() == 0) {
            tranLogFailedDir = properties.getProperty(PROPERTY_TRANSACTIONLOG_FAILED_DIR);
        }
        return new String[]{tranLogDir, tranLogSuccessDir, tranLogFailedDir};
    }

    protected String getFuncNameToLog(String name) {
        return name;
    }

    @Override
    public void ping() throws AxisFault {
        try {
            category.debug((Object)"ping indul...");
            super.ping();
            category.debug((Object)"ping befejez\u00f6d\u00f6tt.");
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    @Override
    public WorkflowState startWorkflowSynch(String workflowName, String inputXml) throws RemoteException {
        WorkflowState workflowState = null;
        int retryCount = 0;
        while (true) {
            try {
                workflowState = super.startWorkflowSynch(workflowName, inputXml);
            }
            catch (RemoteException e) {
                if (e instanceof AxisFault && retryCount < 20) {
                    AxisFault axisFault = (AxisFault)e;
                    boolean resendAllowed = false;
                    for (int i = 0; i < RESEND_ERRORPATTERN.length && !resendAllowed; ++i) {
                        resendAllowed = axisFault.getFaultReason().indexOf(RESEND_ERRORPATTERN[i]) > -1;
                    }
                    if (!resendAllowed) {
                        throw e;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                } else {
                    throw e;
                }
                category.debug((Object)("SOAP uzenet ismetelt elkuldese [" + workflowName + "]"));
                if (retryCount++ < 20) continue;
            }
            break;
        }
        return workflowState;
    }

    public WebShopTranzAzon tranzakcioAzonositoGeneralas(String posId) throws AxisFault {
        try {
            WebShopTranzAzon result = null;
            category.debug((Object)"tranzakcioAzonositoGeneralas indul...");
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue("WEBSHOPTRANZAZONGENERALAS");
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId};
            byte[] alairasBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String alairas = SignatureUtils.toHex(alairasBytes, 0, alairasBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, alairas, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.debug((Object)(this.getFuncNameToLog("tranzakcioAzonositoGeneralas") + " keres:\n" + domString));
            WorkflowState state = this.startWorkflowSynch("WEBSHOPTRANZAZONGENERALAS", WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("tranzakcioAzonositoGeneralas") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Start: WEBSHOPTRANZAZONGENERALAS with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), "WEBSHOPTRANZAZONGENERALAS");
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("tranzakcioAzonositoGeneralas") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopTranzAzon)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopTranzAzon();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            category.debug((Object)(this.getFuncNameToLog("tranzakcioAzonositoGeneralas") + " sikeresen befejezodott."));
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", (Throwable)e);
        }
    }

    public WebShopFizetesAdatokLista tranzakcioStatuszLekerdezes(String posId, String azonosito, String maxRekordSzam, String idoszakEleje, String idoszakVege, String tranzakcioAllapot) throws AxisFault {
        try {
            WebShopFizetesAdatokLista result;
            category.debug((Object)(this.getFuncNameToLog("tranzakcioStatuszLekerdezes") + " indul."));
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue("WEBSHOPTRANZAKCIOLEKERDEZES");
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TRANSACTIONID, azonosito);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.QUERYMAXRECORDS, maxRekordSzam);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.QUERYSTARTDATE, idoszakEleje);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.QUERYENDDATE, idoszakVege);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.QUERYTRANSTATE, tranzakcioAllapot);
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId, azonosito, maxRekordSzam, idoszakEleje, idoszakVege};
            byte[] autorizaciosKodBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String autorizaciosKod = SignatureUtils.toHex(autorizaciosKodBytes, 0, autorizaciosKodBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, autorizaciosKod, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.debug((Object)(this.getFuncNameToLog("tranzakcioStatuszLekerdezes") + " keres:\n" + domString));
            WorkflowState state = this.startWorkflowSynch("WEBSHOPTRANZAKCIOLEKERDEZES", WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("tranzakcioStatuszLekerdezes") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Finished: WEBSHOPTRANZAKCIOLEKERDEZES with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), "WEBSHOPTRANZAKCIOLEKERDEZES");
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("tranzakcioStatuszLekerdezes") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopFizetesAdatokLista)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopFizetesAdatokLista();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            result.setPosId(posId);
            category.debug((Object)(this.getFuncNameToLog("tranzakcioStatuszLekerdezes") + " sikeresen befejezodott."));
            return result;
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    public WebShopFizetesAdatokLista fizetesiTranzakcio(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, boolean nevKell, boolean orszagKell, boolean megyeKell, boolean telepulesKell, boolean iranyitoszamKell, boolean utcaHazszamKell, boolean mailCimKell, boolean kozlemenyKell, boolean vevoVisszaigazolasKell, boolean ugyfelRegisztracioKell, String regisztraltUgyfelId, String shopMegjegyzes, String backURL, String kereskedoiKozlemeny, String zsebAzonosito, boolean aszinkronFizetes) throws AxisFault {
        return this.fizetesiTranzakcio(posId, azonosito, osszeg, devizanem, nyelvkod, nevKell, orszagKell, megyeKell, telepulesKell, iranyitoszamKell, utcaHazszamKell, mailCimKell, kozlemenyKell, vevoVisszaigazolasKell, ugyfelRegisztracioKell, regisztraltUgyfelId, shopMegjegyzes, backURL, null, kereskedoiKozlemeny, zsebAzonosito, aszinkronFizetes);
    }

    public WebShopFizetesAdatokLista fizetesiTranzakcio(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, boolean nevKell, boolean orszagKell, boolean megyeKell, boolean telepulesKell, boolean iranyitoszamKell, boolean utcaHazszamKell, boolean mailCimKell, boolean kozlemenyKell, boolean vevoVisszaigazolasKell, boolean ugyfelRegisztracioKell, String regisztraltUgyfelId, String shopMegjegyzes, String backURL, boolean ketlepcsosFizetes, String kereskedoiKozlemeny, String zsebAzonosito, boolean aszinkronFizetes) throws AxisFault {
        return this.fizetesiTranzakcio(posId, azonosito, osszeg, devizanem, nyelvkod, nevKell, orszagKell, megyeKell, telepulesKell, iranyitoszamKell, utcaHazszamKell, mailCimKell, kozlemenyKell, vevoVisszaigazolasKell, ugyfelRegisztracioKell, regisztraltUgyfelId, shopMegjegyzes, backURL, (Boolean)ketlepcsosFizetes, kereskedoiKozlemeny, zsebAzonosito, aszinkronFizetes);
    }

    protected WebShopFizetesAdatokLista fizetesiTranzakcio(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, boolean nevKell, boolean orszagKell, boolean megyeKell, boolean telepulesKell, boolean iranyitoszamKell, boolean utcaHazszamKell, boolean mailCimKell, boolean kozlemenyKell, boolean vevoVisszaigazolasKell, boolean ugyfelRegisztracioKell, String regisztraltUgyfelId, String shopMegjegyzes, String backURL, Boolean ketlepcsosFizetes, String kereskedoiKozlemeny, String zsebAzonosito, boolean aszinkronFizetes) throws AxisFault {
        try {
            WebShopFizetesAdatokLista result;
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcio") + " indul..."));
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue(aszinkronFizetes ? WebShopXmlUtils.WF_HAROMSZEREPLOSFIZETESINDITAS : WebShopXmlUtils.WF_HAROMSZEREPLOSFIZETES);
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TRANSACTIONID, azonosito);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.AMOUNT, osszeg);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.EXCHANGE, devizanem);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.LANGUAGECODE, nyelvkod);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.NAMENEEDED, nevKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.COUNTRYNEEDED, orszagKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.COUNTYNEEDED, megyeKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.SETTLEMENTNEEDED, telepulesKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.ZIPCODENEEDED, iranyitoszamKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.STREETNEEDED, utcaHazszamKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.MAILADDRESSNEEDED, mailCimKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.NARRATIONNEEDED, kozlemenyKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CONSUMERRECEIPTNEEDED, vevoVisszaigazolasKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.BACKURL, backURL);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.SHOPCOMMENT, shopMegjegyzes);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CONSUMERREGISTRATIONNEEDED, ugyfelRegisztracioKell);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CONSUMERREGISTRATIONID, regisztraltUgyfelId);
            if (ketlepcsosFizetes != null) {
                WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TWOSTAGED, Boolean.TRUE.equals(ketlepcsosFizetes));
            }
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.MERCHANTNOTICE, kereskedoiKozlemeny);
            if (zsebAzonosito != null) {
                WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CARDPOCKETID, zsebAzonosito);
            }
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId, azonosito, osszeg, devizanem, regisztraltUgyfelId};
            byte[] autorizaciosKodBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String autorizaciosKod = SignatureUtils.toHex(autorizaciosKodBytes, 0, autorizaciosKodBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, autorizaciosKod, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.info((Object)(this.getFuncNameToLog("fizetesiTranzakcio") + " keres:\n" + domString));
            TransactionLogger transLogger = new TransactionLogger(this.getTranLogDir(WebShopService.getWebShopProperties(), posId), category);
            transLogger.logHaromszereplosFizetesInditas(posId, azonosito, osszeg, devizanem, nyelvkod, nevKell, orszagKell, megyeKell, telepulesKell, iranyitoszamKell, utcaHazszamKell, mailCimKell, kozlemenyKell, vevoVisszaigazolasKell, ugyfelRegisztracioKell, regisztraltUgyfelId, shopMegjegyzes, backURL, ketlepcsosFizetes, kereskedoiKozlemeny, zsebAzonosito);
            WorkflowState state = this.startWorkflowSynch(aszinkronFizetes ? WebShopXmlUtils.WF_HAROMSZEREPLOSFIZETESINDITAS : WebShopXmlUtils.WF_HAROMSZEREPLOSFIZETES, WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("fizetesiTranzakcio") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Finished: WEBSHOPFIZETES with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), aszinkronFizetes ? WebShopXmlUtils.WF_HAROMSZEREPLOSFIZETESINDITAS : WebShopXmlUtils.WF_HAROMSZEREPLOSFIZETES);
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcio") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopFizetesAdatokLista)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopFizetesAdatokLista();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            result.setPosId(posId);
            transLogger.logHaromszereplosFizetesBefejezes(posId, azonosito, result);
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcio") + " befejezodott."));
            return result;
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    public WebShopFizetesValasz fizetesiTranzakcioKetszereplos(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, String regisztraltUgyfelId, String kartyaszam, String cvc2cvv2, String kartyaLejarat, String vevoNev, String vevoPostaCim, String vevoIPCim, String ertesitoMail, String ertesitoTel, String kereskedoiKozlemeny, String zsebAzonosito) throws AxisFault {
        return this.fizetesiTranzakcioKetszereplos(posId, azonosito, osszeg, devizanem, nyelvkod, regisztraltUgyfelId, kartyaszam, cvc2cvv2, kartyaLejarat, vevoNev, vevoPostaCim, vevoIPCim, ertesitoMail, ertesitoTel, null, kereskedoiKozlemeny, zsebAzonosito);
    }

    public WebShopFizetesValasz fizetesiTranzakcioKetszereplos(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, String regisztraltUgyfelId, String kartyaszam, String cvc2cvv2, String kartyaLejarat, String vevoNev, String vevoPostaCim, String vevoIPCim, String ertesitoMail, String ertesitoTel, boolean ketlepcsosFizetes, String kereskedoiKozlemeny, String zsebAzonosito) throws AxisFault {
        return this.fizetesiTranzakcioKetszereplos(posId, azonosito, osszeg, devizanem, nyelvkod, regisztraltUgyfelId, kartyaszam, cvc2cvv2, kartyaLejarat, vevoNev, vevoPostaCim, vevoIPCim, ertesitoMail, ertesitoTel, (Boolean)ketlepcsosFizetes, kereskedoiKozlemeny, zsebAzonosito);
    }

    protected WebShopFizetesValasz fizetesiTranzakcioKetszereplos(String posId, String azonosito, String osszeg, String devizanem, String nyelvkod, String regisztraltUgyfelId, String kartyaszam, String cvc2cvv2, String kartyaLejarat, String vevoNev, String vevoPostaCim, String vevoIPCim, String ertesitoMail, String ertesitoTel, Boolean ketlepcsosFizetes, String kereskedoiKozlemeny, String zsebAzonosito) throws AxisFault {
        try {
            WebShopFizetesValasz result;
            category.debug((Object)"fizetesiTranzakcioKetszereplos indul...");
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue("WEBSHOPFIZETESKETSZEREPLOS");
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            if (devizanem == null || devizanem.trim().length() == 0) {
                devizanem = DEFAULT_DEVIZANEM;
            }
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TRANSACTIONID, azonosito);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.AMOUNT, osszeg);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.EXCHANGE, devizanem);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.LANGUAGECODE, nyelvkod);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CONSUMERREGISTRATIONID, regisztraltUgyfelId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CARDNUMBER, kartyaszam);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CVCCVV, cvc2cvv2);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.EXPIRATIONDATE, kartyaLejarat);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.NAME, vevoNev);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.FULLADDRESS, vevoPostaCim);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.IPADDRESS, vevoIPCim);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.MAILADDRESS, ertesitoMail);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TELEPHONE, ertesitoTel);
            if (ketlepcsosFizetes != null) {
                WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TWOSTAGED, Boolean.TRUE.equals(ketlepcsosFizetes));
            }
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.MERCHANTNOTICE, kereskedoiKozlemeny);
            if (zsebAzonosito != null) {
                WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.CARDPOCKETID, zsebAzonosito);
            }
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId, azonosito, osszeg, devizanem, kartyaszam, cvc2cvv2, kartyaLejarat, regisztraltUgyfelId};
            byte[] autorizaciosKodBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String autorizaciosKod = SignatureUtils.toHex(autorizaciosKodBytes, 0, autorizaciosKodBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, autorizaciosKod, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.info((Object)(this.getFuncNameToLog("fizetesiTranzakcioKetszereplos") + " keres:\n" + domString));
            TransactionLogger transLogger = new TransactionLogger(this.getTranLogDir(WebShopService.getWebShopProperties(), posId), category);
            transLogger.logKetszereplosFizetesInditas(posId, azonosito, osszeg, devizanem, nyelvkod, regisztraltUgyfelId, kartyaszam, cvc2cvv2, kartyaLejarat, vevoNev, vevoPostaCim, vevoIPCim, ertesitoMail, ertesitoTel, ketlepcsosFizetes, kereskedoiKozlemeny, zsebAzonosito);
            WorkflowState state = this.startWorkflowSynch("WEBSHOPFIZETESKETSZEREPLOS", WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("fizetesiTranzakcioKetszereplos") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Finished: WEBSHOPFIZETESKETSZEREPLOS with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), "WEBSHOPFIZETESKETSZEREPLOS");
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcioKetszereplos") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopFizetesValasz)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopFizetesValasz();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            result.setPosId(posId);
            result.setAzonosito(azonosito);
            transLogger.logKetszereplosFizetesBefejezes(posId, azonosito, result);
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcioKetszereplos") + " befejezodott."));
            return result;
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault(SYSTEM_FATALERROR, e.getMessage(), null, null);
        }
    }

    public WebShopFizetesValasz fizetesiTranzakcioLezaras(String posId, String azonosito, boolean jovahagyo, String osszeg) throws AxisFault {
        try {
            WebShopFizetesValasz result;
            category.debug((Object)"fizetesiTranzakcioLezaras indul...");
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue(WebShopXmlUtils.WF_KETLEPCSOSFIZETESLEZARAS);
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TRANSACTIONID, azonosito);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.APPROVED, jovahagyo);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.AMOUNT, osszeg);
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId, azonosito};
            byte[] autorizaciosKodBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String autorizaciosKod = SignatureUtils.toHex(autorizaciosKodBytes, 0, autorizaciosKodBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, autorizaciosKod, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.info((Object)(this.getFuncNameToLog("fizetesiTranzakcioLezaras") + " keres:\n" + domString));
            TransactionLogger transLogger = new TransactionLogger(this.getTranLogDir(WebShopService.getWebShopProperties(), posId), category);
            transLogger.logFizetesLezarasInditas(posId, azonosito, jovahagyo, osszeg);
            WorkflowState state = this.startWorkflowSynch(WebShopXmlUtils.WF_KETLEPCSOSFIZETESLEZARAS, WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("fizetesiTranzakcioLezaras") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Finished: " + WebShopXmlUtils.WF_KETLEPCSOSFIZETESLEZARAS + " with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), WebShopXmlUtils.WF_KETLEPCSOSFIZETESLEZARAS);
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcioLezaras") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopFizetesValasz)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopFizetesValasz();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            result.setPosId(posId);
            transLogger.logFizetesLezarasBefejezes(azonosito, result);
            category.debug((Object)(this.getFuncNameToLog("fizetesiTranzakcioLezaras") + " befejezodott."));
            return result;
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    public WebShopFizetesJovairasValasz fizetesJovairas(String posId, String tranzakcioAzonosito, String osszeg) throws AxisFault {
        try {
            WebShopFizetesJovairasValasz result;
            category.debug((Object)"fizetesJovairas indul...");
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue(WebShopXmlUtils.WF_WEBSHOPFIZETESJOVAIRAS);
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.TRANSACTIONID, tranzakcioAzonosito);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.AMOUNT, osszeg);
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId, tranzakcioAzonosito, osszeg};
            byte[] autorizaciosKodBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String autorizaciosKod = SignatureUtils.toHex(autorizaciosKodBytes, 0, autorizaciosKodBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, autorizaciosKod, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.info((Object)(this.getFuncNameToLog("fizetesJovairas") + " keres:\n" + domString));
            TransactionLogger transLogger = new TransactionLogger(this.getTranLogDir(WebShopService.getWebShopProperties(), posId), category);
            transLogger.logFizetesJovairasInditas(posId, tranzakcioAzonosito, osszeg);
            WorkflowState state = this.startWorkflowSynch(WebShopXmlUtils.WF_WEBSHOPFIZETESJOVAIRAS, WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("fizetesJovairas") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Finished: " + WebShopXmlUtils.WF_WEBSHOPFIZETESJOVAIRAS + " with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), WebShopXmlUtils.WF_WEBSHOPFIZETESJOVAIRAS);
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("fizetesJovairas") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopFizetesJovairasValasz)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopFizetesJovairasValasz();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            transLogger.logFizetesJovairasBefejezes(tranzakcioAzonosito, result);
            category.debug((Object)(this.getFuncNameToLog("fizetesJovairas") + " befejezodott."));
            return result;
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    public WebShopKulcsAdatokLista kulcsLekerdezes(String posId, String muvelet) throws AxisFault {
        try {
            WebShopKulcsAdatokLista result = null;
            category.debug((Object)"kulcsLekerdezes indul...");
            Document dom = WebShopXmlUtils.getRequestSkeleton();
            Text templateNameText = dom.createTextNode(WebShopXmlUtils.TEMPLATENAME_TAGNAME);
            templateNameText.setNodeValue(WebShopXmlUtils.WF_WEBSHOPKULCSLEKERDEZES);
            Node templateName = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.TEMPLATENAME_TAGNAME).item(0);
            templateName.appendChild(templateNameText);
            Node variables = dom.getDocumentElement().getElementsByTagName(WebShopXmlUtils.VARIABLES_TAGNAME).item(0);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.POSID, posId);
            WebShopXmlUtils.addParameter(dom, variables, WebShopXmlUtils.MUVELET, muvelet);
            byte[] pkcs8PrivateKey = SignatureUtils.loadPrivateKey(this.getPrivKeyFileName(WebShopService.getWebShopProperties(), posId));
            String[] fields = new String[]{posId, muvelet};
            byte[] autorizaciosKodBytes = SignatureUtils.generateSignature(SignatureUtils.getByteArray(fields), pkcs8PrivateKey);
            String autorizaciosKod = SignatureUtils.toHex(autorizaciosKodBytes, 0, autorizaciosKodBytes.length);
            WebShopXmlUtils.addParameterWithAttrs(dom, variables, WebShopXmlUtils.CLIENTSIGNATURE, autorizaciosKod, this.createSignatureAttr());
            String domString = WebShopXmlUtils.DOMToXMLString(dom);
            category.info((Object)(this.getFuncNameToLog("kulcsLekerdezes") + " keres:\n" + domString));
            TransactionLogger transLogger = new TransactionLogger(this.getTranLogDir(WebShopService.getWebShopProperties(), posId), category);
            transLogger.logKulcsLekerdezesInditas(posId, muvelet);
            WorkflowState state = this.startWorkflowSynch(WebShopXmlUtils.WF_WEBSHOPKULCSLEKERDEZES, WebShopXmlUtils.DOMToXMLString(dom));
            category.info((Object)(this.getFuncNameToLog("kulcsLekerdezes") + " folyamat azonosio: " + state.getInstanceId()));
            System.out.println("Finished: " + WebShopXmlUtils.WF_WEBSHOPKULCSLEKERDEZES + " with " + state.getInstanceId() + " at " + new Date());
            WResponse response = this.getResponse(state.getResult(), WebShopXmlUtils.WF_WEBSHOPKULCSLEKERDEZES);
            domString = WebShopXmlUtils.DOMToXMLString(response.getOriginalResponseDOM().getOwnerDocument());
            category.debug((Object)(this.getFuncNameToLog("kulcsLekerdezes") + " valasz:\n" + domString));
            response.acquire(null, false, (WAnswerFactory)ANSWERFACTORY);
            if (response.isSuccessful()) {
                result = (WebShopKulcsAdatokLista)response.getAnswer().getData();
                result.setValaszKod("SIKER");
            } else {
                result = new WebShopKulcsAdatokLista();
                result.setValaszKod(this.getErrorsAsList(response));
            }
            transLogger.logKulcsLekerdezesBefejezes(posId, result);
            category.debug((Object)(this.getFuncNameToLog("kulcsLekerdezes") + " befejezodott."));
            return result;
        }
        catch (Exception e) {
            category.warn((Object)SERVERERROR_INFO, (Throwable)e);
            throw new AxisFault("", e.getMessage(), null, null);
        }
    }

    private Map createSignatureAttr() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(WebShopXmlUtils.ALGORITHM, WebShopXmlUtils.SHA2);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            InputStream is = WebShopService.class.getClassLoader().getResourceAsStream(RESOURCE_BUNDLE);
            if (is == null) {
                throw new AxisFault(SERVICEERROR_RESOURCE_NOTFOUND, RESOURCE_BUNDLE, null, null);
            }
            Properties props = new Properties();
            props.load(is);
            is.close();
            PropertyConfigurator.configure((Properties)props);
            System.out.println("OTPWebShopService naplozas inicializalva.");
        }
        catch (Exception ex) {
            System.out.println("Hiba az OTPWebShopService loggolas inicializalasa kozben.\n" + ex.getMessage());
        }
        category = Category.getInstance((String)"WebShopClient");
        Class<MWAccessPublicSoapBindingStub> clazz = MWAccessPublicSoapBindingStub.class;
        synchronized (MWAccessPublicSoapBindingStub.class) {
            if (MWAccessPublicSoapBindingStub.category == null) {
                MWAccessPublicSoapBindingStub.category = category;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
            AxisProperties.setClassDefault(SecureSocketFactory.class, (String)"hu.iqsoft.otp.webshop.util.NoClientAuthJSSESocketFactory");
            return;
        }
    }
}

