/*
 * Decompiled with CFR 0.152.
 */
package hu.iqsoft.otp.webshop.util;

import hu.iqsoft.otp.webshop.util.SSLUtils;
import hu.iqsoft.otp.webshop.util.TransactionState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import sun.misc.BASE64Decoder;

public class SoapUtils {
    public static SOAPMessage createPingMessage() throws SOAPException {
        MessageFactory messagefactory = MessageFactory.newInstance();
        SOAPMessage message = messagefactory.createMessage();
        SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
        envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        header.detachNode();
        Name methodName = envelope.createName("ping", "ns1", "java:hu.iqsoft.otp.mw.access");
        SOAPBodyElement bodyelement = body.addBodyElement(methodName);
        return message;
    }

    public static SOAPMessage createWorkflowStarterMessage(String workflowName, String inputXml) throws SOAPException {
        MessageFactory messagefactory = MessageFactory.newInstance();
        SOAPMessage message = messagefactory.createMessage();
        SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
        envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        header.detachNode();
        Name methodName = envelope.createName("startWorkflowSynch", "ns1", "java:hu.iqsoft.otp.mw.access");
        SOAPBodyElement bodyelement = body.addBodyElement(methodName);
        Name arg0 = envelope.createName("arg0");
        SOAPElement element0 = bodyelement.addChildElement(arg0);
        element0.addTextNode(workflowName);
        Name arg1 = envelope.createName("arg1");
        SOAPElement element1 = bodyelement.addChildElement(arg1);
        element1.addTextNode(inputXml);
        return message;
    }

    public static String soapMessageToString(SOAPMessage message) {
        String result = null;
        try {
            ByteArrayOutputStream sentOs = new ByteArrayOutputStream();
            message.writeTo((OutputStream)sentOs);
            result = sentOs.toString("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static SOAPMessage callSOAP(SOAPMessage message, String url) throws SOAPException {
        SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = connectionFactory.createConnection();
        SOAPMessage answer = connection.call(message, (Object)url);
        connection.close();
        return answer;
    }

    public static SOAPMessage callSOAP(SOAPMessage message, HttpURLConnection conn) throws ProtocolException, IOException, SOAPException {
        SOAPMessage answer = SSLUtils.sendMessageViaURLConnection(message, conn);
        return answer;
    }

    public static TransactionState processWorkflowAnswer(SOAPMessage answer) throws SOAPException, IOException {
        TransactionState state = null;
        SOAPEnvelope envelope = answer.getSOAPPart().getEnvelope();
        SOAPBody body = envelope.getBody();
        if (body.hasFault()) {
            throw new SOAPException(body.getFault().getFaultCode() + "\n" + body.getFault().getFaultString());
        }
        SOAPElement method = (SOAPElement)body.getChildElements().next();
        SOAPElement returnData = (SOAPElement)method.getChildElements().next();
        Iterator returnDataIterator = returnData.getChildElements();
        SOAPElement resultData = null;
        SOAPElement templateNameData = null;
        SOAPElement endTimeData = null;
        SOAPElement completedData = null;
        SOAPElement startTimeData = null;
        SOAPElement transactionIdData = null;
        SOAPElement timeoutData = null;
        while (returnDataIterator.hasNext()) {
            SOAPElement soapElement = (SOAPElement)returnDataIterator.next();
            String localName = soapElement.getElementName().getLocalName();
            if ("result".equals(localName)) {
                resultData = soapElement;
                continue;
            }
            if ("templateName".equals(localName)) {
                templateNameData = soapElement;
                continue;
            }
            if ("endTime".equals(localName)) {
                endTimeData = soapElement;
                continue;
            }
            if ("completed".equals(localName)) {
                completedData = soapElement;
                continue;
            }
            if ("startTime".equals(localName)) {
                startTimeData = soapElement;
                continue;
            }
            if ("instanceId".equals(localName)) {
                transactionIdData = soapElement;
                continue;
            }
            if (!"timeout".equals(localName)) continue;
            timeoutData = soapElement;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] resultBytes = decoder.decodeBuffer(resultData.getValue());
        state = new TransactionState(transactionIdData.getValue(), startTimeData.getValue(), endTimeData.getValue(), resultBytes, timeoutData.getValue());
        return state;
    }
}

