Unit uDigitalSignature;

Interface

Uses Windows, SysUtils, WinCrypt, Dialogs, Classes;

function generateSignature(CertificateName, DataBlock: String): String;
function getCertificates(): TStrings;

Implementation

Function GetErrorMessage(ErrorCode: Cardinal): String;
Var
  MessageBuffer: PAnsiChar;
Begin
  MessageBuffer:= StrAlloc(256);
  FormatMessage($1300, Nil, ErrorCode, $0409, @MessageBuffer, 256, Nil);
  Result:= 'ErrorCode: 0x' + IntToHex(ErrorCode, 2) + ' - ' + StrPas(MessageBuffer);
end;

function GetCertificates(): TStrings;
var
  CryptProvider: Cardinal;
  CertificationContext: PCCERT_CONTEXT;
  CertificationStore: Pointer;
  count: dword;
  i: integer;
  p: PByte;
  pszNameString: PAnsiChar;
begin
  result := TStringList.Create();

  CryptProvider:= 0;
  CertificationStore:= CertOpenSystemStore(CryptProvider, 'MY');
  if Assigned(CertificationStore) then begin
    CertificationContext:= nil;
    CertificationContext :=
      CertEnumCertificatesInStore(CertificationStore, CertificationContext);
    while (assigned(CertificationContext)) do begin

      if CryptFindCertificateKeyProvInfo(CertificationContext, 0, nil) then begin

        pszNameString := StrAlloc(128);

        CertGetNameString(
           CertificationContext,
           CERT_NAME_SIMPLE_DISPLAY_TYPE,
           0,
           nil,
           pszNameString,
           128);

        result.Add(pszNameString);

        StrDispose(pszNameString);
      end;

      CertificationContext :=
        CertEnumCertificatesInStore(CertificationStore, CertificationContext);
    end;

  end;
end;

Function GenerateSignature(CertificateName, DataBlock: String): String;
Var
  CertificationContext: PCCERT_CONTEXT;
  CertificationStore: Pointer;
  CryptProvider, KeyIdentifier, HashHandle, SignatureLength: Cardinal;
  MyIssuerName: PWideChar;
  CallerFree: LongBool;
  Signature: String;
  I: Integer;
Begin
  MyIssuerName:= AllocMem(128);

  MyIssuerName:= StringToWideChar(CertificateName, MyIssuerName, 128);
  CryptProvider:= 0;
//  Try
// ***** Opening certificate store
    CertificationStore:= CertOpenSystemStore(CryptProvider, 'MY');
    If Not Assigned(CertificationStore) Then Raise Exception.Create(GetErrorMessage(GetLastError));
// ***** Retrieving certificate
    CertificationContext:= Nil;
    CertificationContext:= CertFindCertificateInStore(CertificationStore, $10001, 0, CERT_FIND_SUBJECT_STR, MyIssuerName, CertificationContext);
    If Assigned(CertificationContext) Then
    Begin
      If Not CryptFindCertificateKeyProvInfo(CertificationContext, 0, Nil) Then Raise Exception.Create('Private key information not found.');
// ***** Opening CSP (Cryptographic Service Provider) according to certificate
      If Not CryptAcquireCertificatePrivateKey(CertificationContext, 0, Nil, CryptProvider, KeyIdentifier, CallerFree) Then Raise Exception.Create(GetErrorMessage(GetLastError));
      If KeyIdentifier <> AT_SIGNATURE Then Raise Exception.Create('Private key is not dedicated for signing.');
// ***** Creating hash object
      If Not CryptCreateHash(CryptProvider, CALG_MD5, 0, 0, HashHandle) Then Raise Exception.Create('CryptCreateHash: ' + GetErrorMessage(GetLastError));
// ***** Hashing data
      If Not CryptHashData(HashHandle, @DataBlock[1], Length(DataBlock), 0) Then Raise Exception.Create('CryptHashData: ' + GetErrorMessage(GetLastError));
// ***** Signing hash, we suppose length of signature is 128, so we don't need to query it.
      SignatureLength:= 128;
      SetLength(Signature, SignatureLength);
      If Not CryptSignHash(HashHandle, AT_SIGNATURE, '', 0, @Signature[1], SignatureLength) Then Raise Exception.Create('CryptSignHash: ' + GetErrorMessage(GetLastError));
// ***** Converting little-endian to big-endian
      For I:= SignatureLength Downto 1 Do Result:= Result + IntToHex(Ord(Signature[I]), 2);
// ***** Cleanig up environment
      CryptDestroyHash(HashHandle);
    end;
    If CallerFree Then CryptReleaseContext(CryptProvider, 0);
    CertFreeCertificateContext(CertificationContext);
    CertCloseStore(CertificationStore, CERT_CLOSE_STORE_CHECK_FLAG);
end;

end.
 