unit uRequestIndicator;

interface

uses
  Classes,
  ComCtrls;

type
  TRequestIndicator = class(TThread)
  public
    constructor Create(progressInd: TProgressBar;
                       createSuspended: boolean);
  private
    progressInd: TProgressBar;
  private
    procedure updateIndicator();
  protected
    procedure Execute; override;
  end;

implementation

uses SysUtils;

{ TRequestIndicator }

procedure TRequestIndicator.Execute;
begin
  { Place thread code here }
  repeat
    Synchronize(updateIndicator);
    sleep(100);
  until Self.Terminated;
end;

constructor TRequestIndicator.Create(progressInd: TProgressBar;
                                     createSuspended: boolean);
begin
  inherited Create(createSuspended);
  self.progressInd := progressInd;
  self.FreeOnTerminate := true;
end;

procedure TRequestIndicator.updateIndicator;
begin
  if (progressInd.Position = progressInd.Max) then
    progressInd.Step := -1;
  if (progressInd.Position = progressInd.Min) then
    progressInd.Step := 1;
  progressInd.StepIt();
  progressInd.Refresh();
end;

end.
