unit uRequestStarter;

interface

uses
  uRequestIndicator,
  uMWAccess,
  Classes,
  ComCtrls
  {$IFDEF MSWINDOWS}, Windows {$ENDIF};

type
  TCommProcedure = procedure (Sender: TObject) of object;

type
  TRequestStarter = class(TThread)
  public
    constructor Create(transactionStarter: TCommProcedure;
                       requestStarterThreadDone: TCommProcedure;
                       progressInd: TProgressBar;
                       createSuspended: boolean);
  private
    procedure SetName;
  private
    progressInd: TProgressBar;
    indicator: TRequestIndicator;
    transactionStarter: TCommProcedure;
    requestStarterThreadDone: TCommProcedure;
  protected
    resultState: WorkflowState;
  protected
    procedure Execute; override;
  end;

implementation

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure RequestStarter.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{$IFDEF MSWINDOWS}
type
  TThreadNameInfo = record
    FType: LongWord;     // must be 0x1000
    FName: PChar;        // pointer to name (in user address space)
    FThreadID: LongWord; // thread ID (-1 indicates caller thread)
    FFlags: LongWord;    // reserved for future use, must be zero
  end;
{$ENDIF}

{ RequestStarter }

procedure TRequestStarter.SetName;
{$IFDEF MSWINDOWS}
var
  ThreadNameInfo: TThreadNameInfo;
{$ENDIF}
begin
{$IFDEF MSWINDOWS}
  ThreadNameInfo.FType := $1000;
  ThreadNameInfo.FName := 'OTPWSRequestStarterThread';
  ThreadNameInfo.FThreadID := $FFFFFFFF;
  ThreadNameInfo.FFlags := 0;

  try
    RaiseException( $406D1388, 0, sizeof(ThreadNameInfo) div sizeof(LongWord), @ThreadNameInfo );
  except
  end;
{$ENDIF}
end;

procedure TRequestStarter.Execute;
begin
  SetName;
  { Place thread code here }
  indicator := TRequestIndicator.Create(progressInd, false);
  transactionStarter(self);
  indicator.Terminate();
  requestStarterThreadDone(self);
  Terminate();
end;

constructor TRequestStarter.Create(transactionStarter: TCommProcedure;
                                   requestStarterThreadDone: TCommProcedure;
                                   progressInd: TProgressBar;
                                   createSuspended: boolean);
begin
  inherited Create(createSuspended);
  self.transactionStarter := transactionStarter;
  self.requestStarterThreadDone := requestStarterThreadDone;
  self.progressInd := progressInd;
  self.FreeOnTerminate := false;
end;

end.
