unit uTransformator;

interface

  uses Classes;

  var
    wf3TranInputXmlTransformator: TStrings;
    wf2TranInputXmlTransformator: TStrings;
    trIdGenTranInputXmlTransformator: TStrings;
    trLekTranInputXmlTransformator: TStrings;
    wfLezarasTranInputXmlTransformator: TStrings;
    trFizJovairasInputXmlTransformator: TStrings;
  var
    WFXML_TRANSLATOR: array [0..5] of TStrings;

  var
    wf3TranOutputXmlTransformator: TStrings;
    wf2TranOutputXmlTransformator: TStrings;
    trIdGenTranOutputXmlTransformator: TStrings;
    trLekTranOutputXmlTransformator: TStrings;
    wfLezarasTranOutputXmlTransformator: TStrings;
    trFizJovairasOutputXmlTransformator: TStrings;

  var
    OUTPUTXML_TRANSLATOR: array [0..5] of TStrings;

implementation

  const strWf3TranInputXmlTransformator: string =
    'posId=isPOSID'                                         + #$0D#$0A +
    'tranz.azon=isTransactionID'                            + #$0D#$0A +
    'osszeg=isAmount'                                       + #$0D#$0A +
    'devizanem=isExchange'                                  + #$0D#$0A +
    'cafeteriaKartyazsebAzon=isCardPocketId'                + #$0D#$0A +
    'nyelvkod=isLanguageCode'                               + #$0D#$0A +
    'regisztraltUgyfelId=isConsumerRegistrationID'          + #$0D#$0A +
    'ugyfelRegisztracioKell=isConsumerRegistrationNeeded'   + #$0D#$0A +
    'nevKell=isNameNeeded'                                  + #$0D#$0A +
    'orszagKell=isCountryNeeded'                            + #$0D#$0A +
    'megyeKell=isCountyNeeded'                              + #$0D#$0A +
    'telepulesKell=isSettlementNeeded'                      + #$0D#$0A +
    'utcaHazszamKell=isStreetNeeded'                        + #$0D#$0A +
    'iranyitoszamKell=isZipcodeNeeded'                      + #$0D#$0A +
    'kozlemenyKell=isNarrationNeeded'                       + #$0D#$0A +
    'mailCimKell=isMailAddressNeeded'                       + #$0D#$0A +
    'vevoVisszaigazolasKell=isConsumerReceiptNeeded'        + #$0D#$0A +
    'backURL=isBackURL'                                     + #$0D#$0A +
    'ketlepcsos=isTwoStaged'                                + #$0D#$0A +
    'shopMegjegyzes=isShopComment'                          + #$0D#$0A +
    'kereskedoiKozlemeny=isMerchantNotice'                  + #$0D#$0A;

  const strWf2TranInputXmlTransformator: string =
    'posId=isPOSID'                                         + #$0D#$0A +
    'tranz.azon=isTransactionID'                            + #$0D#$0A +
    'osszeg=isAmount'                                       + #$0D#$0A +
    'devizanem=isExchange'                                  + #$0D#$0A +
    'nyelvkod=isLanguageCode'                               + #$0D#$0A +
    'regisztraltUgyfelId=isConsumerRegistrationID'          + #$0D#$0A +
    'kartyaszam=isCardNumber'                               + #$0D#$0A +
    'cvc2cvv2=isCVCCVV'                                     + #$0D#$0A +
    'kartyaLejarat=isExpirationDate'                        + #$0D#$0A +
    'vevoNev=isName'                                        + #$0D#$0A +
    'vevoPostaCim=isFullAddress'                            + #$0D#$0A +
    'vevoIPCim=isIPAddress'                                 + #$0D#$0A +
    'ertesitoMail=isMailAddress'                            + #$0D#$0A +
    'ertesitoTel=isTelephone'                               + #$0D#$0A +
    'ketlepcsos=isTwoStaged'                                + #$0D#$0A +
    'kereskedoiKozlemeny=isMerchantNotice'                  + #$0D#$0A;

  const strWfLezarasTranInputXmlTransformator: string =
    'posId=isPOSID'                                         + #$0D#$0A +
    'tranz.azon=isTransactionID'                            + #$0D#$0A +
    'jovahagyo=isApproval'                                  + #$0D#$0A +
    'osszeg=isAmount'                                       + #$0D#$0A;

  const strTrIdGenTranInputXmlTransformator: string =
    'posId=isPOSID';

  const strTrLekTranInputXmlTransformator: string =
    'posId=isPOSID'                                         + #$0D#$0A +
    'tranz.azon=isTransactionID'                            + #$0D#$0A +
    'maxRekordSzam=isMaxRecords'                            + #$0D#$0A +
    'idoszakEleje=isStartDate'                              + #$0D#$0A +
    'idoszakVege=isEndDate'                                 + #$0D#$0A;

  const strFizJovairasTranInputXmlTransformator: string =
    'posId=isPOSID'                                         + #$0D#$0A +
    'tranz.azon=isTransactionID'                            + #$0D#$0A +
    'osszeg=isAmount'                                       + #$0D#$0A;

  const strWf3TranOutputXmlTransformator: string =
    'posid=posId'                         + #$0D#$0A +
    'transactionId=tranz.azon'            + #$0D#$0A +
    'timestamp=teljesites'                + #$0D#$0A +
    'authorizationcode=authorizaciosKod'  + #$0D#$0A +
    'name=nev'                            + #$0D#$0A +
    'country=orszag'                      + #$0D#$0A +
    'county=megye'                        + #$0D#$0A +
    'settlement=telepules'                + #$0D#$0A +
    'street=utcaHazszam'                  + #$0D#$0A +
    'zipcode=iranyitoszam'                + #$0D#$0A +
    'narration=kozlemeny'                 + #$0D#$0A +
    'mailaddress=mailCim'                 + #$0D#$0A +
    'cardcountrycode=kartyakibocsatoOrszag';

  const strWf2TranOutputXmlTransformator: string =
    'posid=posId'                         + #$0D#$0A +
    'transactionId=tranz.azon'            + #$0D#$0A +
    'timestamp=teljesites'                + #$0D#$0A +
    'posresponsecode=valaszKod'           + #$0D#$0A +
    'authorizationcode=authorizaciosKod'  + #$0D#$0A +
    'cardcountrycode=kartyakibocsatoOrszag';

  const strWfLezarasTranOutputXmlTransformator: string =
    'posid=posId'                         + #$0D#$0A +
    'transactionId=tranz.azon'            + #$0D#$0A +
    'timestamp=teljesites'                + #$0D#$0A +
    'posresponsecode=valaszKod'           + #$0D#$0A +
    'authorizationcode=authorizaciosKod';

  const strTrIdGenTranOutputXmlTransformator: string =
    'posid=posId'                         + #$0D#$0A +
    'id=tranz.azon'                       + #$0D#$0A +
    'timestamp=teljesites';

  const strTrLekTranOutputXmlTransformator: string =
    'posid=posId'                         + #$0D#$0A +
    'transactionid=tranz.azon'            + #$0D#$0A +
    'state=statuszKod'                    + #$0D#$0A +
    'responsecode=posValaszkod'           + #$0D#$0A +
    'shopinformed=shopErtesitve'          + #$0D#$0A +
    'authorizationcode=authorizaciosKod'  + #$0D#$0A +
    'startdate=tran.indulas'              + #$0D#$0A +
    'enddate=teljesites'                  + #$0D#$0A +
    'exchange=devizanem'                  + #$0D#$0A +
    'amount=osszeg'                       + #$0D#$0A +
    'shopcomment=shopMegjegyzes'          + #$0D#$0A +
    'backurl=backURL'                     + #$0D#$0A +
    'languagecode=nyelvkod'               + #$0D#$0A +
    'nameneeded=nevKell'                  + #$0D#$0A +
    'name=nev'                            + #$0D#$0A +
    'zipcodeneeded=iranyitoszamKell'      + #$0D#$0A +
    'zipcode=iranyitoszam'                + #$0D#$0A +
    'countryneeded=orszagKell'            + #$0D#$0A +
    'country=orszag'                      + #$0D#$0A +
    'countyneeded=megyeKell'              + #$0D#$0A +
    'county=megye'                        + #$0D#$0A +
    'settlementneeded=telepulesKell'      + #$0D#$0A +
    'settlement=telepules'                + #$0D#$0A +
    'streetneeded=utcaHazszamKell'        + #$0D#$0A +
    'street=utcaHazszam'                  + #$0D#$0A +
    'narrationneeded=kozlemenyKell'       + #$0D#$0A +
    'narration=kozlemeny'                 + #$0D#$0A +
    'mailaddressneeded=mailCimKell'       + #$0D#$0A +
    'mailaddress=mailCim'                 + #$0D#$0A +
    'consumerregistrationid=regisztaltUgyfelId' + #$0D#$0A +
    'consumerregistrationneeded=ugyfelRegisztracioKell' + #$0D#$0A +
    'twostaged=ketlepcsos'                + #$0D#$0A +
    'consumerreceiptneeded=vevoVisszaigazolasKell'      + #$0D#$0A +
    'fulladdress=VevoPostaCim'                          + #$0D#$0A +
    'telephone=ertesitoTel'                             + #$0D#$0A +
    'cardcountrycode=kartyakibocsatoOrszag'             + #$0D#$0A +
    'merchantNotice=kereskedoiKozlemeny'                + #$0D#$0A;


  const strFizJovairasTranOutputXmlTransformator: string =
    'mwtransactionid=tranz.azon'                             + #$0D#$0A +
    'authorizationcode=authorizaciosKod'                    + #$0D#$0A +
    'responsecode=valasz.kod'                               + #$0D#$0A;


initialization
  wf3TranInputXmlTransformator := TStringList.Create();
  wf3TranInputXmlTransformator.NameValueSeparator := '=';
  wf3TranInputXmlTransformator.CommaText := #$0D#$0A;
  wf3TranInputXmlTransformator.Text := strWf3TranInputXmlTransformator;

  wf2TranInputXmlTransformator := TStringList.Create();
  wf2TranInputXmlTransformator.NameValueSeparator := '=';
  wf2TranInputXmlTransformator.CommaText := #$0D#$0A;
  wf2TranInputXmlTransformator.Text := strWf2TranInputXmlTransformator;

  wfLezarasTranInputXmlTransformator := TStringList.Create();
  wfLezarasTranInputXmlTransformator.NameValueSeparator := '=';
  wfLezarasTranInputXmlTransformator.CommaText := #$0D#$0A;
  wfLezarasTranInputXmlTransformator.Text := strWfLezarasTranInputXmlTransformator;

  trIdGenTranInputXmlTransformator := TStringList.Create();
  trIdGenTranInputXmlTransformator.NameValueSeparator := '=';
  trIdGenTranInputXmlTransformator.CommaText := #$0D#$0A;
  trIdGenTranInputXmlTransformator.Text := strTrIdGenTranInputXmlTransformator;

  trLekTranInputXmlTransformator := TStringList.Create();
  trLekTranInputXmlTransformator.NameValueSeparator := '=';
  trLekTranInputXmlTransformator.CommaText := #$0D#$0A;
  trLekTranInputXmlTransformator.Text := strTrLekTranInputXmlTransformator;

  trFizJovairasInputXmlTransformator := TStringList.Create();
  trFizJovairasInputXmlTransformator.NameValueSeparator := '=';
  trFizJovairasInputXmlTransformator.CommaText := #$0D#$0A;
  trFizJovairasInputXmlTransformator.Text :=   strFizJovairasTranInputXmlTransformator;



  WFXML_TRANSLATOR[0] := wf3TranInputXmlTransformator;
  WFXML_TRANSLATOR[1] := wf2TranInputXmlTransformator;
  WFXML_TRANSLATOR[2] := trIdGenTranInputXmlTransformator;
  WFXML_TRANSLATOR[3] := trLekTranInputXmlTransformator;
  WFXML_TRANSLATOR[4] := wfLezarasTranInputXmlTransformator;
  WFXML_TRANSLATOR[5] := trFizJovairasInputXmlTransformator;

  wf3TranOutputXmlTransformator := TStringList.Create();
  wf3TranOutputXmlTransformator.NameValueSeparator := '=';
  wf3TranOutputXmlTransformator.CommaText := #$0D#$0A;
  wf3TranOutputXmlTransformator.Text := strWf3TranOutputXmlTransformator;

  wf2TranOutputXmlTransformator := TStringList.Create();
  wf2TranOutputXmlTransformator.NameValueSeparator := '=';
  wf2TranOutputXmlTransformator.CommaText := #$0D#$0A;
  wf2TranOutputXmlTransformator.Text := strWf2TranOutputXmlTransformator;

  wfLezarasTranOutputXmlTransformator := TStringList.Create();
  wfLezarasTranOutputXmlTransformator.NameValueSeparator := '=';
  wfLezarasTranOutputXmlTransformator.CommaText := #$0D#$0A;
  wfLezarasTranOutputXmlTransformator.Text := strWfLezarasTranOutputXmlTransformator;

  trIdGenTranOutputXmlTransformator := TStringList.Create();
  trIdGenTranOutputXmlTransformator.NameValueSeparator := '=';
  trIdGenTranOutputXmlTransformator.CommaText := #$0D#$0A;
  trIdGenTranOutputXmlTransformator.Text := strTrIdGenTranOutputXmlTransformator;

  trLekTranOutputXmlTransformator := TStringList.Create();
  trLekTranOutputXmlTransformator.NameValueSeparator := '=';
  trLekTranOutputXmlTransformator.CommaText := #$0D#$0A;
  trLekTranOutputXmlTransformator.Text := strTrLekTranOutputXmlTransformator;

  trFizJovairasOutputXmlTransformator := TStringList.Create();
  trFizJovairasOutputXmlTransformator.NameValueSeparator := '=';
  trFizJovairasOutputXmlTransformator.CommaText := #$0D#$0A;
  trFizJovairasOutputXmlTransformator.Text := strFizJovairasTranOutputXmlTransformator;

  OUTPUTXML_TRANSLATOR[0] := wf3TranOutputXmlTransformator;
  OUTPUTXML_TRANSLATOR[1] := wf2TranOutputXmlTransformator;
  OUTPUTXML_TRANSLATOR[2] := trIdGenTranOutputXmlTransformator;
  OUTPUTXML_TRANSLATOR[3] := trLekTranOutputXmlTransformator;
  OUTPUTXML_TRANSLATOR[4] := wfLezarasTranOutputXmlTransformator;
  OUTPUTXML_TRANSLATOR[5] := trFizJovairasOutputXmlTransformator;

finalization
  wf3TranInputXmlTransformator.Free();
  trIdGenTranInputXmlTransformator.Free();

  trIdGenTranOutputXmlTransformator.Free();
end.
