package hu.iqsoft.otp.webshop.factory;

import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatok;
import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatokLista;
import hu.iqsoft.otp.workflow.wlpi.WAnswer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WAnswerOfWebShopFizetes extends WAnswer {

    protected static final String RESULT_TAG = "/resultset";
    protected static final String RECORD_TAG = "/resultset/record";

    private static final String AZONOSITO_TAG = "transactionid";
    private static final String POSID_TAG = "posid";
    private static final String TELJESITES_TAG = "timestamp";
    private static final String AUTORIZACIOSKOD_TAG = "authorizationcode";

    private static final String NEV_TAG = "name";
    private static final String ORSZAG_TAG = "country";
    private static final String MEGYE_TAG = "county";
    private static final String VAROS_TAG = "settlement";
    private static final String UTCAHAZSZAM_TAG = "street";
    private static final String IRSZ_TAG = "zipcode";
    private static final String EMAIL_TAG = "mailaddress";
    private static final String KOZLEMENY_TAG = "narration";

    public void load(Document answer) {
        load(answer.getDocumentElement());
    }

    public void load(Node answer) {
        WebShopFizetesAdatokLista adatokLista = new WebShopFizetesAdatokLista();
        
        WebShopFizetesAdatok webShopFizetesAdatok = new WebShopFizetesAdatok();

        Element record = getElement(answer, RECORD_TAG);

        if (record != null) {

            adatokLista.setPosId(getElementText(record, POSID_TAG));

            webShopFizetesAdatok.setPosId(getElementText(record, POSID_TAG));
            webShopFizetesAdatok.setAzonosito(getElementText(record, AZONOSITO_TAG));
            webShopFizetesAdatok.setAutorizaciosKod(getElementText(record, AUTORIZACIOSKOD_TAG));
            webShopFizetesAdatok.setTeljesites(getElementText(record, TELJESITES_TAG));
            
            webShopFizetesAdatok.setNev(getElementText(record, NEV_TAG));
            webShopFizetesAdatok.setOrszag(getElementText(record, ORSZAG_TAG));
            webShopFizetesAdatok.setMegye(getElementText(record, MEGYE_TAG));
            webShopFizetesAdatok.setVaros(getElementText(record, VAROS_TAG));
            webShopFizetesAdatok.setIranyitoszam(getElementText(record, IRSZ_TAG));
            webShopFizetesAdatok.setUtcaHazszam(getElementText(record, UTCAHAZSZAM_TAG));
            webShopFizetesAdatok.setMailCim(getElementText(record, EMAIL_TAG));
            webShopFizetesAdatok.setKozlemeny(getElementText(record, KOZLEMENY_TAG));

            adatokLista.setWebShopFizetesAdatok(new WebShopFizetesAdatok[]{webShopFizetesAdatok});
        }

        setData(adatokLista);
    }

}

