package hu.iqsoft.otp.webshop.factory;

import hu.iqsoft.otp.workflow.wlpi.WAnswer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.List;

import hu.iqsoft.otp.webshop.model.WebShopFizetesValasz;

public class WAnswerOfWebShopFizetesKetszereplos extends WAnswer {

    protected static final String RESULT_TAG = "/resultset";
    protected static final String RECORD_TAG = "/resultset/record";

    private static final String POSID_TAG = "posid";
    private static final String AZONOSITO_TAG = "transactionid";
    private static final String TELJESITES_TAG = "timestamp";
    private static final String VALASZKOD_TAG = "posresponsecode";
    private static final String AUTHORITZACIOSKOD_TAG = "authorizationcode";

    public void load(Document answer) {
        load(answer.getDocumentElement());
    }

    public void load(Node answer) {

        WebShopFizetesValasz webShopFizetesValasz = new WebShopFizetesValasz();

        Element record = getElement(answer, RECORD_TAG);

        if (record != null) {

            webShopFizetesValasz.setPosId(getElementText(record, POSID_TAG));
            webShopFizetesValasz.setAzonosito(getElementText(record, AZONOSITO_TAG));
            webShopFizetesValasz.setTeljesites(getElementText(record, TELJESITES_TAG));
            webShopFizetesValasz.setValaszKod(getElementText(record, VALASZKOD_TAG));
            webShopFizetesValasz.setAuthorizaciosKod(getElementText(record, AUTHORITZACIOSKOD_TAG));
        }

        setData(webShopFizetesValasz);
    }

    public void load(List answer) {
    }

}

