package hu.iqsoft.otp.webshop.factory;

import hu.iqsoft.otp.workflow.wlpi.WAnswer;

import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.util.List;

import hu.iqsoft.otp.webshop.model.WebShopTranzAzon;

public class WAnswerOfWebShopTranzAzonGeneralas extends WAnswer {

    protected static final String RESULT_TAG = "/resultset";
    protected static final String RECORD_TAG = "/resultset/record";

    private static final String ID_TAG = "id";
    private static final String POSID_TAG = "posid";
    private static final String TELJESITES_TAG = "timestamp";

    public void load(Document answer) {
        load(answer.getDocumentElement());
    }

    public void load(Node answer) {

        WebShopTranzAzon webShopTranzAzon = new WebShopTranzAzon();
	Element record = getElement(answer, RECORD_TAG);

        if (record != null) {

            webShopTranzAzon.setAzonosito(getElementText(record, ID_TAG));
            webShopTranzAzon.setPosId(getElementText(record, POSID_TAG));
            webShopTranzAzon.setTeljesites(getElementText(record, TELJESITES_TAG));
        }
        setData(webShopTranzAzon);
    }

    public void load(List answer) {
    }

}

