package hu.iqsoft.otp.webshop.factory;


import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatok;
import hu.iqsoft.otp.webshop.model.WebShopFizetesAdatokLista;

import hu.iqsoft.otp.workflow.wlpi.WAnswer;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.Iterator;

public class WAnswerOfWebShopTrazakcioLekerdezes extends WAnswer {

    public final static String DB_YES_VALUE = "TRUE";

    private static final String RESULT_TAG = "resultset";
    private static final String RECORD_TAG = "record";
    private static final String INPUTPARAMS_TAG = "params/input";
    private static final String OUTPUTPARAMS_TAG = "params/output";

    private static final String AZONOSITO_TAG = "transactionid";
    private static final String POSID_TAG = "posid";
    private static final String STATUSZKOD_TAG = "state";
    private static final String POSVALASZ_TAG = "responsecode";
    private static final String SHOPNEV_TAG = "";
    private static final String SHOPLOGOURL_TAG = "";
    private static final String OSSZEG_TAG = "amount";
    private static final String DEVIZANEM_TAG = "exchange";
    private static final String NYELVKOD_TAG = "languagecode";
    private static final String VEVOVISSZAIGAZOLASKELL_TAG = "consumerreceiptneeded";
    private static final String BACKURL_TAG = "backurl";
    private static final String NEVKELL_TAG = "nameneeded";
    private static final String ORSZAGKELL_TAG = "countryneeded";
    private static final String MEGYEKELL_TAG = "countyneeded";
    private static final String TELEPULESKELL_TAG = "settlementneeded";
    private static final String UTCAHAZSZAMKELL_TAG = "streetneeded";
    private static final String IRANYITOSZAMKELL_TAG = "zipcodeneeded";
    private static final String MAILCIMKELL_TAG = "mailaddressneeded";
    private static final String KOZLEMENYKELL_TAG = "narrationneeded";
    private static final String SHOPMEGJEGYZES_TAG = "shopcomment";
    private static final String UGYFELREGISZTRACIOKELL_TAG = "consumerregistrationneeded";
    private static final String REGISZTRALTUGYFELID_TAG = "consumerregistrationid";
    
    private static final String TELJESITES_TAG = "enddate";

    private static final String AUTORIZACIOSKOD_TAG = "authorizationcode";
    private static final String NEV_TAG = "name";
    private static final String ORSZAG_TAG = "country";
    private static final String MEGYE_TAG = "county";
    private static final String VAROS_TAG = "settlement";
    private static final String UTCAHAZSZAM_TAG = "street";
    private static final String IRSZ_TAG = "zipcode";
    private static final String EMAIL_TAG = "mailaddress";
    private static final String KOZLEMENY_TAG = "narration";

    private static boolean getBooleanValue(String value) {
      boolean result = false;
      if (value != null && DB_YES_VALUE.equalsIgnoreCase(value)) {
        result = true;
      }
      return result;
    }

    public void load(Document answer) {
        load(answer.getDocumentElement());
    }

    public void load(Node answer) {

        List fizetesAdatok = new Vector();

        WebShopFizetesAdatokLista webShopFizetesAdatokLista = new WebShopFizetesAdatokLista();
        WebShopFizetesAdatok webShopFizetesAdatok;

        Element record = getElement(answer, RESULT_TAG + '/' + RECORD_TAG);
        webShopFizetesAdatokLista.setPosId(getElementText(record, POSID_TAG));

        Iterator iterator = getElementIterator((Element)answer, RESULT_TAG, RECORD_TAG);

        while (iterator.hasNext()) {

            
          record = (Element)iterator.next();

          webShopFizetesAdatok = new WebShopFizetesAdatok();
          fizetesAdatok.add(webShopFizetesAdatok);

          webShopFizetesAdatok.setPosId(getElementText(record, POSID_TAG));
          webShopFizetesAdatok.setAzonosito(getElementText(record, AZONOSITO_TAG));
          webShopFizetesAdatok.setStatuszKod(getElementText(record, STATUSZKOD_TAG));
          webShopFizetesAdatok.setPosValaszkod(getElementText(record, POSVALASZ_TAG));

          webShopFizetesAdatok.setTeljesites(getElementText(record, TELJESITES_TAG));

          Element inputPart = getElement(record, INPUTPARAMS_TAG);
          
          webShopFizetesAdatok.setShopNev(getElementText(inputPart, SHOPNEV_TAG));
          webShopFizetesAdatok.setShopLogoUrl(getElementText(inputPart, SHOPLOGOURL_TAG));
          webShopFizetesAdatok.setOsszeg(getElementText(inputPart, OSSZEG_TAG));
          webShopFizetesAdatok.setDevizanem(getElementText(inputPart, DEVIZANEM_TAG));
          webShopFizetesAdatok.setNyelvkod(getElementText(inputPart, NYELVKOD_TAG));
          webShopFizetesAdatok.setVevoVisszaigazolasKell(getBooleanValue(getElementText(inputPart, VEVOVISSZAIGAZOLASKELL_TAG)));
          webShopFizetesAdatok.setBackURL(getElementText(inputPart, BACKURL_TAG));
          webShopFizetesAdatok.setNevKell(getBooleanValue(getElementText(inputPart, NEVKELL_TAG)));
          webShopFizetesAdatok.setOrszagKell(getBooleanValue(getElementText(inputPart, ORSZAGKELL_TAG)));
          webShopFizetesAdatok.setMegyeKell(getBooleanValue(getElementText(inputPart, MEGYEKELL_TAG)));
          webShopFizetesAdatok.setTelepulesKell(getBooleanValue(getElementText(inputPart, TELEPULESKELL_TAG)));
          webShopFizetesAdatok.setUtcaHazszamKell(getBooleanValue(getElementText(inputPart, UTCAHAZSZAMKELL_TAG)));
          webShopFizetesAdatok.setIranyitoszamKell(getBooleanValue(getElementText(inputPart, IRANYITOSZAMKELL_TAG)));
          webShopFizetesAdatok.setMailCimKell(getBooleanValue(getElementText(inputPart, MAILCIMKELL_TAG)));
          webShopFizetesAdatok.setKozlemenyKell(getBooleanValue(getElementText(inputPart, KOZLEMENYKELL_TAG)));
          webShopFizetesAdatok.setUgyfelRegisztracioKell(getBooleanValue(getElementText(inputPart, UGYFELREGISZTRACIOKELL_TAG)));
          webShopFizetesAdatok.setRegisztraltUgyfelId(getElementText(inputPart, REGISZTRALTUGYFELID_TAG));
          
          webShopFizetesAdatok.setShopMegjegyzes(getElementText(inputPart, SHOPMEGJEGYZES_TAG));

          Element outputPart = getElement(record, OUTPUTPARAMS_TAG);
          
          webShopFizetesAdatok.setAutorizaciosKod(getElementText(outputPart, AUTORIZACIOSKOD_TAG));
          webShopFizetesAdatok.setNev(getElementText(outputPart, NEV_TAG));
          webShopFizetesAdatok.setOrszag(getElementText(outputPart, ORSZAG_TAG));
          webShopFizetesAdatok.setMegye(getElementText(outputPart, MEGYE_TAG));
          webShopFizetesAdatok.setVaros(getElementText(outputPart, VAROS_TAG));
          webShopFizetesAdatok.setIranyitoszam(getElementText(outputPart, IRSZ_TAG));
          webShopFizetesAdatok.setUtcaHazszam(getElementText(outputPart, UTCAHAZSZAM_TAG));
          webShopFizetesAdatok.setMailCim(getElementText(outputPart, EMAIL_TAG));
          webShopFizetesAdatok.setKozlemeny(getElementText(outputPart, KOZLEMENY_TAG));
        }

        Collections.sort(fizetesAdatok, new FizetesAdatokComparator());
        webShopFizetesAdatokLista.setWebShopFizetesAdatok((WebShopFizetesAdatok[])fizetesAdatok.toArray(new WebShopFizetesAdatok[0]));
        
        setData(webShopFizetesAdatokLista);
    }

    public void load(List answer) {
    }

    class FizetesAdatokComparator implements Comparator {

		public int compare(Object arg0, Object arg1) {
			WebShopFizetesAdatok adat1 = (WebShopFizetesAdatok)arg0;
			WebShopFizetesAdatok adat2 = (WebShopFizetesAdatok)arg1;
			if (adat1 == null) return 1;
			if (adat2 == null) return -1;
			String str1 = adat1.getTeljesites() + adat1.getAzonosito();
			String str2 = adat2.getTeljesites() + adat2.getAzonosito();
			return str1.compareTo(str2);
		}
    	
    }
}

