package hu.iqsoft.otp.webshop.factory;

import hu.iqsoft.otp.workflow.wlpi.WAnswerFactory;
import hu.iqsoft.otp.workflow.wlpi.WAnswer;
import java.util.Hashtable;

public class WSAnswerFactory implements WAnswerFactory {

    /***************
     * A WebShop folyamatok s vlasz-osztlyok sszerendelse
     * A tmb egy sornak els eleme a folyamat neve,
     * mg a msodik elem egy osztly. Az osztly legyen a WAnswer leszrmazotta!
     *
     * Plda:
     *     private static final Object[][] workflowAnswers = {
     *          {"000", WAnswerOf000.class },
     *     };
     *
     * AHHOZ A FOLYAMATOKHOZ, MELYEK NEM ADNAK VISSZA EREDMNYT
     * (mdost funckik, trlsek, stb.), NEM KELL VLASZ OSZTLY S
     * NEM KELL A LENTI REGISZTRCI SEM!
     * Ezekhez a folyamatokhoz automatikusan a WBaseAnswer osztly
     * pldnyosodik, mely nem vgez semmilyen vlasz-adat elemzst.
     */

    private static final Object[][] wsWorkflowAnswers = {
            {"WEBSHOPTRANZAZONGENERALAS", WAnswerOfWebShopTranzAzonGeneralas.class },
            {"WEBSHOPTRANZAKCIOLEKERDEZES", WAnswerOfWebShopTrazakcioLekerdezes.class },
            {"WEBSHOPFIZETES", WAnswerOfWebShopFizetes.class },
            {"WEBSHOPFIZETESKETSZEREPLOS", WAnswerOfWebShopFizetesKetszereplos.class },
            {"WEBSHOPFIZETESLEZARAS", WAnswerOfWebShopFizetesKetszereplos.class }
        };

    public WSAnswerFactory() {
         workflowAnswers = wsWorkflowAnswers;
         workflowAnswersMap = loadWorkflowAnswersMap();
    }

    private static final Class DEFAULT_WORKFLOW_ANSWER = WBaseAnswer.class;
    protected Object[][] workflowAnswers = null;
    protected Hashtable workflowAnswersMap = null;

    protected Hashtable loadWorkflowAnswersMap () {
        Hashtable table = new Hashtable();
        for (int i = 0; i < workflowAnswers.length; i++) {
            table.put((String)workflowAnswers[i][0], (Class)workflowAnswers[i][1]);
        }
        return  table;
    }

    public WAnswer getAnswerInstance (String templateName) {

        WAnswer answer = null;
        if (templateName != null) {
            Object answerClass = workflowAnswersMap.get(templateName);
            try {
                if (answerClass != null) {
                    answer = (WAnswer)((Class)answerClass).newInstance();
                }
                else {
                    answer = (WAnswer)DEFAULT_WORKFLOW_ANSWER.newInstance();
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return answer;
    }

}

