package hu.iqsoft.otp.webshop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Security;

import javax.net.ssl.SSLSocketFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * Segdmveletek https protokollon trtn kommunikcihoz.
 * A https kommunikci annyiban specilis, hogy az OTP Bank alkalmazs szervere
 * nem azonostja a klienst. (Unauthenticated client) Publikus s privt kulcsok
 * teht nincsenek.
 * 
 * @author Bodnar Imre, IQSYS
 *
 */
public class SSLUtils {

    public static String SOAPSERVER_URL 
        = "https://www.otpbankdirekt.hu/mwaccesspublic/mwaccess";    
    public static String WSDL_URL 
        = "https://www.otpbankdirekt.hu/mwaccesspublic/MWAccessBean/wsdl.jsp"; 
    public static String HTTPSPROXY_HOST = null;
    public static String HTTPSPROXY_PORT = null;

    private static SSLSocketFactory createSSLFactory()  {

        SSLContext ctx;
        SSLSocketFactory factory = null;
        try {
            ctx = SSLContext.getInstance("SSLv3", "SunJSSE");
            ctx.init(null, new TrustManager[]{new unauthenticatedClientTM()}, null);
            factory = ctx.getSocketFactory();
            return factory;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * A nem azonostott kliens - azonostott szerver kapcsolatot
     * megvalst TrustManager implementci
     */
    public static class unauthenticatedClientTM
        implements TrustManager, X509TrustManager {
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }
        public boolean isServerTrusted(
            java.security.cert.X509Certificate[] certs) {
            return true;
        }
        public boolean isClientTrusted(
            java.security.cert.X509Certificate[] certs) {
            return true;
        }
        public void checkServerTrusted(
            java.security.cert.X509Certificate[] certs,
            String authType)
            throws java.security.cert.CertificateException {
            return;
        }
        public void checkClientTrusted(
            java.security.cert.X509Certificate[] certs,
            String authType)
            throws java.security.cert.CertificateException {
            return;
        }
    }

    /**
     * Az OTP Fizetfellet rendszerhez val kapcsolds
     */
    public static HttpURLConnection createHttpsSoapConnection(
        String soapServerUrl, 
        String httpsProxyHost,
        String httpsProxyPort,
        String httpsProxyUser,
        String httpsProxyPassword) 
        throws MalformedURLException, ProtocolException, IOException {
            
        HttpURLConnection conn = null;
        try {
        
            if (httpsProxyHost != null) {
                System.setProperty("https.proxyHost",httpsProxyHost);
            }
            if (httpsProxyPort != null) {
                System.setProperty("https.proxyPort",httpsProxyPort);
            }
            if (httpsProxyUser != null) {
                System.setProperty("https.proxyUser",httpsProxyUser);
            }
            if (httpsProxyPassword != null) {
                System.setProperty("https.proxyPassword",httpsProxyPassword);
            }

            URL url =
                new URL(
                    null,
                    soapServerUrl);

            conn = (HttpURLConnection) url.openConnection();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        
        
        return conn;
    }

    /**
     * Az OTP Fizetfellet rendszerhez val kapcsolds
     */
    public static HttpURLConnection createHttpsSoapConnection(
        String soapServerUrl, 
        String httpsProxyHost,
        String httpsProxyPort) 
        throws MalformedURLException, ProtocolException, IOException {
        
        return createHttpsSoapConnection(
            soapServerUrl, httpsProxyHost, httpsProxyPort, null, null);
    }            
        
    /**
     * SOAP zenet kldse inicializlt https protokollon keresztl
     * A klds felttelezi a nyitott kapcsolatot. A kapcsolat nem kerl
     * lezrsra a klds utn,
     * 
     * @param request krs SOAP zenet
     * @return SOAPMessage
     * @throws IOException
     * @throws SOAPException
     */
    public static SOAPMessage sendMessageViaHtpps(
        SOAPMessage request) 
        throws IOException, SOAPException, ProtocolException {

        HttpURLConnection conn = 
            createHttpsSoapConnection(
                SOAPSERVER_URL, HTTPSPROXY_HOST, HTTPSPROXY_PORT);

        return sendMessageViaURLConnection(request, conn);
    }    

    /**
     * SOAP zenet kldse inicializlt https protokollon keresztl
     * A klds felttelezi a nyitott kapcsolatot. A kapcsolat nem kerl
     * lezrsra a klds utn,
     * 
     * @param request krs SOAP zenet
     * @return SOAPMessage
     * @throws IOException
     * @throws SOAPException
     */
    public static SOAPMessage sendMessageViaURLConnection(
        SOAPMessage request,
        HttpURLConnection conn) 
        throws IOException, SOAPException, ProtocolException {

        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");

        conn.connect();

        // zenet kldse a nyitott kapcsolaton
        OutputStream out = conn.getOutputStream();
        request.writeTo(out);
        out.flush();
        out.close();

        InputStream in = conn.getInputStream();
            
        // SOAPMessage ellltsa a kapott xml stream-bl.
        MimeHeaders mh = new MimeHeaders();
        mh.addHeader("Content-Type", conn.getContentType());
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage response = mf.createMessage(mh, in);

        // conn.disconnect();
        
        return response;
                            
    }    

}

