package hu.iqsoft.otp.webshop.util;


import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;


/**
 * Request filter, ami belltja/mdostja a karakter kdolst a http
 * krsben, jellemzen akkor, ha az nincs definilva.
 *  
 * A filter feladata, hogy rgztse a web komponens ltal hasznlt
 * karakter kdols, fggetlenl attl, hogy milyen
 * tpus web-szerveren futtatjk a webshop/simpleshop alkalmazst,
 * illetve hogy a web-szerver milyen terleti bellts opercis
 * rendszeren futtatjk azt.
 * (Az web-szerverek esetn ltalban rgzthet?, hogy milyen
 *  karakter kdolst hasznl a teleptett komponens, m ennek mdja
 *  szerverenknt eltr?.)
 *  
 * A filter az albbi konfigurcis paramterekkel rendelkezik (melyeket
 * a vonatkoz web.xml-ben lehet belltani)
 * -encoding - A karakter kdols, melyet a bejv? html krsben be kell
 *             lltani, ha az nincs benne definilva. 
 *             Ha az ignore paramter rtke "true", minden esetben a 
 *             megadott encoding kerl rvnyestsre, akkor is, ha a 
 *             http krs tartalmaz kdols megnevezst! 
 * - ignore - "true" rtk esetn , minden esetben a fent megadott encoding 
 *            kerl rvnyestsre, akkor is, ha a http krs tartalmaz 
 *            kdols megnevezst! "false" esetben csak nem definilt
 *            kdols esetn lltdik be az "encoding" rtk.
 *            Az alaprtelmezs "true" 
 *
 * A filter az Apache Tomcat csomagban tallhat 
 * filters.SetCharacterEncodingFilter osztlya alapjn kszlt. 
 * (Craig McClanahan, Revision: 1.2, 2001/10/17 22:53:19)
 * 
 * Megjegyzs: a vev? fellet kialaktsa sorn biztostani kell, hogy a krsben
 * valban a megadott kdolssal rkezzenek a karakterek. Ennek biztostsra 
 * tapasztalatok szerint a 
 * <META content="text/html; charset=ISO-8859-2" http-equiv="Content-type">
 * tag alkalmazsa nem elegend?, a bngsz?k ugyanis az kezetes karakterek
 * kdolsnl ezt rendszerint figyelmen kvl hagyjk, s a bngsz? kliens 
 * alaprtelmezett kdolst hasznljk (tipikusan latin-1-et).
 * Valjban a bngsz?k amikor sszelltjk a megjelentett HTML oldalon 
 * kitlttt ?rlap adataihoz tartoz http krst, nem a META tag-ban rgztett 
 * kdolst (charset-et) hasznljk, hanem azt, ami az oldal "http header"-jben 
 * tallhat.  
 * Header paramter belltsra statikus HTML oldalak esetn nincs lehet?sg,
 * teht mindenkppen alkalmazsvezrelt eszkz szksges (szervlet, PHP, JSP, stb.)
 *  
 * JSP oldalakkal dinamikusan generlt html oldalak esetn pldul a
 * <% request.setCharacterEncoding("ISO-8859-2"); %>
 * metdushvs szksges - ez a JSP-be gyazott Java utasts pontosan 
 * a szksges header paramtert lltja be!
 */

public class SetCharacterEncodingFilter implements Filter {

    protected String encoding = null;

    protected FilterConfig filterConfig = null;

    protected boolean ignore = true;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(
            ServletRequest request, 
            ServletResponse response,
            FilterChain chain)
	throws IOException, ServletException {

        if (ignore || (request.getCharacterEncoding() == null)) {
            String encoding = selectEncoding(request);
            if (encoding != null)
                request.setCharacterEncoding(encoding);
        }

        chain.doFilter(request, response);
    }


    public void init(FilterConfig filterConfig) throws ServletException {

    	this.filterConfig = filterConfig;
            this.encoding = filterConfig.getInitParameter("encoding");
            String value = filterConfig.getInitParameter("ignore");
            if (value == null)
                this.ignore = true;
            else if (value.equalsIgnoreCase("true"))
                this.ignore = true;
            else
                this.ignore = false;
    }


    protected String selectEncoding(ServletRequest request) {
        return (this.encoding);
    }
}
