package hu.iqsoft.otp.webshop.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

/**
 * hu.iqsys.otp.webshop.SignatureUtils
 * Az OTPWebShop szolgltatsaihoz szksges digitlis alrs mvelett
 * tmogat metdusok gyjtemnye.
 * 
 * @author Bodnr Imre (c) IQSys Rt.
 */
public class SignatureUtils {

    private static final char[] hexDigits =
        {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

    /**
     * A megadott privt kulccsal generl egy alirst a megadott adathoz olyan
     * titkostsi mdszerrel, melyet az OTP WebShop folyamatai elvrnak.
     *
     * @param data az alrand adat
     * @pkcs8PrivateKey privt kulcs PKCS8 formban
     * @return generlt digitlis alrs
     */
    public static byte[] generateSignature(byte[] data, byte[] pkcs8PrivateKey)
        throws
            NoSuchAlgorithmException,
            InvalidKeySpecException,
            InvalidKeyException,
            SignatureException {
        PKCS8EncodedKeySpec privKeySpec =
            new PKCS8EncodedKeySpec(pkcs8PrivateKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
        Signature sig = Signature.getInstance("MD5withRSA");

        sig.initSign(privKey);
        sig.update(data);

        byte[] signature = sig.sign();

        return signature;
    }

    /**
     * Method toHex.
     * Byte-tmb hexadecimlis formban val lersa. 
     * Ilyen formban kell a digitlis alrst a workflow input xml-jbe
     * beilleszteni.
     * 
     * @param ba byte-tmb
     * @param offset honnan kezddjk az talakts 
     * @param length hny bjt hosszam trtnjen az talakts
     * 
     * @return hexidecimlis rtkeket tartalmaz string
     */
    public static String toHex(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int j = 0;
        int k;

        for (int i = offset; i < (offset + length); i++) {
            k = ba[i];
            buf[j++] = hexDigits[(k >>> 4) & 0x0F];
            buf[j++] = hexDigits[k & 0x0F];
        }

        return new String(buf);
    }

    /**
     * Method loadPrivateKey.
     * A fjlban trolt privt kulcs betltse
     * 
     * @param privKeyFileName a privt kulcsot tartalmaz fjl elrse
     * @return byte[] a fjl tartalma
     * @throws FileNotFoundException
     * @throws IOException
     */
    public static byte[] loadPrivateKey(String privKeyFileName)
        throws FileNotFoundException, IOException {

        byte[] result = null;

        File privKeyFile = new File(privKeyFileName);
        FileInputStream privKeyInputStream = new FileInputStream(privKeyFile);
        result = new byte[(int) privKeyFile.length()];
        privKeyInputStream.read(result);
        privKeyInputStream.close();
        return result;
    }

    /**
     * Method getByteArray.
     * Byte tmb generlsa stringek sszefzsbl.
     * Brmelyik string lehet null vagy res is.
     * 
     * @param fields String tmb
     * @return A stringek sszefzsbl keletkez byte sorozat.
     */
    public static byte[] getByteArray(String[] fields) {
        int length = 0;

        for (int i = 0; i < fields.length; i++) {
            if (fields[i] != null) {
                length += fields[i].getBytes().length;
            }
        }
        length += fields.length-1;

        byte[] result = new byte[length];
        length = 0;

        for (int i = 0; i < fields.length; i++) {
            if (fields[i] != null) {
                byte[] bytes = fields[i].getBytes();

                for (int j = 0; j < bytes.length; j++) {
                    result[length++] = bytes[j];
                }
            }
            if (i < (fields.length - 1)) {
                result[length++] = '|';
            }
        }

        return result;
    }

}
