package hu.iqsoft.otp.webshop.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.Iterator;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

import org.apache.axis.soap.SOAPFactoryImpl;

import sun.misc.BASE64Decoder;


public class SoapUtils  {

    /**
     * Elllt egy mwaccess:ping SOAP zenetet.
     * @return Ping SOAP zenet.
     * @throws Exception Hiba a SOAP zenet sszelltsa kzben.
     */
    public static SOAPMessage createPingMessage() 
                        throws SOAPException {
        MessageFactory messagefactory = MessageFactory.newInstance();
        SOAPMessage message = messagefactory.createMessage();
        SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
        envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        header.detachNode();
        Name methodName = envelope.createName("ping", "ns1", "urn:MWAccess");
        SOAPBodyElement bodyelement = body.addBodyElement(methodName);
        
        return message;
    }

	/**
	 * Elllt egy res SOAP zenetet.
	 * @return res SOAP zenet.
	 * @param soapClientID Kliens azonost.
	 * @param method SOAP metdus.
	 * @throws Exception  Hiba a SOAP zenet sszelltsa kzben.
	 */
	public static SOAPMessage createWorkflowStarterMessage(String workflowName, String inputXml) 
						throws SOAPException {
		MessageFactory messagefactory = MessageFactory.newInstance();
		SOAPMessage message = messagefactory.createMessage();
		SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
		envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance" );
		envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
		SOAPHeader header = envelope.getHeader();
		SOAPBody body = envelope.getBody();
		header.detachNode();
		Name methodName = envelope.createName("startWorkflowSynch", "ns1", "urn:MWAccess");
		SOAPBodyElement bodyelement = body.addBodyElement(methodName);
		
		Name arg0 = envelope.createName("arg0");
		SOAPElement element0 = bodyelement.addChildElement(arg0);
		element0.addTextNode(workflowName);

		Name arg1 = envelope.createName("arg1");
		SOAPElement element1 = bodyelement.addChildElement(arg1);
		element1.addTextNode(inputXml);
		
		return message;
	}

	/**
	 * SOAP zenet string-g akaktsa.
	 * @param message SOAP zenet
	 * @return SOAP zenet szveges alakja
	 */
	public static String soapMessageToString(SOAPMessage message) {
		String result = null;
		try {
			ByteArrayOutputStream sentOs = new ByteArrayOutputStream();
			message.writeTo(sentOs);
			result = sentOs.toString("UTF-8");
		} catch (Exception e) {
		  e.printStackTrace();
		}
		return result;		
	}
		
	/**
	 * SOAP hvs adott URL cmre.
	 * @return Vlasz SOAP zenet.
	 * @param url szerver cme.
	 * @param message Kldend SOAP zenet.
	 * @throws Exception SOAP hiba. 
	 */    
	public static SOAPMessage callSOAP(SOAPMessage message, String url) 
						throws SOAPException {
		SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
		SOAPConnection connection = connectionFactory.createConnection();
		SOAPMessage answer = connection.call(message, url);
		connection.close();
		return answer;
	}

    /**
     * SOAP hvs URLConnection pldny segtsgvel.
     * @return Vlasz SOAP zenet.
     * @param url szerver cme.
     * @param message Kldend SOAP zenet.
     * @throws Exception SOAP hiba. 
     */    
    public static SOAPMessage callSOAP(SOAPMessage message, HttpURLConnection conn) 
                        throws ProtocolException, IOException, SOAPException {
        SOAPMessage answer = SSLUtils.sendMessageViaURLConnection(message, conn); 
        return answer;
    }

	/**
	 * SOAP hibakdot adja vissza. Lekrdezs esetn csak a body-ban lv?
	 * hibakdot keresi meg, aktv m?velet esetn a ttelhez tartoz
	 * hibakdot is leellen?rzi.
	 * @return Hiba objektum.
	 * @param answer SOAP vlasz zenet.
	 * @throws Exception  Hiba a SOAP vlasz rtelmezse kzben.
	 */    
	public static TransactionState processWorkflowAnswer(SOAPMessage answer) 
                        throws SOAPException, IOException {
        
        TransactionState state = null;
        
        SOAPEnvelope envelope = answer.getSOAPPart().getEnvelope();
		SOAPBody body = envelope.getBody();
		if (body.hasFault()) {
            throw new SOAPException(
                body.getFault().getFaultCode() 
                + "\n" + 
                body.getFault().getFaultString());
		}

		SOAPElement method = (SOAPElement)body.getChildElements().next();
        SOAPElement returnData = (SOAPElement)method.getChildElements().next();
        Iterator returnDataIterator = returnData.getChildElements(); 

        // Kiolvassuk az sszes mezt a vlaszbl
        SOAPElement resultData = null;
        SOAPElement templateNameData = null; 
        SOAPElement endTimeData = null;
        SOAPElement completedData = null; 
        SOAPElement startTimeData = null; 
        SOAPElement transactionIdData = null;
        SOAPElement timeoutData = null;
        
        while (returnDataIterator.hasNext()) {
            SOAPElement soapElement = (SOAPElement)returnDataIterator.next(); 
            String localName = soapElement.getElementName().getLocalName(); 
        
            if ("result".equals(localName)) {
            	 resultData = soapElement;
            } else if ("templateName".equals(localName)) {
                templateNameData = soapElement; 
            } else if ("endTime".equals(localName)) {
            	endTimeData = soapElement; 
            } else if ("completed".equals(localName)) {
            	completedData = soapElement; 
            } else if ("startTime".equals(localName)) {
            	startTimeData = soapElement;
            } else if ("instanceId".equals(localName)) {
            	transactionIdData = soapElement; 
            } else if ("timeout".equals(localName)) {
            	timeoutData = soapElement; 
            }
        }
        
        // Az output xml Base64 kdols
        BASE64Decoder decoder = new BASE64Decoder();  
        byte[] resultBytes = 
            decoder.decodeBuffer(resultData.getValue());

        // Ellltjuk az tranzakci vlasznak 
        // egyszeren kezelhet reprezentcijt 
        state = new TransactionState(
            transactionIdData.getValue(), 
            startTimeData.getValue(), 
            endTimeData.getValue(),
            resultBytes, 
            timeoutData.getValue());
                
        return state; 
	}

}
