<?php

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname( __FILE__ ))));

require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopFizetesValasz.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/WebShopXmlUtils.php';

/**
* Ktszerepls fizets illetve ktlpcss fizets lezrs 
* vlasz XML-jnek feldolgozssa s a megfelel value object ellltsa.
* 
* @version 4.0
*/
class WAnswerOfWebShopFizetesKetszereplos {

    /**
    * Ktszerepls fizets illetve ktlpcss fizets lezrs 
    * vlasz XML-jnek feldolgozssa s a megfelel value object ellltsa.
    * 
    * @param DomDocument $answer A tranzakcis vlasz xml
    * @return WebShopFizetesValasz a vlasz tartalma, 
    *         vagy NULL res/hibs vlasz esetn
    */
    function load($answer) {
        $webShopFizetesValasz = new WebShopFizetesValasz();
       
        $record = WebShopXmlUtils::getNodeByXPath($answer, '//answer/resultset/record');
        if (!is_null($record)) {
            $webShopFizetesValasz->setPosId(WebShopXmlUtils::getElementText($record, "posid"));
            $webShopFizetesValasz->setAzonosito(WebShopXmlUtils::getElementText($record, "transactionid"));
            $webShopFizetesValasz->setTeljesites(WebShopXmlUtils::getElementText($record, "timestamp"));
            $webShopFizetesValasz->setValaszKod(WebShopXmlUtils::getElementText($record, "posresponsecode"));
            $webShopFizetesValasz->setAuthorizaciosKod(WebShopXmlUtils::getElementText($record, "authorizationcode"));
        }
        
        return $webShopFizetesValasz;
    }

}

?>