<?php

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname( __FILE__ ))));

require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopKulcsAdatokLista.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopKulcsAdatok.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/WebShopXmlUtils.php';

/**
* Kulcs lekrdezs vlasz XML-jnek feldolgozssa s
* a megfelel value object ellltsa.
* 
* @author Lszlk Zsolt
* @version 4.0
*/
class WAnswerOfWebShopKulcsLekerdezes {

    /**
    * @desc A banki fellet ltal visszaadott szveges logikai
    * rtkbl boolean tpus rtk ellltsa.
    * 
    * A kpzs mdja:
    * "TRUE" szveges rtk => true logikai rtk
    * minden ms rtk => false logikai rtk
    */
    function getBooleanValue($value) {
      $result = false;
      
      if (!is_null($value) && strcasecmp("TRUE", $value) == 0) {
        $result = true;
      }
      
      return $result;
    }

    /**
    * Kulcs lekrdezs vlasz XML-jnek feldolgozssa s
    * a megfelel value object ellltsa.
    * 
    * @param DomDocument $answer A tranzakcis vlasz xml
    * @return WebShopKulcsAdatokLista a vlasz tartalma, 
    *         vagy NULL res/hibs vlasz esetn
    */
    function load($answer) {
    	    	
    	$webShopKulcsAdatokLista = new WebShopKulcsAdatokLista();
        $resultSet = WebShopXmlUtils::getNodeByXPath($answer, '//answer/resultset');
                
        if(!empty($resultSet)) {
        	$webShopKulcsAdatokLista->setPrivateKey(WebShopXmlUtils::getElementText($resultSet, 'privateKey'));
        }
        
        $recordList = WebShopXmlUtils::getNodeArrayByXPath($answer, '//answer/resultset/record');
        $lista = array();
        
        foreach ($recordList as $record) {
        	
            $webShopKulcsAdatok = new WebShopKulcsAdatok();
            
            $webShopKulcsAdatok->setLejarat(WebShopXmlUtils::getElementText($record, 'lejarat'));
            
            $lista[] = $webShopKulcsAdatok;
        }
        
        $webShopKulcsAdatokLista->setWebShopKulcsAdatok($lista);
        
        return $webShopKulcsAdatokLista;
    }

}

?>