<?php 

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname( __FILE__ ))));

require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WSAnswerFactory.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/DefineConst.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/WebShopXmlUtils.php';

/**
* A banki tranzakci vlaszt reprezentl value object.
* Tartalmazza az indtott tranzakcik bank oldali egyedi azonostjt,
* a vlasz xml szveges s DomDocument formjt, a vlasz xml annak 
* feldolgozsbl nyert value object reprezentcijt, valamint a vlasz-
* zenetek listjt.
* 
* @version 4.0
*/
class WResponse  {

    /***************
     * Folyamat-pldny bank oldali azonostja
     * 
     * @var string
     */
    var $instanceId = NULL;

    /***************
     * A vlasz teljes s eredeti szvege
     * 
     * @var string
     */
    var $response = NULL;

    /***************
     * A vlasz xml teljes s eredeti szvegnek DOM-ja
     * 
     * @var DomDocument
     */
    var $responseDOM = NULL;

    /***************
     * A vlasz xml value object formban
     * 
     * @var mixed
     */
    var $answerModel = NULL;

    /***************
     * A vlasz feldolgozsa sorn kinyert zenetkdok vektora.
     * Sikeres vgrehajts esetn csak a 'SIKER' szveget tartalmazza,
     * hibs lefuts esetn az egyes hibakdokat.
     * 
     * @var array
     */
    var $messages = array();

    /***************
     * A vlasz feldolgozsa sorn kinyert hibakdok vektora
     * Sikeres vgrehajts esetn res,
     * hibs lefuts esetn az egyes hibakdokat.
     * 
     * @var array
     */
    var $errors = array();
    
    /***************
     * A vlasz feldolgozsa sorn kinyert informcis zenetkdok vektora.
     * 
     * @var array
     */
    var $infos = array();

    /***************
     * Sikeres volt-e a tranzakci vgrehajtsa, azaz az zenetkdok 
     * listja tartalmazza-e a 'SIKER' szveget.
     * 
     * @var boolean
     */
    var $hasSuccessfulAnswer = NULL;
    
    /***************
     * Vgrehajtdott-e a tranzakci s rendelkezsre ll-e a vlaszadat.
     * Kommunikcis, timeout vagy egyb hiba esetn false az rtke
     * 
     * @var boolean
     */
    var $finished = NULL;
    
    /**
    * Konstruktor.
    * 
    * @param string $workflowname az indtott tranzakci kdja
    * @param WorkflowState $workflowState a banki SOAP fellet vlasznak
    *        bean reprezenzcija
    */
    function WResponse ($workflowname, $workflowState) {
        if (is_null($workflowState)) return;
        $this->instanceId = property_exists($workflowState, 'instanceId') ? $workflowState->instanceId : $workflowState->InstanceId;
        
        $completed = property_exists($workflowState, 'completed') ? $workflowState->completed : $workflowState->Completed === 'true';
        $timeout = property_exists($workflowState, 'timeout') ? $workflowState->timeout : $workflowState->Timeout === 'true';
        
        $this->finished = $completed && !$timeout;
        
        if ($this->finished) {
            WebShopXmlUtils::parseOutputXml((property_exists($workflowState, 'result') ? $workflowState->result : $workflowState->Result), $this);
            $answerFactory = WSAnswerFactory::getAnswerFactory($workflowname);
            $this->answerModel = $answerFactory->load($this->responseDOM);
        }
    }

    /**
    * @desc WResponse feltltse value object alapjn 
    */
    function loadAnswerModel($answerModel, $successful, $errorMsg = null) {
        $this->finished = true;
        $this->answerModel = $answerModel;
        $this->hasSuccessfulAnswer = $successful;
        if ($successful) {
            $this->messages[] = "SIKER";
        }
        else {
            if (!is_null($errorMsg)) {
                $this->errors[] = $errorMsg;
                $this->messages[] = $errorMsg;
            }
        }
    }
    
    /***************
     * Eldnti, hogy a folyamat-pldny vlasznak messagelist szekcija
     * tartalmaz-e hibazenetet.
     * Ha a folyamat nem terminlt, vagy a vlasz nem megszerezhet, a vlasz hamis.
     *
     * @return igaz, ha a hibazenetek listja nem res
     */
    function hasErrors() {
        return count($this->messages) > 0;
    }

    /***************
     * A folyamat-pldny vlaszban a messagelist szekcinak elemzett 
     * listjnak lekrdezse. "Elemzett", mert a SIKER kdot nem 
     * tartalmazza: sikeres lefuts esetn ez a lista res.
     * 
     * @return array zenetkd lista
     */
    function getMessages() {
        return $this->messages;
    }
    
    /***************
     * A folyamat-pldny vlaszban a messagelist szekcinak elemzett 
     * listjnak lekrdezse. "Elemzett", mert a SIKER kdot nem 
     * tartalmazza: sikeres lefuts esetn ez a lista res.
     * 
     * @return array hibakd lista
     */
    function getErrors() {
        return $this->errors;
    }

    /***************
     * A folyamat-pldny vlaszban az infolist szekcinak az elemzst s
     * betltst vgz metdus.
     * 
     * @return array informcis zenetkd lista
     */
    function getInfos() {
        return $this->infos;
    }

    /***************
     * Igaz, ha a tranzakci-futs befejezdtt.
     * Ha true, akkor a vlasz lehet sikeres vagy hibs lefuts is.
     * Ha  false, akkor kommunikcis vagy egyb hiba trtnt a 
     * tranzakci vgrehajtsa vagy a vlasz fogadsa sorn.
     *
     * @return boolean igaz, ha a tranzaktls befejezdtt
     */
    function isFinished() {
        return $this->finished;
    }

    /***************
     * A folyamat-pldny sikeres befejezdsnek megllaptsa
     * A folyamat sikeresen terminlt, ha a vlasz <messagelist> rszben szerepel
     * a SIKER zenet.
     * Ha a folyamat nem terminlt, vagy a vlasz nem megszerezhet, a vlasz hamis.
     *
     * @return boolean a sikeressg jelzje
     */
    function isSuccessful()  {
        return $this->hasSuccessfulAnswer;
    }

    /***************
     * A folyamat-pldny banki oldali pldny-azonostjnak kiolvassa
     *
     * @return string pldnyazonost (null, ha nincs megszerezve a pldny)
     */
    function getInstanceId() {
        return $this->instanceId;
    }

    /***************
     * A vgrehajtshoz tartoz vlasz xml, a megfelel value object reprezentciban
     *
     * @return mixed a vlasz bean kontnerte
     */
    function getAnswer() {
        return $this->answerModel;
    }

    /***************
     * A vgrehajtshoz tartoz vlasz xml, string reprezentciban
     *
     * @return string a vlasz xml
     */
    function getResponse() {
        return $this->response;
    }

    /***************
     * A vgrehajtshoz tartoz vlasz xml, DomDocument formjban
     *
     * @return DomDoument a vlasz 
     */
    function getResponseDOM() {
        return $this->responseDOM;
    }

}

?>