<?php

/**
* @desc A banki SOAP fellet startWorkflowSnyc tranzakci indts 
* szolgltatsnak visszatrsi rtkt reprezentl objektum.
* 
* Az NuSoap hasznlata miatt kerlt kialaktsra, ugyanis az ottani SOAP
* kliens nem objektumknt adja vissza a szolgltats eredmnyt,
* hanem asszociatv tmbknt. Ezt a tmbt lehet megadni az objektum
* egyik konstruktornak.
* 
* @version 4.0
*/
class WorkflowState {

    var $completed;
    var $timeout;
    var $startTime;
    var $endTime;
    var $result;
    var $instanceId;
    var $templateName;

    /**
    * @desc Asszociatv tmb betltse WorkflowState objektumba.
    * 
    * @param array $stateAsArray betltend asszociatv tmb
    */
    function WorkflowState($stateAsArray) {
        if (is_null($stateAsArray)) return;
                
        $this->completed = $stateAsArray['completed'];
        $this->timeout = $stateAsArray['timeout'];
        $this->startTime = $stateAsArray['startTime'];
        $this->endTime = $stateAsArray['endTime'];
        $this->result = $stateAsArray['result'];
        $this->instanceId = $stateAsArray['instanceId'];
        $this->templateName = $stateAsArray['templateName'];
    }

}
