<?php

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname( __FILE__ ))));

require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/RequestUtils.php';

/**
* Konfigurcis paramterek kezelsnek tmogatsa.
* Egyarnt kezeli a simpleshop s multishop krnyezet szerint kialaktott
* .config llomnyokat.
* 
* @version 4.0
*/
class ConfigUtils {

    /**
    * @desc Konfigurcis paramter kiolvassa simpleshop
    * vagy multishop krnyezet szerint kialaktott
    * .config llomnybl
    * 
    * @param Array config az konfigurcis fjl tartalma
    * @param String paramName a keresett konfigurcis paramter neve
    * @return string a paramter rtke vagy null
    */
    function safeConfigParam($config, $paramName) {
        return array_key_exists($paramName, $config) ? $config[$paramName] : null;
    }
        
    /**
    * @desc Konfigurcis paramter kiolvassa simpleshop
    * vagy multishop krnyezet szerint kialaktott
    * .config llomnybl
    * 
    * @param Array config az konfigurcis fjl tartalma
    * @param String paramName a keresett konfigurcis paramter neve
    * @param String posId a vonatkoz posId
    * @param mixed config a keresett konfigurcis paramter alaprtelmezett rtke 
    *   (arra az esetre, ha nem ltezik a megfelel paramter)
    * @return mixed a paramter rtke string vagy $defaultValue-val megegyez tpusban
    */
    function getConfigParam($config, $paramName, $posId = NULL, $defaultValue = NULL) {
        $paramValue = NULL;
        if (!is_null($posId)) {
            $paramValue = ConfigUtils::safeConfigParam($config, $paramName . '_' . $posId);
        }
        if (is_null($paramValue)) {
            $paramValue = ConfigUtils::safeConfigParam($config, $paramName);
        }
        if (is_null($paramValue)) {
            $paramValue = $defaultValue;
        }
        return $paramValue;
    }

    /**
    * @desc Logikai rtk konfigurcis paramter kiolvassa simpleshop
    * vagy multishop krnyezet szerint kialaktott
    * .config llomnybl
    * 
    * @param Array $config az konfigurcis fjl tartalma
    * @param String $paramName a keresett konfigurcis paramter neve
    * @param String $posId a vonatkoz posId
    * @param mixed $defaultValue a keresett konfigurcis paramter alaprtelmezett rtke 
    *   (arra az esetre, ha nem ltezik a megfelel paramter)
    * 
    * @return boolean a paramter (vagy de$faultValue) logikai rtke
    */
    function getConfigParamBool($config, $paramName, $posId = NULL, $defaultValue = NULL) {
        $paramValue = ConfigUtils::getConfigParam($config, $paramName, $posId = NULL, $defaultValue = NULL);
        return RequestUtils::getBooleanValue($paramValue);
    }
    
    /**
    * @desc A Java-ra jellemz konfigurcis paramter helyettests 
    * megvalstsa: a $paramValue string-ben szerepl {key} rtkek
    * lecserlse a $values[key] szvegre.
    * 
    * @param string paramValue a helyettestsre vr szveg
    * @param array a helyettestsek key/value prban$
    * 
    * @return string a helyettestett szveg 
    */
    function substConfigValue($paramValue, $values) {
        foreach ($values as $key => $value) {
            $paramValue = str_replace("{" . $key ."}", $value, $paramValue);
        }
        return $paramValue;       
    }
    
}

?>