<?php
     
/**
* A SimpleShop PHP s a WebShop PHP kliens ltal hasznlt utility osztly
* a REQUEST paramterek kezelsre, tpus-konverzik elvgzsre, URL manipulcira.
* 
* @version 4.0
*/

class RequestUtils {

    /**
     * Logikai tpus request paramter kiolvassa,
     * s boolean rtkk alaktsa.
     * Lehetsges true rtkek: 'true', 'on', 'yes'.
     * (Kis- s nagybet rzkenysg nincs.)
     * 
     * @param request http request (paramter vektor)
     * @param paramName a paramter neve
     * @return a paramter szveges rtke
     */
    function getBooleanRequestAttribute($paramMap, $paramName, $dflt = false) {
        return RequestUtils::getBooleanValue($paramMap[$paramName]);        
    }

    /**
     * Logikai tpus request paramter kiolvassa,
     * s boolean rtkk alaktsa.
     * Lehetsges true rtkek: 'true', 'on', 'yes', '1'.
     * (Kis- s nagybet rzkenysg nincs.)
     * 
     * @param request http request (paramter vektor)
     * @param paramName a paramter neve
     * @return a paramter szveges rtke
     */
    function getBooleanValue($value, $dflt = false) {
        $boolValue = false;
        
        if (is_bool($value)) {
            $boolValue = $value;
        }
        else if (is_null($value)) {
            $boolValue = $dflt;
        }
        else {
            $boolValue = in_array(strtoupper($value), array ("TRUE", "ON", "YES", "1"));
        }

        return $boolValue;        
    }
    
    /**
     * Logikai tpus vltoz rtk olyan string- alaktsa,
     * mely a banki felleten a logikai rtket reprezentlja az egyes
     * hvsokban: "TRUE" vagy "FALSE" rtk.
     * 
     * Az alakts szablya:
     * - false rtk: "FALSE"
     * - true vagy "true", "on", "yes" rtkek valamelyike: "TRUE"
     * - egybknt: a $dflt vltoz rtke, alaprtelmezs szerint "FALSE"
     * 
     * @param mixed value a logikai vagy string vltoz
     * @return string a paramter szveges rtke
     */
    function booleanToString($value, $dflt = "FALSE") {
        $boolValue = RequestUtils::getBooleanValue($value, NULL);
        return ($boolValue === true ? "TRUE" : ($boolValue === false ? "FALSE" : $dflt));        
    }

    /**
     * Date tpus vltoz rtk olyan string- alaktsa,
     * mely a banki felleten a dtum/idpomt rtket reprezentlja az egyes
     * hvsokban: .HH.NN :PP:MM alak rtk.
     * 
     * @param mixed value a dtum vltoz
     * @return string a paramter szveges rtke
     */
    function dateToString($value) {
        $strValue = "";
        
        if (is_string($value)) {
            $strValue = $value;
        }
        else if (is_int($value)) {
            $strValue = date("Y.m.d H:i:s", $value);
        }
                                 
        return $strValue;        
    }
    
    /**
    * @desc Adott url-hez hozzfz tovbbi request paramtereket.
    * Az eljrssal tetszleges url mdosthat.
    * Elsdleges clja a backURL manipullsnl van.
    */
    function addUrlQuery($url, $params) {
        $parsedUrl = parse_url($url); 
        parse_str($parsedUrl['query'], $queryParams);
        $queryParams = array_merge($queryParams, $params);
        $newQuery = NULL;
        foreach ($queryParams as $key => $value) {
            $newQuery .= ($newQuery ? '&' : '') . urlencode($key) . '='. urlencode($value); 
        }

        $newUrl = ''
            . (array_key_exists('scheme', $parsedUrl) ? $parsedUrl['scheme'] . '://' : '')
            . (array_key_exists('user', $parsedUrl) ? $parsedUrl['user'] : '')
            . (array_key_exists('pass', $parsedUrl) ? ':' . $parsedUrl['pass'] : '')
            . (array_key_exists('user', $parsedUrl) || array_key_exists('pass', $parsedUrl) ? '@' : '')
            . (array_key_exists('host', $parsedUrl) ? $parsedUrl['host'] : '')
            . (array_key_exists('port', $parsedUrl) ? ':' . $parsedUrl['port'] : '')
            . (array_key_exists('path', $parsedUrl) ? $parsedUrl['path'] : '')
            . ($newQuery ? '?' . $newQuery : '')
            . (array_key_exists('fragment', $parsedUrl) ? '#' . $parsedUrl['fragment'] : '');
        
        return $newUrl;
    }
    
    /**
    * @desc Vezrls tovbbts adott cmre (jellemzen php kdra).
    * - Amennyiben az $url-ben nincs host, felttelezzk, hogy loklis
    * fjlrl van sz, ezrt az include() utastssal hivatkozunk a 
    * fjlra ahelyett, hogy redirect-lnnk r. Ennek az az elnye,
    * hogy a "hv" ltal ellltott _REQUEST s _SESSION paramterek
    * gond nlkl elrhetek. A fjlnak, mint relatv elrsnek az 
    * include_path valamely eleme mentn elrhetnek kell lennie.
    * - Ha az $url tartalmaz host megjellst, akkor kliens oldali redirect
    * fog trtnni ("Location" header paramter generlssal)
    */
    function includeOrRedirect($url) {
        $parsedUrl = parse_url($url);
        if (!array_key_exists('host', $parsedUrl)) {
            include($url);   
        }
        else {
            header('Location: ' . $url);
        }
    }
    
    /**
    * @desc Konfigurcis paramter kiolvassa simpleshop
    * vagy multishop krnyezet szerint kialaktott
    * .config llomnybl
    * 
    * @param Array config az konfigurcis fjl tartalma
    * @param String paramName a keresett konfigurcis paramter neve
    * @return string a paramter rtke vagy null
    */
    function safeParam($request, $paramName) {
        return array_key_exists($paramName, $request) ? $request[$paramName] : null;
    }
    
}

?>