<?php

/**
* A WebShop PHP kliens ltal hasznlt utility osztly
* digitlis alrs generlsra PHP5 krnyezetben.
* 
* @version 4.0
*/

class SignatureUtils {

    /**
    * Privt kulcs fjlrendszerbl trtn betltse s rtelmezse.
    * A kulcs llomnynak PEM formban kell lennie!
    * 
    * @param string $privKeyFileName a privt kulcs llomny elrsi cme
    * @return resource privt kulcs
    */
    function loadPrivateKey($privKeyFileName) {
        $priv_key = file_get_contents($privKeyFileName);
        $pkeyid = openssl_get_privatekey($priv_key);
        return $pkeyid;
    }

    /**
    * Alrand szveg ellltsa az alrand szveg rtkek listjbl:
    * [s1, s2, s3, s4]  ->  's1|s2|s3|s4'
    * 
    * @param array alrand mezk 
    * @return string alrand szveg
    */
    function getSignatureText($signatureFields) {
        $signatureText = '';
        foreach ($signatureFields as $data) {
            $signatureText = $signatureText.$data.'|';
        }

        if (strlen($signatureText) > 0) {
            $signatureText = substr($signatureText, 0, strlen($signatureText) - 1);
        }

        return $signatureText;
    }

    /**
    * Digitlis alrs generlsa a Bank ltal elvrt formban.
    * Az alrs sorn az MD5 hash algoritmust hasznljuk 5.4.8-nl kisebb verzij PHP
    * esetn, egybknt SHA-512 algoritmust.
    * 
    * @param string $data az alrand szveg
    * @param resource $pkcs8PrivateKey privt kulcs
    * 
    * @return string digitlis alrs, hexadecimlis formban (ahogy a banki fellet elvrja). 
    */
    function generateSignature($data, $pkcs8PrivateKey, $properties, $logger) {
    	
    	global $signature;
    	
    	if (version_compare(PHP_VERSION, '5.4.8', '>=')) {
        	openssl_sign($data, $signature, $pkcs8PrivateKey, OPENSSL_ALGO_SHA512);
    	}
    	else {
    		openssl_sign($data, $signature, $pkcs8PrivateKey, OPENSSL_ALGO_MD5);
    	}
    	
        return bin2hex($signature);
    }

}

?>