<?php

/**
*
* Ktszerepls fizetsi tranzakci indtsa PHP krnyezetbl. Az indtst a
* process metdus vgzi, mely a banki SOAP fellet kzvetlen meghvsval
* elindtja a ktszerepls fizetsi tranzakcit. A kliens oldali bngsz
* mindaddig az oldal letltsre fog vrakozni, mg a tranzakci be nem
* fejezdtt - a vrakokzi id jellemzen 1-2 msodperc.
*
* Az indtst kveten a process metdus alaprtelmezett mkdse:
* - Amennyiben a tranzakci sikeresen lefutott, s a vlasz feldolgozsa
* sem jelez hibt, a kliens oldal a "webshop_success_answerpage_url"
* paramterben megadott url-re fog kerlni, mely url-be rendre az albbi
* rtkek fognak behelyettestdni: posId, tranzakci azonost, authorizcis
* kd.
* - Amennyiben a tranzakci sikertelenl futott le, akkor a 
* "webshop_failed_answerpage_url" paramterben megadott url-re fog kerlni 
* a vezrls, a posId, tranzakci azonost s hibakd behelyettestdse utn.
* - Egyb esetben (megszakadt kommunikci, vagy a vlasz feldolgozs
* hibt jelez) a webshop_unknown_answerpage_url paramterben megadott url-re 
* fog kerlni a vezrls, a posId s tranzakci azonost behelyettestdse utn.
* A vezrlstads trtnhet a PHP include utastsval vagy bngsz oldali
* redirectlssal.
*
* A vonatkoz paramterek a ketszereplosshop.conf fjlban konfigurlhatk.
*
* A process metdus megfelel paramterezse mellett a vezrlstads lps 
* kihagyhat. Ilyenkor a metdus visszatrsi rtke hasznlhat, mely a 
* Banki fellet teljes vlaszt tartalmazza. Ugyancsak hozzfrhet a fizetsi 
* vlasz objektum akkor, ha a fenti url jelleg paramter loklis php kdra 
* trtn hivatkozst tartalmaznak, amit a kontroller include-olhat.
*
* Az eljrs tmogatja a ktlpcss fizetsi mdot: ha paramterknt tadsra
* kerl a ketlepcsosFizetes jelz, akkor annak logikai rtke explicit mdon
* tadsra kerl a Bank fel kldtt krsben.
*
* A forrskd demonstrcis jelleg, szabadon mdosthat.
*
@version 4.0
*/

define('SIMPLESHOP_CONFIGURATION', '../config/ketszereplosshop.conf');

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');

require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopService.php');
//require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopServiceSimulator.php');
require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/ConfigUtils.php');

/**
* @desc Ktszerepls fizetsi tranzakci indtsa, a bank oldali
* kommunikci lebonyoltsval s a vev oldali (bngsz) fellet
* megfelel tirnytsval.
* 
* Automatikus redirektls / include-ols esetn definilsra kerl rtkek
* illetve global vltozk:
* "response" => WResponse tpus objektum, mely a fizetsi tranzakcihoz
*               tartoz sszes vlaszadatot tartalmazza
* "tranzAdatok" => WebShopFizetesValasz tpus objektum, a sikeres 
*                  vsrlshoz tartoz vlaszobjektum (value object)
* 
* @param $doRedirect a fizetsi tranzakci vgrehajtsa utn vgre kell-e
* hajtani az eredmnyoldalakra trtn redirect / include lpseket a
* ketszereplosshop.conf (vagy a 'SIMPLESHOP_CONFIGURATION'-ban megadott)
* llomnyban lert url-ek alapjn. [Alaprtelmezett rtk: true]
* 
* @return a fizetsi tranzakci banki fellet ltal visszaadott s 
* rtelmezett rtke, WResponse tpus objektum. 
*/
function process($doRedirect = true) {

    global $response;
    
    $service = new WebShopService();

    $posId = RequestUtils::safeParam($_REQUEST, "posId");
    $tranzAzon = RequestUtils::safeParam($_REQUEST, "tranzakcioAzonosito");
    if (is_null($tranzAzon) || (trim($tranzAzon) == "")) {               
        $tranzAzonResponse =  $service->tranzakcioAzonositoGeneralas($posId);
        if ($tranzAzonResponse->hasSuccessfulAnswer) {
            $tranzAzon = $tranzAzonResponse->answerModel->getAzonosito();
        }
    }

    global $response;
    if (!is_null($tranzAzon) && (trim($tranzAzon) != "")) {

        // Fizetsi tranzakci indtsa
        syslog(LOG_NOTICE, "Ketszereplos fizetes keres kuldes: " . $posId . " - " . $tranzAzon);

        $response = $service->fizetesiTranzakcioKetszereplos(
            $posId,
            $tranzAzon,
            RequestUtils::safeParam($_REQUEST,"osszeg"),
            RequestUtils::safeParam($_REQUEST,"devizanem"),
            RequestUtils::safeParam($_REQUEST,"nyelvkod"),
            RequestUtils::safeParam($_REQUEST,"regisztraltUgyfelId"),
            RequestUtils::safeParam($_REQUEST,"kartyaszam"),
            RequestUtils::safeParam($_REQUEST,"cvc2Cvv2"),
            RequestUtils::safeParam($_REQUEST,"kartyaLejarat"),
            RequestUtils::safeParam($_REQUEST,"vevoNev"),
            RequestUtils::safeParam($_REQUEST,"vevoPostaCim"),
            RequestUtils::safeParam($_REQUEST,"vevoIPCim"),
            RequestUtils::safeParam($_REQUEST,"ertesitoMail"),
            RequestUtils::safeParam($_REQUEST,"ertesitoTel"),
            RequestUtils::safeParam($_REQUEST,"ketlepcsosFizetes"),
            RequestUtils::safeParam($_REQUEST, 'zsebAzonosito'));

        /*********
         Itt a helye a shop-specifikus eredmny feldolgozsnak / trolsnak
         ********/
    }
    else {
        /* Sikertelen volt a tranzakci azonosts */
    }
    
    if ($response) {
        global $tranzAdatok;
        $tranzAdatok = $response->getAnswer();
        syslog(LOG_NOTICE, "Ketszereplos fizetes keres kuldes: " . $posId . " - " . $tranzAzon . " - " . implode($response->getMessages()));
    }
    else {
        syslog(LOG_ERR, "Ketszereplos fizetes keres kuldes: " . $posId . " - " . $tranzAzon . " - NEM ERTELMEZHETO VALASZ!");
    }

    if ($doRedirect) processRedirect($posId, $tranzAzon, $response);        
    
    return $response;
}

/**
 * @desc A ktszerepls fizets eredmnynek megjelentse a shop oldalon
 * a ketszereplosshop.conf (vagy a 'SIMPLESHOP_CONFIGURATION'-ban megadott)
 * llomnyban lert url-ek alapjn.
 *
 * A metdus a fizetsi tranzakci vlasznak megfelelen
 * jelent meg egy hiba oldalt vagy eredmny oldalt.
 * 
 * A $_REQUEST-be kerl rtkek:
 * "response" => WResponse tpus objektum, mely a fizetsi tranzakcihoz
 *               tartoz sszes vlaszadatot tartalmazza
 * "tranzAdatok" => WebShopFizetesValasz tpus objektum, a sikeres 
 *                  vsrlshoz tartoz vlaszobjektum (value object)
 */
function processRedirect($posId, $tranzAzon, $response) {

    $config = parse_ini_file(SIMPLESHOP_CONFIGURATION);

    $successAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_success_answerpage_url', $posId);
    $failedAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_failed_answerpage_url', $posId);
    $unknownAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_unknown_answerpage_url', $posId);

    // Igaz, ha sikertelen volt a tranzakci indts, vagy a vlasz rtelmezse
    $isUnknown = true;

    // Igaz, ha a fizets visszautastsra kerlt a banki oldalon
    $isFailedPayment = false;

    $_REQUEST['response'] = $response;

    if ($response) {
        global $tranzAdatok;
        $tranzAdatok = $response->getAnswer();
        $_REQUEST['tranzAdatok'] = $tranzAdatok;
        
        if ($response->isSuccessful()
                && $response->getAnswer()) {
            // Sikerlt a tranzakci indts 
            $responseCode = $tranzAdatok->getValaszkod();

            $successPosResponseCodes = array(
                "000", "00", "001", "002", "003", "004",
                "005", "006", "007", "008", "009", "010");

            if (in_array($responseCode, $successPosResponseCodes)) {
                // A vsrls sikeres volt
                $successAnswerPage = ConfigUtils::substConfigValue($successAnswerPage,
                    array("0" => urlencode($posId),
                          "1" => urlencode($tranzAzon),
                          "2" => urlencode($tranzAdatok->getAuthorizaciosKod())));
                RequestUtils::includeOrRedirect($successAnswerPage);
            }
            else {
                // A tranzakci sikertelen volt.
                // Valsznleg a krtya terhels nem vgezhet el
                $failedAnswerPage = ConfigUtils::substConfigValue($failedAnswerPage,
                    array("0" => urlencode($posId),
                          "1" => urlencode($tranzAzon),
                          "2" => urlencode($responseCode)));
                RequestUtils::includeOrRedirect($failedAnswerPage);
            }
        }
        else {
            // A tranzakci sikertelen volt.
            // Valsznleg a krtya terhels nem vgezhet el
            $failedAnswerPage = ConfigUtils::substConfigValue($failedAnswerPage,
                array("0" => urlencode($posId),
                      "1" => urlencode($tranzAzon),
                      "2" => urlencode(implode(',', $response->getMessages()))));
            RequestUtils::includeOrRedirect($failedAnswerPage);
        }
    }
    else {
        // Ha nem sikerlt elindtani a folyamatot vagy rtelmezni a vlaszt...
        $unknownAnswerPage = ConfigUtils::substConfigValue($unknownAnswerPage,
            array("0" => urlencode($posId),
                  "1" => urlencode($tranzAzon)));
        RequestUtils::includeOrRedirect($unknownAnswerPage);
    }
}

?>