<?php

/**
*
* Ktlpcss fizetsi tranzakci lezrsnak indtsa PHP krnyezetbl.
* A vgrehajtst a process metdus vgzi, mely a banki SOAP fellet kzvetlen
* meghvsval elindtja a a fizets lezrsi tranzakcit. A kliens oldali bngsz
* mindaddig az oldal letltsre fog vrakozni, mg a tranzakci be nem
* fejezdtt - a vrakokzi id jellemzen 1-2 msodperc.
*
* Az indtst kveten a process metdus alaprtelmezett mkdse:
* - Amennyiben a tranzakci sikeresen lefutott, s a vlasz feldolgozsa
* sem jelez hibt, a kliens oldal a "webshop_success_answerpage_url"
* paramterben megadott url-re fog kerlni, mely url-be rendre az albbi
* rtkek fognak behelyettestdni: posId, tranzakci azonost, authorizcis
* kd.
* - Amennyiben a tranzakci sikertelenl futott le, akkor a
* "webshop_failed_answerpage_url" paramterben megadott url-re fog kerlni
* a vezrls, a posId, tranzakci azonost s hibakd behelyettestdse utn.
* - Egyb esetben (megszakadt kommunikci, vagy a vlasz feldolgozs
* hibt jelez) a webshop_unknown_answerpage_url paramterben megadott url-re
* fog kerlni a vezrls, a posId s tranzakci azonost behelyettestdse utn.
* A vezrlstads trtnhet a PHP include utastsval vagy bngsz oldali
* redirectlssal.
*
* A vonatkoz paramterek a ketlepcsoslezaras.conf konfigurlhatak.
*
* A process metdus megfelel paramterezse mellett a vezrlstads lps
* kihagyhat. Ilyenkor a metdus visszatrsi rtke hasznlhat, mely a
* Banki fellet teljes vlaszt tartalmazza.
*
* Ne feledjk, hogy a lezrs mvelete nem ktdik a vevhz,
* hiszen tisztn bolti / adminisztratv jelleg tevkenysgrl van sz.
*
* A forrskd demonstrcis jelleg, szabadon mdosthat.
*
* @version 4.0
*
*/

define('SIMPLESHOP_CONFIGURATION', '../config/ketlepcsoslezaras.conf');

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');

require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopService.php');
//require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopServiceSimulator.php');
require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/ConfigUtils.php');

/**
* @desc Ktlpcss fizets lezrsi tranzakci indtsa, a bank oldali
* kommunikci lebonyoltsval s a bolt oldali (bngsz) fellet
* megfelel tirnytsval. Ne feledjk, hogy ez a mvelet nem ktdik
* a vevhz, hiszen tisztn bolti / adminisztratv jelleg tevkenysgrl
* van sz.
*
* Automatikus redirektls / include-ols esetn definilsra kerl rtkek
* illetve global vltozk:
* "response" => WResponse tpus objektum, mely a fizetsi tranzakcihoz
*               tartoz sszes vlaszadatot tartalmazza
* "tranzAdatok" => WebShopFizetesValasz tpus objektum, a sikeres
*                  vsrlshoz tartoz vlaszobjektum (value object)
*
* @param $doRedirect a fizetsi tranzakci vgrehajtsa utn vgre kell-e
* hajtani az eredmnyoldalakra trtn redirect / include lpseket a
* ketszereplosshop.conf (vagy a 'SIMPLESHOP_CONFIGURATION'-ban megadott)
* llomnyban lert url-ek alapjn. [Alaprtelmezett rtk: true]
*
* @return a fizetsi tranzakci banki fellet ltal visszaadott s
* rtelmezett rtke, WResponse tpus objektum.
*/
function process($doRedirect = true) {

    global $response;

    $service = new WebShopService();

    $posId = RequestUtils::safeParam($_REQUEST, "posId");
    $tranzAzon = RequestUtils::safeParam($_REQUEST, "tranzakcioAzonosito");
    $osszeg = RequestUtils::safeParam($_REQUEST, 'osszeg');

    global $response;
    if (!is_null($tranzAzon) && (trim($tranzAzon) != "")) {

        // Fizetsi tranzakci lezrs indtsa
        syslog(LOG_NOTICE, "Ketlepcsos fizetes lezaras kuldes: " . $posId . " - " . $tranzAzon);

        $response = $service->fizetesiTranzakcioLezaras(
            $posId,
            $tranzAzon,
            RequestUtils::safeParam($_REQUEST, "jovahagyo"),
	        $osszeg);


        /*********
         Itt a helye a shop-specifikus eredmny feldolgozsnak / trolsnak
         ********/
    }
    else {
        /* Sikertelen volt a tranzakci azonosts */
    }

    if ($response) {
        global $tranzAdatok;
        $tranzAdatok = $response->getAnswer();
        syslog(LOG_NOTICE, "Ketlepcsos fizetes lezara keres kuldes: " . $posId . " - " . $tranzAzon . " - " . $osszeg . " - " . implode($response->getMessages()));
    }
    else {
        syslog(LOG_ERR, "Ketlepcsos fizetes lezara keres kuldes: " . $posId . " - " . $tranzAzon . " - " . $osszeg . " - NEM ERTELMEZHETO VALASZ!");
    }

    if ($doRedirect) processRedirect($posId, $tranzAzon, $response);

    return $response;
}

/**
 * @desc A ktlpcss fizets lezrs eredmnynek megjelentse a shop oldalon
 * a ketlepcsoslezaras.conf (vagy a 'SIMPLESHOP_CONFIGURATION'-ban megadott)
 * llomnyban lert url-ek alapjn.
 *
 * A metdus a lezrsi tranzakci vlasznak megfelelen
 * jelent meg egy hiba oldalt vagy eredmny oldalt.
 *
 * A $_REQUEST-be kerl rtkek:
 * "response" => WResponse tpus objektum, mely a fizetsi tranzakci
 *               lezrshoz tartoz banki vlaszadatot reprezentlja
 * "tranzAdatok" => WebShopFizetesValasz tpus objektum, a sikeres
 *                  vsrlshoz tartoz vlaszobjektum (value object)
 */
function processRedirect($posId, $tranzAzon, $response) {

    $config = parse_ini_file(SIMPLESHOP_CONFIGURATION);

    $successAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_success_answerpage_url', $posId);
    $failedAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_failed_answerpage_url', $posId);
    $unknownAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_unknown_answerpage_url', $posId);

    $_REQUEST['response'] = $response;

    if ($response) {
        global $tranzAdatok;
        $tranzAdatok = $response->getAnswer();
        $_REQUEST['tranzAdatok'] = $tranzAdatok;

        if ($response->isSuccessful()
                && $response->getAnswer()) {
            // Sikerlt a lezrs indts
            $responseCode = $tranzAdatok->getValaszkod();

            $successPosResponseCodes = array(
                "000", "00", "001", "002", "003", "004",
                "005", "006", "007", "008", "009", "010");

            if (in_array($responseCode, $successPosResponseCodes)) {
                // A lezrs sikeres volt
                $successAnswerPage = ConfigUtils::substConfigValue($successAnswerPage,
                    array("0" => urlencode($posId),
                          "1" => urlencode($tranzAzon),
                          "2" => urlencode($tranzAdatok->getAuthorizaciosKod())));
                RequestUtils::includeOrRedirect($successAnswerPage);
            }
            else {
                // A lezrs sikertelen volt.
                $failedAnswerPage = ConfigUtils::substConfigValue($failedAnswerPage,
                    array("0" => urlencode($posId),
                          "1" => urlencode($tranzAzon),
                          "2" => urlencode($responseCode)));
                RequestUtils::includeOrRedirect($failedAnswerPage);
            }
        }
        else {
            // A lezrs sikertelen volt.
            $failedAnswerPage = ConfigUtils::substConfigValue($failedAnswerPage,
                array("0" => urlencode($posId),
                      "1" => urlencode($tranzAzon),
                      "2" => urlencode(implode(',', $response->getMessages()))));
            RequestUtils::includeOrRedirect($failedAnswerPage);
        }
    }
    else {
        // Ha nem sikerlt elindtani a folyamatot vagy rtelmezni a vlaszt...
        $unknownAnswerPage = ConfigUtils::substConfigValue($unknownAnswerPage,
            array("0" => urlencode($posId),
                  "1" => urlencode($tranzAzon)));
        RequestUtils::includeOrRedirect($unknownAnswerPage);
    }
}

?>