<?php 
    /**
    * @desc Plda olyan eredmny oldalra, melyre a ktlpcss
    * fizets lezrs sikeres vgrehajtsa utn trtnik a vezrlstads
    * PHP kdbeli include / require utastssal.
    * 
    * A kd lnyegben megegyezik a ktszerepls fizets eredmnyt
    * megjelent fiz2_answer_i.php kdra, hiszen ugyanolyan tpus
    * banki vlasz adatot kell megjelenteni, mint abban.
    * 
    * Az llomnyt a pldnkban a tranzLezaras_control.php include-olja,
    * a ketlepcsoslezaras.conf fjl megfelel konfigurlsa esetn.
    * Ilyenkor kt global lthatsg PHP objektum vltoz ll
    * rendelkezsre, mely tartalmazza a fizets sszes vlaszadatt:
    * - response: WResponse tpus objektum, mely a fizetsi 
    *   tranzakcihoz tartoz sszes vlaszadatot tartalmazza
    * - tranzAdatok: WebShopFizetesValasz tpus objektum, a sikeres 
    *   vsrlshoz tartoz vlaszobjektum (value object)
    * 
    */

    if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');

    require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/ErrorMessages.php');

    require_once('_header_footer.php');
    demo_header($_REQUEST['func']);
    demo_menu();
    demo_title(); 
    
    global $response; 
    global $tranzAdatok;
?>

<?php if (is_null($response) || !$response->isFinished()) { ?>
    <h2 class="hiba">A lezrs nem hajtdott vgre vagy a banki vlasz nem rtelmezhet.</h2>
<?php } else if ($response->isSuccessful()) { ?>
    <h2 class="siker">A lezrs sikeresen vgrehajtdott.</h2>
<?php } else { ?>
    <h2 class="hiba">Hiba a tranzakci lezrs sorn, banki vlaszkd: <?php echo implode(', ', $response->getMessages()) ?></h2>
<?php } ?>

<?php if (!is_null($tranzAdatok)) { ?>

    <table class="eredmenytabla1">
      <?php if ($response->isSuccessful()) { ?>
          <tr>
            <th>Tranzakci azonosit:</th>
            <td><?php echo $tranzAdatok->getAzonosito() ?></td>
          </tr>
          <tr>
            <th>Shop ID:</th>
            <td><?php echo $tranzAdatok->getPosId() ?></td>
          </tr>

          <tr>
            <th>Teljesites idpontja:</th>
            <td><?php echo $tranzAdatok->getTeljesites() ?></td>
          </tr>
          <tr>
            <th>Vlaszkd:</th>
            <td><?php echo $tranzAdatok->getValaszKod() ?></td>
          </tr>
          <tr>
            <th>Authorizcis kd:</th>
            <td><?php echo $tranzAdatok->getAuthorizaciosKod() ?></td>
          </tr>
      <?php } else { ?>
          <tr>
            <th>Hibakd:</th>
            <td>
                <?php foreach ($response->getErrors() as $error) { 
                        $errorMsg = getMessageText($error);
                ?>
                    <p>    
                       <?php echo $error . ($errorMsg ? " - " . $errorMsg : "") ?>
                    </p>
                <?php } ?>
            </td>
          </tr>
      <?php } ?>
    </table>

<?php } else { ?>

    <table class="eredmenytabla1">
      <tr>
        <th>Tranzakci azonosit:</th>
        <td><?php echo $_REQUEST['tranzakcioAzonosito'] ?></td>
      </tr>
      <tr>
        <th>Shop ID:</th>
        <td><?php echo $_REQUEST['posId'] ?></td>
      </tr>
    </table>

<?php } ?>

<?php demo_footer(); ?>