unit uConfig;

interface

const
  INIFILE_NAME = 'PINBoritekNyomtato.ini';
  PERSONALINIFILE_NAME = 'PINEgyeniParam.ini';
  INIFILE_SECTION_CONNECT = 'Kapcsolodas';
  INIFILE_IDENT_MWURL = 'OTPMW_SERVER_URL';

  INIFILE_IDENT_WEBSERVICE_POSTFIX = 'WEBSERVICE_POSTFIX';
  INIFILE_IDENT_WEBSERVICE_WSDL_POSTFIX = 'WEBSERVICE_WSDL_POSTFIX';
  INIFILE_IDENT_WEBSERVICE_SERVICE = 'WEBSERVICE_SERVICE';
  INIFILE_IDENT_WEBSERVICE_PORT = 'WEBSERVICE_PORT';

  INIFILE_SECTION_PATTERN = 'Sablon';

type TPatternCategory = (pcBianko, pcHB, pcTC);
     TPatternArray = array [TPatternCategory] of String;
const
  INIFILE_IDENT_PATTERNS : TPatternArray
    = ('BiankoMinta', 'HBPinMinta', 'TCPinMinta');

  INIFILE_IDENT_DOCLIMIT : TPatternArray
    = ('BiankoDocLimit', 'HBPinDocLimit', 'TCPinDocLimit');

  INIFILE_IDENT_PATTERNUSAGE : TPatternArray
    = ('BiankoSablonHasznalat', 'HBPinSablonHasznalat', 'TCPinSablonHasznalat');


const
  DEMODIR_FLAG = 'demoDir';
  DEMONAME_FLAG = 'demoName';

  function isDemoMode(): boolean;
  function getDemoXmlDir(): string;
  function logSoapMessages(): boolean;

  function getPinPattern(patternCategory: TPatternCategory): string;
  function getPrintDocLimit(patternCategory: TPatternCategory): integer;

  function getPatternUsage(patternCategory: TPatternCategory): boolean;
  procedure storePatternUsage(patternCategory: TPatternCategory; use: boolean);

implementation

  uses SysUtils, Forms, StrUtils, IniFiles;

  function isDemoMode(): boolean;
  begin
    result := FindCmdLineSwitch('demoMode', true);
  end;

  function logSoapMessages(): boolean;
  begin
    result := FindCmdLineSwitch('logSoapMessages', true);
  end;

  function getDemoXmlDir(): string;
  var
    i: integer;
    param: string;
  begin
    result :=
      ExtractFilePath(Application.ExeName)
        + '/demoXml';
    for i:=1 to ParamCount do begin
      param := ParamStr(i);
      if (copy(param, 2, length(DEMODIR_FLAG)) = DEMODIR_FLAG) then begin
        result :=
          RightStr(param, length(param) - length(DEMODIR_FLAG) - 2);
        break;
      end;
      if (Copy(param, 2, length(DEMONAME_FLAG)) = DEMONAME_FLAG) then begin
        result :=
          result + '/' +
          RightStr(param, length(param) - length(DEMONAME_FLAG) - 2);
        break;
      end;
    end;
  end;

  function getPinPattern(patternCategory: TPatternCategory): string;
  var iniFile: TIniFile;
  begin
    iniFile := TIniFile.Create(
                ExtractFilePath(Application.ExeName) + INIFILE_NAME);
    result := iniFile.ReadString(
      INIFILE_SECTION_PATTERN,
      INIFILE_IDENT_PATTERNS[patternCategory],
      '');
  end;

  function getPrintDocLimit(patternCategory: TPatternCategory): integer;
  var
    iniFile: TIniFile;
    tmp: string;
  begin
    iniFile := TIniFile.Create(
                ExtractFilePath(Application.ExeName) + INIFILE_NAME);
    tmp := iniFile.ReadString(
      INIFILE_SECTION_PATTERN,
      INIFILE_IDENT_DOCLIMIT[patternCategory],
      '0');
    result := strtoint(tmp);

  end;

  function getPatternUsage(patternCategory: TPatternCategory): boolean;
  var
    iniFile: TIniFile;
    tmp: string;
  begin
    iniFile := TIniFile.Create(
                ExtractFilePath(Application.ExeName) + PERSONALINIFILE_NAME);
    tmp := iniFile.ReadString(
      INIFILE_SECTION_PATTERN,
      INIFILE_IDENT_PATTERNUSAGE[patternCategory],
      BoolToStr(false));
    result := StrToBoolDef(tmp, false);
  end;

  procedure storePatternUsage(patternCategory: TPatternCategory; use: boolean);
  var
    iniFile: TIniFile;
    tmp: string;
  begin
    iniFile := TIniFile.Create(
                ExtractFilePath(Application.ExeName) + PERSONALINIFILE_NAME);
    iniFile.WriteString(
      INIFILE_SECTION_PATTERN,
      INIFILE_IDENT_PATTERNUSAGE[patternCategory],
      BoolToStr(use, true));
  end;

end.
