unit uHTTPReqRespLogger;

interface

uses
  SOAPHTTPTrans, SOAPHTTPClient, InvokeRegistry, Classes;

  type THTTPReqRespLogger = class (THTTPReqResp)
  private
    function getReceivedDataAsString: string;
    function getSentDataAsString: string;

    public
      function Send(const ASrc: TStream): Integer; override;
      procedure Receive(Context: Integer; Resp: TStream; IsGet: Boolean); override;

    protected
      fSentData: TStream;
      fReceivedData: TStream;

    public
      property sentString: string read getSentDataAsString;
      property receivedString: string read getReceivedDataAsString;

  end;

//  procedure configure

implementation

uses
  SysUtils, XMLDoc, xmldom, XMLIntf, Rio;

{ THTTPReqRespLogger }

function THTTPReqRespLogger.Send(const ASrc: TStream): Integer;
var doc: TXMLDocument;
begin
  if (fSentData <> nil) then fSentData.Free();
  fSentData := TStringStream.Create('');
  aSrc.Position := 0;
  fSentData.CopyFrom(aSrc, aSrc.Size);
  result := 0;
  result := inherited Send(aSrc);
end;

procedure THTTPReqRespLogger.Receive(Context: Integer; Resp: TStream;
  IsGet: Boolean);
begin
  inherited Receive(Context, Resp, IsGet);
  if (fReceivedData <> nil) then fReceivedData.Free();
  fReceivedData:= TMemoryStream.Create();
  Resp.Position := 0;
  fReceivedData.CopyFrom(resp, resp.Size);
end;


function THTTPReqRespLogger.getReceivedDataAsString(): string;
var
  strm: TStringStream;
begin
  strm := TStringStream.create('');
  if (fReceivedData <> nil) then begin
    fReceivedData.Position := 0;
    strm.CopyFrom(fReceivedData, fReceivedData.Size);
  end;
  result := strm.DataString;
  strm.Free();
end;

function THTTPReqRespLogger.getSentDataAsString: string;
var
  strm: TStringStream;
begin
  strm := TStringStream.create('');
  fSentData.Position := 0;
  strm.CopyFrom(fSentData, fSentData.Size);
  result := strm.DataString;
  strm.Free();
end;

end.
