{:
  WebShopClient demo
  Az OTPWebShop fizetsi szolgltatsnak hasznlatt szemlltet alkalmazs.

  A szerver elrse a WebShopClient alkalmazson keresztl trtnik,
  WebService interfszen keresztl. Az OTP Middleware megfelel
  felletnek megszltsa teht kzvetett mdon trtnik.


  A WebShopClient elrse WebService interfszen keresztl,
  generlt wrapper osztlyok segtsgvel trtnik.

  Az alkalmazs fordtshoz a Borland Delphi 6-os vagy magasabb szm
  verzija szksges.

  @Author: Bodnr Imre (c) IQSys Rt.
}
unit ufmMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, InvokeRegistry, StdCtrls, Rio, SOAPHTTPClient,
  ExtCtrls, Menus, ComCtrls, IniFiles, Grids, ValEdit,
  uXmlTools, uRequestStarter, uMWAccess, uWebShopClient, Buttons, Mask;

type
  TfmMain = class(TForm)
    rioShopClient: THTTPRIO;
    pnlTop: TPanel;
    edtShopClientUrl: TLabeledEdit;
    btnWebShopClientPing: TButton;
    PopupMenu1: TPopupMenu;
    esztadatok1: TMenuItem;
    pgcWebshopTranzakciok: TPageControl;
    btnLoadWebInput: TButton;

    tabWf3: TTabSheet;
    pgcWf3: TPageControl;
    shtWsf3TranData: TTabSheet;
    shtWsf3WfXml: TTabSheet;
    shtWsf3MWAccess: TTabSheet;
    shtWsf3WebShopService: TTabSheet;
    pnlWsf3WfXmlTop: TPanel;
    pnlWsf3WfXmlBottom: TPanel;
    edtWsf3WfXmlInput: TRichEdit;
    splWsf3WfXml: TSplitter;
    edtWsf3WfXmlOutput: TRichEdit;
    pnlWsf3TranDataTop: TPanel;
    lstWf3TranDataInput: TValueListEditor;
    splWsf3TranData: TSplitter;
    pnlWsf3TranDataRight: TPanel;
    lstWf3TranDataOutput: TValueListEditor;
    rdbCallWebShopService: TRadioButton;
    rdbCallMWAccess: TRadioButton;
    pnlWsf3SoapTop: TPanel;
    splWsf3SoapXmlInput: TSplitter;
    edtWsf3SoapXmlInput: TRichEdit;
    edtWsf3SoapXmlOutput: TRichEdit;
    edtWsf3WebShopServiceInput: TRichEdit;
    edtWsf3WebShopServiceOutput: TRichEdit;

    pnlWsf3SoapBottom: TPanel;


    tabTrIdGen: TTabSheet;
    pgcTrIdGen: TPageControl;
    shtTrIdGenTranData: TTabSheet;
    shtTrIdGenWfXml: TTabSheet;
    shtTrIdGenMWAccess: TTabSheet;
    shtTrIdGenWebShopService: TTabSheet;
    pnlTrIdGenWfXmlTop: TPanel;
    pnlTrIdGenWfXmlBottom: TPanel;
    edtTrIdGenWfXmlInput: TRichEdit;
    splTrIdGenWfXml: TSplitter;
    edtTrIdGenWfXmlOutput: TRichEdit;
    pnlTrIdGenTranDataTop: TPanel;
    lstTrIdGenTranDataInput: TValueListEditor;
    splTrIdGenTranData: TSplitter;
    pnlTrIdGenTranDataRight: TPanel;
    lstTrIdGenTranDataOutput: TValueListEditor;
    pnlTrIdGenSoapTop: TPanel;
    splTrIdGenSoapXmlInput: TSplitter;
    edtTrIdGenSoapXmlInput: TRichEdit;
    edtTrIdGenSoapXmlOutput: TRichEdit;
    edtTrIdGenWebShopServiceInput: TRichEdit;
    edtTrIdGenWebShopServiceOutput: TRichEdit;
    pnlTrIdGenSoapBottom: TPanel;
    btnSend: TButton;
    edtMWAccessUrl: TLabeledEdit;
    btnMWAccessPing: TButton;
    rioMwAccess: THTTPRIO;
    cmbCertificaties: TComboBox;
    btnGenerateSignature: TButton;
    lstTrIdGenMessages: TListView;

    tabWsf2: TTabSheet;
    pgcWsf2: TPageControl;
    shtWsf2TranData: TTabSheet;
    shtWsf2WfXml: TTabSheet;
    shtWsf2MWAccess: TTabSheet;
    shtWsf2WebShopService: TTabSheet;
    pnlWsf2WfXmlTop: TPanel;
    pnlWsf2WfXmlBottom: TPanel;
    edtWsf2WfXmlInput: TRichEdit;
    splWsf2WfXml: TSplitter;
    edtWsf2WfXmlOutput: TRichEdit;
    pnlWsf2TranDataTop: TPanel;
    lstWsf2TranDataInput: TValueListEditor;
    splWsf2TranData: TSplitter;
    pnlWsf2TranDataRight: TPanel;
    lstWsf2TranDataOutput: TValueListEditor;
    pnlWsf2SoapTop: TPanel;
    splWsf2SoapXmlInput: TSplitter;
    edtWsf2SoapXmlInput: TRichEdit;
    edtWsf2SoapXmlOutput: TRichEdit;
    edtWsf2WebShopServiceInput: TRichEdit;
    edtWsf2WebShopServiceOutput: TRichEdit;
    pnlWsf2SoapBottom: TPanel;
    lstWsf2Messages: TListView;

    tabWsfLezaras: TTabSheet;
    pgcWsfLezaras: TPageControl;
    shtWsfLezarasTranData: TTabSheet;
    shtWsfLezarasWfXml: TTabSheet;
    shtWsfLezarasMWAccess: TTabSheet;
    shtWsfLezarasWebShopService: TTabSheet;
    pnlWsfLezarasWfXmlTop: TPanel;
    pnlWsfLezarasWfXmlBottom: TPanel;
    edtWsfLezarasWfXmlInput: TRichEdit;
    splWsfLezarasWfXml: TSplitter;
    edtWsfLezarasWfXmlOutput: TRichEdit;
    pnlWsfLezarasTranDataTop: TPanel;
    lstWsfLezarasTranDataInput: TValueListEditor;
    splWsfLezarasTranData: TSplitter;
    pnlWsfLezarasTranDataRight: TPanel;
    lstWsfLezarasTranDataOutput: TValueListEditor;
    pnlWsfLezarasSoapTop: TPanel;
    splWsfLezarasSoapXmlInput: TSplitter;
    edtWsfLezarasSoapXmlInput: TRichEdit;
    edtWsfLezarasSoapXmlOutput: TRichEdit;
    edtWsfLezarasWebShopServiceInput: TRichEdit;
    edtWsfLezarasWebShopServiceOutput: TRichEdit;
    pnlWsfLezarasSoapBottom: TPanel;
    lstWsfLezarasMessages: TListView;
    lstWsfLezarasTranDataButtons: TPanel;

    lstWsf3Messages: TListView;
    lstWf3TranDataButtons: TPanel;
    lstWsf2TranDataButtons: TPanel;
    lstTrIdGenTranDataButtons: TPanel;
    stbMain: TStatusBar;
    prgMain: TProgressBar;

    tabTrLek: TTabSheet;
    pgcTrLek: TPageControl;
    shtTrLekTranData: TTabSheet;
    shtTrLekWfXml: TTabSheet;
    shtTrLekMWAccess: TTabSheet;
    shtTrLekWebShopService: TTabSheet;
    pnlTrLekWfXmlTop: TPanel;
    pnlTrLekWfXmlBottom: TPanel;
    edtTrLekWfXmlInput: TRichEdit;
    splTrLekWfXml: TSplitter;
    edtTrLekWfXmlOutput: TRichEdit;
    pnlTrLekTranDataTop: TPanel;
    lstTrLekTranDataInput: TValueListEditor;
    splTrLekTranData: TSplitter;
    pnlTrLekTranDataRight: TPanel;
    lstTrLekTranDataOutput: TValueListEditor;
    pnlTrLekSoapTop: TPanel;
    splTrLekSoapXmlInput: TSplitter;
    edtTrLekSoapXmlInput: TRichEdit;
    edtTrLekSoapXmlOutput: TRichEdit;
    edtTrLekWebShopServiceInput: TRichEdit;
    edtTrLekWebShopServiceOutput: TRichEdit;
    pnlTrLekSoapBottom: TPanel;
    lstTrLekMessages: TListView;
    btnTranDataOutputNext: TSpeedButton;
    lblTranDataOutputIndex: TLabel;
    btnTranDataOutputPrev: TSpeedButton;
    pckIdoszakElejeNap: TDateTimePicker;
    pckIdoszakElejeOra: TDateTimePicker;
    pckIdoszakVegeNap: TDateTimePicker;
    pckIdoszakVegeOra: TDateTimePicker;
    pnlBottom: TPanel;
    edtCustomerWebPage: TLabeledEdit;
    Label1: TLabel;
    Bevel1: TBevel;
    lstInditottTranzakciok: TListView;
    chkAutoLoadWebInput: TCheckBox;
    lstInditottKetlepcsosTranzakciok: TListView;

    tabFizJovairas: TTabSheet;
    pgcFizJovairas: TPageControl;
    shtFizJovairasTranData: TTabSheet;
    pnlFizJovairasDataTop: TPanel;
    splFizJovairasTranData: TSplitter;
    lstFizJovairasTranDataInput: TValueListEditor;
    pnlFizJovairasTranDataRight: TPanel;
    lstFizJovairasTranDataOutput: TValueListEditor;
    lstFizJovairasMessages: TListView;
    lstFizJovairasTranDataButtons: TPanel;
    shtFizJovairasWfXml: TTabSheet;
    pnlFizJovairasWfXmlTop: TPanel;
    splFizJovairasWfXml: TSplitter;
    edtFizJovairasWfXmlInput: TRichEdit;
    edtFizJovairasWfXmlOutput: TRichEdit;
    pnlFizJovairasWfXmlBottom: TPanel;
    shtFizJovairasMWAccess: TTabSheet;
    pnlFizJovairasSoapTop: TPanel;
    splFizJovairasSoapXmlInput: TSplitter;
    edtFizJovairasSoapXmlInput: TRichEdit;
    edtFizJovairasSoapXmlOutput: TRichEdit;
    pnlFizJovairasSoapBottom: TPanel;
    shtFizJovairasWebShopService: TTabSheet;
    pnlFizJovairasWebShopServiceTop: TPanel;
    splFizJovairasWebShopService: TSplitter;
    edtFizJovairasWebShopServiceInput: TRichEdit;
    edtFizJovairasWebShopServiceOutput: TRichEdit;
    pnlFizJovairasWebShopServiceBottom: TPanel;
    lstJovairhatoTranz: TListView;

    procedure btnWebShopClientPingClick(Sender: TObject);
    procedure btnLoadWebInputClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure rdbCallModeClick(Sender: TObject);
    procedure lstWf3TranDataInputGetPickList(Sender: TObject;
      const KeyName: String; Values: TStrings);
    procedure pgcWf3Change(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure pgcWebshopTranzakciokChange(Sender: TObject);
    procedure btnGenerateSignatureClick(Sender: TObject);
    procedure pgcWebshopTranzakciokChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure lstTrLekTranDataInputEditButtonClick(Sender: TObject);
    procedure pckIdoszakExit(Sender: TObject);
    procedure pckIdoszakNapChange(Sender: TObject);
    procedure lstWf3TranDataInputStringsChange(Sender: TObject);
    procedure lstWf3TranDataInputEditButtonClick(Sender: TObject);
    procedure btnMWAccessPingClick(Sender: TObject);
    procedure lstInditottTranzakciokExit(Sender: TObject);
    procedure lstInditottKetlepcsosTranzakciokExit(Sender: TObject);
    procedure lstWsfLezarasTranDataInputEditButtonClick(Sender: TObject);
    procedure lstFizJovairasTranDataInputEditButtonClick(Sender: TObject);
    procedure lstJovairhatoTranzExit(Sender: TObject);

  private
    {: A kivlasztott tranzakcitpis oldala }
    selectedTranTab: TTabSheet;
    selectedPageControl: TPageControl;
    {: A kivlasztott tranzakci tpushoz tartoz
       indt adatok kulcs-rtk pr jelleg megjelentje }
    lstDataInput: TValueListEditor;
    {: A kivlasztott tranzakci tpushoz tartoz
       vlasz adatok kulcs-rtk pr jelleg megjelentje }
    lstDataOutput: TValueListEditor;
    {: A kivlasztott tranzakci tpushoz tartoz
       vlasz zenetek lists megjelentje }
    lstMessages: TListView;
    {: A kivlasztott tranzakci tpushoz tartoz indt adatok
       tranzakcis input xml-jt megjelent editor}
    edtWfXmlInput: TRichEdit;
    {: A kivlasztott tranzakci tpushoz tartoz vlasz adatok
       tranzakcis output xml-jt megjelent editor}
    edtWfXmlOutput: TRichEdit;
    {: A kivlasztott tranzakci tpushoz tartoz
       indt adatok tranzakcis input xml-jhez tartoz
       SOAP xml-t megjelent editor }
    edtSoapXmlInput: TRichEdit;
    {: A kivlasztott tranzakci tpushoz tartoz
       vlasz adatok tranzakcis input xml-jhez tartoz
       SOAP xml-t megjelent editor }
    edtSoapXmlOutput: TRichEdit;
    {: A kivlasztott tranzakci tpushoz tartoz
       indt adatok WebShopClient fellethez tartoz
       SOAP xml-t megjelent editor }
    edtWSServiceInput: TRichEdit;
    {: A kivlasztott tranzakci tpushoz tartoz
       vlasz adatok WebShopClient fellethez tartoz
       SOAP xml-t megjelent editor }
    edtWSServiceOutput: TRichEdit;

  private
    shopServerAddress: string;
    shopServerContext: string;
    bankServerAddress: string;
    bankServerContext: string;
    webCustomerUrl: string;

    inputXml: TInputXml;
    resultState: WorkflowState;
    resultObject: TRemotable;     // a WebShop SOAP client vlasza

    currentTranLekResultState: WorkflowState;
    currentTranLekResultObject: TRemotable;

    requestStarter: TRequestStarter;

    {: WebShop fizetsi adat lista adatainak struktrlt megjelentse
       a "Tranzakci sttuszok" fln. Hromszerepls fizetsi folyamat
       s tranzakci sttusz lekrdezs vlaszadatnak megjelentshez.}
{    procedure showTranzakcioStatusz(fizetesAdatok: WebShopFizetesAdatokLista); overload;
}
    {: Egy WebShop fizetsi adat adatainak struktrlt megjelentse
       a "Tranzakci sttuszok" fln. Hromszerepls fizetsi folyamat
       s tranzakci sttusz lekrdezs vlaszadatnak megjelentshez.}
{    procedure showTranzakcioStatusz(fizetesAdat: WebShopFizetesAdatok); overload;
}
    {: Egy WebShop ktszerepls fizetsi tramzakci vlaszadatainak
       struktrlt megjelentse a "Tranzakci sttuszok" fln. }
{    procedure showTranzakcioStatusz(fizetesAdat: WebShopFizetesValasz); overload;
}
    procedure outputXmlToListControl(outputXml: TOutputXml;
                                     transactionType: byte;
                                     index: integer = 0); overload;
    procedure outputXmlToListControl(outputObject: TRemotable;
                                     transactionType: byte;
                                     index: integer = 0); overload;

    published

      procedure StartTransaction(Sender: TObject);
      procedure ShowTransactionAnswer(Sender: TObject);
  end;

var
  fmMain: TfmMain;

const
  DATE_FORMAT_WF_INPUT:  string = 'yyyy.mm.dd hh:mm:ss';
  DATE_FORMAT_WF_OUTPUT_1:  string = 'yyyy.mm.dd hh:mm:ss';
  DATE_FORMAT_WF_OUTPUT_2:  string = 'yyyymmddhhmmss';
  DATE_FORMAT_LOG:  string = 'yyyy.mm.dd hh:mm:ss';

const
  WORKFLOW_NAME: array [0..5] of String = (
    'WEBSHOPFIZETES', 'WEBSHOPFIZETESKETSZEREPLOS',
    'WEBSHOPTRANZAZONGENERALAS', 'WEBSHOPTRANZAKCIOLEKERDEZES',
    'WEBSHOPFIZETESLEZARAS', 'WEBSHOPFIZETESJOVAIRAS');

  INPUTXML_NODESTOSIGN: array [0..5] of String = (
    'isPOSID'+ #$0D#$0A +
        'isTransactionID'+ #$0D#$0A +
        'isAmount'+ #$0D#$0A +
        'isExchange'+ #$0D#$0A +
        'isConsumerRegistrationID',
    'isPOSID'+ #$0D#$0A +
        'isTransactionID'+ #$0D#$0A +
        'isAmount'+ #$0D#$0A +
        'isExchange'+ #$0D#$0A +
        'isCardNumber'+ #$0D#$0A +
        'isCVCCVV'+ #$0D#$0A +
        'isExpirationDate'+ #$0D#$0A +
        'isConsumerRegistrationID'+ #$0D#$0A,
    'isPOSID',
    'isPOSID'+ #$0D#$0A +
        'isTransactionID'+ #$0D#$0A +
        'isMaxRecords'+ #$0D#$0A +
        'isStartDate'+ #$0D#$0A +
        'isEndDate',
    'isPOSID'+ #$0D#$0A +
        'isTransactionID',
    'isPOSID'+ #$0D#$0A +
        'isTransactionID' + #$0D#$0A +
        'isAmount'
  );

  INPUTXML_NODE_SIGNATURE: string = 'isClientSignature';

implementation

uses
  Registry,
  uHTTPReqRespLogger,
  uTransformator,
  uDigitalSignature,
  uRequestIndicator,
  uConfig,
  XMLDoc, XMLIntf,
  Clipbrd, Types;

{$R *.dfm}

{: Szveg kdolsa az URL kdols kpzsi szablyai szerint. }
function HTTPEncode(const AStr: string): string;
const
  NoConversion = ['A'..'Z', 'a'..'z', '*', '@', '.', '_', '-', '0'..'9'];
var
  Sp: Char;
  i: integer;
begin
  result := '';
  for i:=1 to length(aStr) do begin
    Sp := aStr[i];
    if sp in NoConversion then Result := Result + sp
    else if Sp = ' ' then Result := Result + '+'
    else begin
      result := result + '%' + inttohex(ord(sp), 2);
    end;
  end;
end;


procedure showExplorer(url: string);
var
  Reg: TRegistry;
  KeyName: string;
  ValueStr: string;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CLASSES_ROOT;
    KeyName     := 'htmlfile\shell\open\command';
    if Reg.OpenKey(KeyName, False) then
    begin
      ValueStr := Reg.ReadString('');
      Reg.CloseKey;
    end
    else
      ShowMessage('There isn''t a default browser');
  finally
    Reg.Free;
  end;

  WinExec(PAnsiChar(ValueStr + ' '  + url), 1);
end;

procedure TfmMain.btnWebShopClientPingClick(Sender: TObject);
begin
  try
    Screen.Cursor := crHourGlass;
    stbMain.Panels[0].Text := 'Kliens oldali WebShop szerver - ping folyamatban';
    stbMain.Repaint();

    rioShopClient.URL := edtShopClientUrl.Text;

    (rioShopClient as WebShopService).ping();
    stbMain.Panels[0].Text := 'Kliens oldali WebShop szerver - ping sikeres';

    btnLoadWebInput.Enabled := true;
    Screen.Cursor := crDefault;
  except
    on e: Exception do begin
      Screen.Cursor := crDefault;
      stbMain.Panels[0].Text := 'Ping sikertelen.';

      btnLoadWebInput.Enabled := false;
      Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
    end;
  end;
end;

procedure TfmMain.btnLoadWebInputClick(Sender: TObject);
begin
    showExplorer(edtCustomerWebPage.Text);
end;

procedure TfmMain.FormCreate(Sender: TObject);
var
  iniFileName: string;
  configFile: TIniFile;
begin
  iniFileName := ChangeFileExt(Application.exeName, '.ini');

  if not FileExists(iniFileName) then begin
    Application.MessageBox('Nem tallhat az inicializcus llomny!', 'Hiba!', MB_OK);
    exit;
  end;

  configFile := TIniFile.Create(iniFileName);
  shopServerAddress := configFile.ReadString('WebShopServer', 'ServerAddress', '');
  shopServerContext := configFile.ReadString('WebShopServer', 'ServerContext', '');
  bankServerAddress := configFile.ReadString('OTPServer', 'ServerAddress', '');
  bankServerContext := configFile.ReadString('OTPServer', 'ServerContext', '');
  webCustomerUrl := configFile.ReadString('OTPServer', 'WebCustomerUrl', '');
  configFile.Free();

  rdbCallWebShopService.Enabled := not isDemoMode();

end;

procedure TfmMain.FormShow(Sender: TObject);
begin
  edtShopClientUrl.Text := shopServerAddress + shopServerContext;
  edtMWAccessUrl.Text := bankServerAddress + bankServerContext;
  edtCustomerWebPage.Text := webCustomerUrl;

  cmbCertificaties.Items.Clear();
  cmbCertificaties.Items.AddStrings(GetCertificates());
  if (cmbCertificaties.Items.Count > 0) then begin
     btnGenerateSignature.Enabled := true;
     cmbCertificaties.ItemIndex := 0;
  end else begin
     btnGenerateSignature.Enabled := false;
  end;

  pgcWebshopTranzakciokChange(pgcWebshopTranzakciok);

  lstTrLekTranDataInput.ItemProps[2].EditStyle := esEllipsis;
  lstTrLekTranDataInput.ItemProps[3].EditStyle := esEllipsis;
  pckIdoszakElejeNap.Date := now();
  pckIdoszakVegeNap.Date := now;

  lstWf3TranDataInput.ItemProps[1].EditStyle := esEllipsis;
  lstWsf2TranDataInput.ItemProps[1].EditStyle := esEllipsis;

  lstWsfLezarasTranDataInput.ItemProps[1].EditStyle := esEllipsis;

  lstFizJovairasTranDataInput.ItemProps[0].EditStyle := esEllipsis;

  rdbCallModeClick(Sender);
  pgcWebshopTranzakciokChange(Sender);
end;


procedure TfmMain.rdbCallModeClick(Sender: TObject);
begin
  shtWsf3MWAccess.TabVisible := rdbCallMWAccess.Checked;
  shtWsf3WfXml.TabVisible := rdbCallMWAccess.Checked;
  shtWsf3WebShopService.TabVisible := not rdbCallMWAccess.Checked;

  shtWsf2MWAccess.TabVisible := rdbCallMWAccess.Checked;
  shtWsf2WfXml.TabVisible := rdbCallMWAccess.Checked;
  shtWsf2WebShopService.TabVisible := not rdbCallMWAccess.Checked;

  shtWsfLezarasMWAccess.TabVisible := rdbCallMWAccess.Checked;
  shtWsfLezarasWfXml.TabVisible := rdbCallMWAccess.Checked;
  shtWsfLezarasWebShopService.TabVisible := not rdbCallMWAccess.Checked;

  shtTrIdGenMWAccess.TabVisible := rdbCallMWAccess.Checked;
  shtTrIdGenWfXml.TabVisible := rdbCallMWAccess.Checked;
  shtTrIdGenWebShopService.TabVisible := not rdbCallMWAccess.Checked;

  shtTrLekMWAccess.TabVisible := rdbCallMWAccess.Checked;
  shtTrLekWfXml.TabVisible := rdbCallMWAccess.Checked;
  shtTrLekWebShopService.TabVisible := not rdbCallMWAccess.Checked;

  cmbCertificaties.Enabled := rdbCallMWAccess.Checked;
  btnGenerateSignature.Enabled :=
    rdbCallMWAccess.Checked and (cmbCertificaties.Items.Count > 0);

  edtShopClientUrl.Visible := rdbCallWebShopService.Checked;
  btnWebShopClientPing.Visible := rdbCallWebShopService.Checked;
  edtMWAccessUrl.Visible := rdbCallMWAccess.Checked;
  btnMWAccessPing.Visible := rdbCallMWAccess.Checked;
end;

{: Legrdl men tartalmnak ellltsa a bemen adatok elemenknti
   megadsra szolgla listban (TValueListEditor tpus) }
procedure TfmMain.lstWf3TranDataInputGetPickList(Sender: TObject;
  const KeyName: String; Values: TStrings);
begin
  if (pos('Kell', KeyName) > 0) then begin
    values.Add('true');
    values.Add('false');
  end;
  if (KeyName = 'nyelvkod') then begin
    values.Add('hu');
    values.Add('en');
    values.Add('de');
    values.Add('hr');
  end;
  if (KeyName = 'ketlepcsos') then begin
    values.Add('');
    values.Add('true');
    values.Add('false');
  end;
  if (KeyName = 'jovahagyo') then begin
    values.Add('true');
    values.Add('false');
  end;
end;

{: Tranzakcis input xml ellltsa az elemenknti bemen adatokbl.
   Az input a pldnyszint inputXml vltozban ll el, tovbb
   megjelenik a megfelel tranzakcis input xml-t tartalmaz TRichEdit
   komponensben is. }
procedure TfmMain.pgcWf3Change(Sender: TObject);
begin
  btnGenerateSignature.Enabled :=
    (selectedPageControl.ActivePageIndex = 0) and (rdbCallMWAccess.Checked);

  inputXml :=
      TInputXml.create(
        WORKFLOW_NAME[selectedTranTab.tag],
        lstDataInput.Strings,
        self,
        WFXML_TRANSLATOR[selectedTranTab.tag]);
  inputXml.addTextVariable('isClientCode', 'WEBSHOP');

  if (Sender <> btnGenerateSignature) then
    btnGenerateSignatureClick(Sender);
end;

procedure TfmMain.btnSendClick(Sender: TObject);
var s: WebShopTranzAzon;
    xml: string;
    i: integer;
begin
  Screen.Cursor := crHourGlass;
  try
    if (pgcWebshopTranzakciok.ActivePage = tabWf3) then begin
      Clipboard().SetTextBuf(PAnsiChar(edtCustomerWebPage.Text));
      if (chkAutoLoadWebInput.Checked) then
        btnLoadWebInput.Click();
    end;

    if (rdbCallMWAccess.Checked) then begin
      // input xml elllts
      pgcWf3Change(selectedTranTab);

      // vlaszadatokat tartalmaz komponensek trlse
      edtWfXmlOutput.Clear();
      lstMessages.Clear();
      for i:=0 to lstDataOutput.Strings.Count-1 do
        lstDataOutput.Strings[i] :=
          lstDataOutput.Strings.Names[i]
          + lstDataOutput.Strings.NameValueSeparator
          + '';

      // kapcsolat inicializci
      rioMwAccess.URL := edtMWAccessUrl.Text;
      rioMwAccess.HTTPWebNode :=
        THTTPReqRespLogger.Create(rioMwAccess.HTTPWebNode.Owner);

    end else begin
      rioShopClient.URL := edtShopClientUrl.Text;
      rioShopClient.HTTPWebNode :=
        THTTPReqRespLogger.Create(rioShopClient.HTTPWebNode.Owner);

    end;

{    requestStarter := TRequestStarter.Create(
      self.StartTransaction,
      self.RequestStarterThreadDone,
      prgMain, false);
}
    StartTransaction(self);

    ShowTransactionAnswer(Sender);

    Screen.Cursor := crAppStart;

  except
    on e: Exception do begin
      stbMain.Panels[0].Text := 'Mvelet sikertelen.';
      Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
    end;
  end;
  Screen.Cursor := crDefault;

end;

procedure TfmMain.StartTransaction(Sender: TObject);
var s: WebShopTranzAzon;
    xml: string;
    item: TListItem;
    tmp: string;
    logFile: TextFile;
begin
  if selectedTranTab.Tag in [0, 1] then begin
    item := lstInditottTranzakciok.Items.Insert(0);
    item.Caption := '[' + FormatDateTime('hh:nn:ss', Now()) + ']';
    item.SubItems.Add(lstDataInput.Values['tranz.azon']);

    item := lstJovairhatoTranz.Items.Insert(0);
    item.Caption := '[' + FormatDateTime('hh:nn:ss', Now()) + ']';
    item.SubItems.Add(lstDataInput.Values['tranz.azon']);

    // az els tranzakci indts utn aktivljuk a kis gombot
    // a tranzakci lekrdez oldal trazon sorban
    lstTrLekTranDataInput.ItemProps[1].EditStyle := esEllipsis;

    if ((selectedTranTab.Tag = tabWf3.Tag)
          and StrToBoolDef(lstWf3TranDataInput.Values['ketlepcsos'], false))
        or ((selectedTranTab.Tag = 1)
          and StrToBoolDef(lstWsf2TranDataInput.Values['ketlepcsos'], false)) then begin
      item := lstInditottKetlepcsosTranzakciok.Items.Insert(0);
      item.Caption := '[' + FormatDateTime('hh:nn:ss', Now()) + ']';
      item.SubItems.Add(lstDataInput.Values['tranz.azon']);

      // az els tranzakci indts utn aktivljuk a kis gombot
      // a tranzakci lezrs oldal trazon sorban
      lstWsfLezarasTranDataInput.ItemProps[1].EditStyle := esEllipsis;
      lstFizJovairasTranDataInput.ItemProps[0].EditStyle := esEllipsis;
    end;
  end;

  if (rdbCallMWAccess.Checked) then begin
    try
      // tranzakci vgrehajts
      xml := inputXml.doc.XML.Text;

      if isDemoMode() then begin
        resultState :=
          getMWAccessResultFromFile(inputXml.workflowName);
      end else begin
        resultState :=
          (rioMwAccess as MWAccessService).startWorkflowSynch(inputXml.workflowName, xml);
      end;

      try
        AssignFile(logFile, 'OTPWebShopTool.log');
        if FileExists('OTPWebShopTool.log') then Append(logFile)
                                            else Rewrite(logFile);
        writeln(logFile,
          '[', FormatDateTime(DATE_FORMAT_LOG, now), '] ',
          inputXml.workflowName, ' inditva, banki trid: ', resultState.instanceId);

        writeln(logFile, 'Indt xml:');
        writeln(logFile, xml);

        writeln(logFile, 'Vlasz xml:');
        writeln(logFile, TOutputXml.create(resultState.result, self).doc.XML.text);

        CloseFile(logFile);
      except
        on Exception do;
      end;

      if (selectedTranTab = tabTrLek) then
        currentTranLekResultState := resultState;

    except
      on e: Exception do begin

        AssignFile(logFile, 'OTPWebShopTool.log');
        if FileExists('OTPWebShopTool.log') then Append(logFile)
                                            else Rewrite(logFile);
        writeln(logFile,
          '[', FormatDateTime(DATE_FORMAT_LOG, now), '] ',
          inputXml.workflowName, ' - hibas inditas (', e.message, ')');
        writeln(logFile, 'Indt xml:');
        writeln(logFile, xml);
        CloseFile(logFile);

        Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
      end;
    end;

  end else begin
    try
    case selectedTranTab.Tag of
      2: resultObject :=
          (rioShopClient as WebShopService).tranzakcioAzonositoGeneralas(
            lstTrIdGenTranDataInput.Values['posId']);
      0: if (lstWf3TranDataInput.Values['ketlepcsos'] <> '') then
            resultObject :=
                (rioShopClient as WebShopService).fizetesiTranzakcio(
                  lstWf3TranDataInput.Values['posId'],
                  lstWf3TranDataInput.Values['tranz.azon'],
                  lstWf3TranDataInput.Values['osszeg'],
                  lstWf3TranDataInput.Values['devizanem'],
                  lstWf3TranDataInput.Values['nyelvkod'],
                  StrToBoolDef(lstWf3TranDataInput.Values['nevKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['orszagKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['megyeKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['telepulesKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['iranyitoszamKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['utcaHazszamKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['mailCimKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['kozlemenyKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['vevoVisszaigazolasKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['ugyfelRegisztracioKell'], false),
                  lstWf3TranDataInput.Values['regisztraltUgyfelId'],
                  lstWf3TranDataInput.Values['shopMegjegyzes'],
                  lstWf3TranDataInput.Values['backURL'],
                  StrToBoolDef(lstWf3TranDataInput.Values['ketlepcsos'], false),
                  lstWf3TranDataInput.Values['kereskedoiKozlemeny'])
          else
            resultObject :=
                (rioShopClient as WebShopService).fizetesiTranzakcio(
                  lstWf3TranDataInput.Values['posId'],
                  lstWf3TranDataInput.Values['tranz.azon'],
                  lstWf3TranDataInput.Values['osszeg'],
                  lstWf3TranDataInput.Values['devizanem'],
                  lstWf3TranDataInput.Values['nyelvkod'],
                  StrToBoolDef(lstWf3TranDataInput.Values['nevKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['orszagKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['megyeKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['telepulesKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['iranyitoszamKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['utcaHazszamKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['mailCimKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['kozlemenyKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['vevoVisszaigazolasKell'], false),
                  StrToBoolDef(lstWf3TranDataInput.Values['ugyfelRegisztracioKell'], false),
                  lstWf3TranDataInput.Values['regisztraltUgyfelId'],
                  lstWf3TranDataInput.Values['shopMegjegyzes'],
                  lstWf3TranDataInput.Values['backURL']
                );
      1:  if (lstWsf2TranDataInput.Values['ketlepcsos'] <> '') then
            resultObject :=
              (rioShopClient as WebShopService).fizetesiTranzakcioKetszereplos(
                lstWsf2TranDataInput.Values['posId'],
                lstWsf2TranDataInput.Values['tranz.azon'],
                lstWsf2TranDataInput.Values['osszeg'],
                lstWsf2TranDataInput.Values['devizanem'],
                lstWsf2TranDataInput.Values['nyelvkod'],
                lstWsf2TranDataInput.Values['regisztraltUgyfelId'],
                lstWsf2TranDataInput.Values['kartyaszam'],
                lstWsf2TranDataInput.Values['cvc2cvv2'],
                lstWsf2TranDataInput.Values['kartyaLejarat'],
                lstWsf2TranDataInput.Values['vevoNev'],
                lstWsf2TranDataInput.Values['vevoPostaCim'],
                lstWsf2TranDataInput.Values['vevoIPCim'],
                lstWsf2TranDataInput.Values['ertesitoMail'],
                lstWsf2TranDataInput.Values['ertesitoTel'],
                StrToBoolDef(lstWsf2TranDataInput.Values['ketlepcsos'], false),
                lstWsf2TranDataInput.Values['kereskedoiKozlemeny']
              )
            else
            resultObject :=
              (rioShopClient as WebShopService).fizetesiTranzakcioKetszereplos(
                lstWsf2TranDataInput.Values['posId'],
                lstWsf2TranDataInput.Values['tranz.azon'],
                lstWsf2TranDataInput.Values['osszeg'],
                lstWsf2TranDataInput.Values['devizanem'],
                lstWsf2TranDataInput.Values['nyelvkod'],
                lstWsf2TranDataInput.Values['regisztraltUgyfelId'],
                lstWsf2TranDataInput.Values['kartyaszam'],
                lstWsf2TranDataInput.Values['cvc2cvv2'],
                lstWsf2TranDataInput.Values['kartyaLejarat'],
                lstWsf2TranDataInput.Values['vevoNev'],
                lstWsf2TranDataInput.Values['vevoPostaCim'],
                lstWsf2TranDataInput.Values['vevoIPCim'],
                lstWsf2TranDataInput.Values['ertesitoMail'],
                lstWsf2TranDataInput.Values['ertesitoTel']
              );
      3:begin
          resultObject :=
            (rioShopClient as WebShopService).tranzakcioStatuszLekerdezes(
              lstTrLekTranDataInput.Values['posId'],
              lstTrLekTranDataInput.Values['tranz.azon'],
              lstTrLekTranDataInput.Values['maxRekordszam'],
              lstTrLekTranDataInput.Values['idoszakEleje'],
              lstTrLekTranDataInput.Values['idoszakVege']);
          currentTranLekResultObject := resultObject;
        end;
      4: resultObject :=
            (rioShopClient as WebShopService).fizetesiTranzakcioLezaras(
              lstWsfLezarasTranDataInput.Values['posId'],
              lstWsfLezarasTranDataInput.Values['tranz.azon'],
              StrToBoolDef(lstWsfLezarasTranDataInput.Values['jovahagyo'], false),
              lstWsfLezarasTranDataInput.Values['osszeg']
            );
      5: resultObject :=
            (rioShopClient as WebShopService).fizetesJovairas(
              lstFizJovairasTranDataInput.Values['posId'],
              lstFizJovairasTranDataInput.Values['azonosito'],
              lstFizJovairasTranDataInput.Values['osszeg']
            );

      end;
    except
      on e: Exception do begin
        Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
      end;
    end;
  end;

end;


procedure TfmMain.pgcWebshopTranzakciokChange(Sender: TObject);
begin
  selectedTranTab := pgcWebshopTranzakciok.ActivePage;
  if (selectedTranTab = tabWf3) then begin
    lstDataInput := lstWf3TranDataInput;
    lstDataOutput := lstWf3TranDataOutput;
    lstMessages := lstWsf3Messages;
    edtWfXmlInput := edtWsf3WfXmlInput;
    edtWfXmlOutput := edtWsf3WfXmlOutput;
    edtSoapXmlInput := edtWsf3SoapXmlInput;
    edtSoapXmlOutput := edtWsf3SoapXmlOutput;
    edtWSServiceInput := edtWsf3WebShopServiceInput;
    edtWSServiceOutput := edtWsf3WebShopServiceOutput;
    selectedPageControl := pgcWf3;
  end else if (selectedTranTab = tabWsf2) then begin
    lstDataInput := lstWsf2TranDataInput;
    lstDataOutput := lstWsf2TranDataOutput;
    lstMessages := lstWsf2Messages;
    edtWfXmlInput := edtWsf2WfXmlInput;
    edtWfXmlOutput := edtWsf2WfXmlOutput;
    edtSoapXmlInput := edtWsf2SoapXmlInput;
    edtSoapXmlOutput := edtWsf2SoapXmlOutput;
    edtWSServiceInput := edtWsf2WebShopServiceInput;
    edtWSServiceOutput := edtWsf2WebShopServiceOutput;
    selectedPageControl := pgcWsf2;
  end else if (selectedTranTab = tabWsfLezaras) then begin
    lstDataInput := lstWsfLezarasTranDataInput;
    lstDataOutput := lstWsfLezarasTranDataOutput;
    lstMessages := lstWsfLezarasMessages;
    edtWfXmlInput := edtWsfLezarasWfXmlInput;
    edtWfXmlOutput := edtWsfLezarasWfXmlOutput;
    edtSoapXmlInput := edtWsfLezarasSoapXmlInput;
    edtSoapXmlOutput := edtWsfLezarasSoapXmlOutput;
    edtWSServiceInput := edtWsfLezarasWebShopServiceInput;
    edtWSServiceOutput := edtWsfLezarasWebShopServiceOutput;
    selectedPageControl := pgcWsfLezaras;
  end else if (selectedTranTab = tabTrIdGen) then begin
    lstDataInput := lstTrIdGenTranDataInput;
    lstDataOutput := lstTrIdGenTranDataOutput;
    lstMessages := lstTrIdGenMessages;
    edtWfXmlInput := edtTrIdGenWfXmlInput;
    edtWfXmlOutput := edtTrIdGenWfXmlOutput;
    edtSoapXmlInput := edtTrIdGenSoapXmlInput;
    edtSoapXmlOutput := edtTrIdGenSoapXmlOutput;
    edtWSServiceInput := edtTrIdGenWebShopServiceInput;
    edtWSServiceOutput := edtTrIdGenWebShopServiceOutput;
    selectedPageControl := pgcTrIdGen;
  end else if (selectedTranTab = tabTrLek) then begin
    lstDataInput := lstTrLekTranDataInput;
    lstDataOutput := lstTrLekTranDataOutput;
    lstMessages := lstTrLekMessages;
    edtWfXmlInput := edtTrLekWfXmlInput;
    edtWfXmlOutput := edtTrLekWfXmlOutput;
    edtSoapXmlInput := edtTrLekSoapXmlInput;
    edtSoapXmlOutput := edtTrLekSoapXmlOutput;
    edtWSServiceInput := edtTrLekWebShopServiceInput;
    edtWSServiceOutput := edtTrLekWebShopServiceOutput;
    selectedPageControl := pgcTrLek;
  end else if (selectedTranTab = tabFizJovairas) then begin
    lstDataInput := lstFizJovairasTranDataInput;
    lstDataOutput := lstFizJovairasTranDataOutput;
    lstMessages := lstFizJovairasMessages;
    edtWfXmlInput := edtFizJovairasWfXmlInput;
    edtWfXmlOutput := edtFizJovairasWfXmlOutput;
    edtSoapXmlInput := edtFizJovairasSoapXmlInput;
    edtSoapXmlOutput := edtFizJovairasSoapXmlOutput;
    edtWSServiceInput := edtFizJovairasWebShopServiceInput;
    edtWSServiceOutput := edtFizJovairasWebShopServiceOutput;
    selectedPageControl := pgcFizJovairas;
  end;
  edtCustomerWebPage.Visible := (selectedTranTab = tabWf3);
  chkAutoLoadWebInput.Visible := edtCustomerWebPage.Visible;
  btnLoadWebInput.Visible := (selectedTranTab = tabWf3);
  btnGenerateSignature.Enabled :=
    (selectedPageControl.ActivePageIndex = 0) and (rdbCallMWAccess.Checked);
end;


procedure TfmMain.btnGenerateSignatureClick(Sender: TObject);
var
  inputXmlNodesToSignList: TStrings;
  messageXmlRoot: IXmlNode;
  node: IXmlNode;
  buf: string;
  i: integer;
begin
  if (cmbCertificaties.Items.Count = 0) then exit;

  inputXmlNodesToSignList := TStringList.Create();
  inputXmlNodesToSignList.CommaText := ',';
  inputXmlNodesToSignList.Text := INPUTXML_NODESTOSIGN[selectedTranTab.tag];

  if (Sender = btnGenerateSignature) then pgcWf3Change(Sender);

  messageXmlRoot := inputXml.variablesTag;
  for i:=0 to inputXmlNodesToSignList.Count-1 do begin
    node := messageXmlRoot.ChildNodes[inputXmlNodesToSignList[i]];
    if Assigned(node) and (node.NodeValue <> null)then
      buf := buf + node.NodeValue;
    if i < inputXmlNodesToSignList.Count - 1 then buf := buf + '|';
  end;

  node := messageXmlRoot.ChildNodes[INPUTXML_NODE_SIGNATURE];
  if Assigned(node) then messageXmlRoot.ChildNodes.Remove(node);

  inputXml.variablesTag.AddChild(INPUTXML_NODE_SIGNATURE).Text :=
    generateSignature(cmbCertificaties.Text, buf);

  inputXml.doc.Options := inputXml.doc.Options + [doNodeAutoIndent];
  inputXml.doc.NodeIndentStr := '<2 spaces>';

  edtWfXmlInput.Lines.Clear();
  edtWfXmlInput.Lines.AddStrings(inputXml.doc.XML);

  if (Sender = btnGenerateSignature) then begin
    selectedPageControl.ActivePageIndex := 1;
    btnGenerateSignature.Enabled := false;
  end;

end;

procedure TfmMain.outputXmlToListControl(outputXml: TOutputXml;
                                         transactionType: byte;
                                         index: integer);
var
  i:integer;
  selectedRecord: IXmlNode;
  varName: string;
  value: string;

  procedure nodeToListControl(node: IXMLNode);
  var
    j: integer;
  begin
      for j:=0 to node.ChildNodes.Count-1 do begin;
        varName := node.ChildNodes[j].NodeName;
        value := '';
        if OUTPUTXML_TRANSLATOR[transactionType].IndexOfName(varName) > -1 then begin
          varName := OUTPUTXML_TRANSLATOR[transactionType].Values[varName];
        end;
        if not (node.ChildNodes[j].IsTextElement)
            and (node.ChildNodes[j].ChildNodes.Count > 0) then begin
          nodeToListControl(node.ChildNodes[j]);
          continue;
        end;
        if (node.ChildNodes[j].NodeValue <> null) then
          value := node.ChildNodes[j].NodeValue;
        if (lstDataOutput.Strings.IndexOfName(varName) <> - 1) then
          lstDataOutput.Strings[lstDataOutput.Strings.IndexOfName(varName)] :=
             varName + lstDataOutput.Strings.NameValueSeparator + value
        else
          lstDataOutput.Strings.Add(varName
            + lstDataOutput.Strings.NameValueSeparator
            + value);
      end;
  end;

begin
//  lstDataOutput.Visible := outputXml.siker;

//  if not outputXml.siker then exit;

  for i:=0 to outputXml.recordList.Count-1 do begin
    selectedRecord := outputXml.recordList[i];
    if selectedRecord.NodeName = 'record' then begin
      if (index <> 0) then begin
        dec(index);
        continue;
      end;

      nodeToListControl(selectedRecord);
      break;

    end;
  end;

end;

procedure TfmMain.outputXmlToListControl(outputObject: TRemotable;
  transactionType: byte; index: integer);
var
  messageList: string;
  fizValasz: WebShopFizetesValasz;
  fizAdatok: WebShopFizetesAdatok;
  fs: TFormatSettings;
  dt: TDateTime;
  item: TListItem;
begin
  if (outputObject is WebShopTranzAzon) then begin
    messageList := (outputObject as WebShopTranzAzon).valaszKod;

    lstTrIdGenTranDataOutput.Values['posId']:=
      (outputObject as WebShopTranzAzon).posId;
    lstTrIdGenTranDataOutput.Values['tranz.azon']:=
      (outputObject as WebShopTranzAzon).azonosito;
    lstTrIdGenTranDataOutput.Values['teljesites']:=
      (outputObject as WebShopTranzAzon).teljesites;

    lstTrIdGenMessages.Items.Clear();
    lstTrIdGenMessages.Items.Add().Caption := messageList;

  end else if (outputObject is WebShopFizetesValasz) then begin
    // Ktszerepls  fizets vlasznak megjelentse
    fizValasz := outputObject as WebShopFizetesValasz;
    messageList := fizValasz.valaszKod;

    if (selectedTranTab = tabWsf2) then begin
        lstWsf2TranDataOutput.Values['posId']:= fizValasz.posId;
        lstWsf2TranDataOutput.Values['tranz.azon']:= fizValasz.azonosito;
        lstWsf2TranDataOutput.Values['teljesites']:= fizValasz.teljesites;
        lstWsf2TranDataOutput.Values['authorizaciosKod']:= fizValasz.authorizaciosKod;
        lstWsf2TranDataOutput.Values['valaszKod']:= fizValasz.valaszKod;
        lstWsf2Messages.Items.Clear();
          lstWsf2Messages.Items.Add().Caption := messageList;
    end else begin
        lstWsfLezarasTranDataOutput.Values['posId']:= fizValasz.posId;
        lstWsfLezarasTranDataOutput.Values['tranz.azon']:= fizValasz.azonosito;
        lstWsfLezarasTranDataOutput.Values['teljesites']:= fizValasz.teljesites;
        lstWsfLezarasTranDataOutput.Values['authorizaciosKod']:= fizValasz.authorizaciosKod;
        lstWsfLezarasTranDataOutput.Values['valaszKod']:= fizValasz.valaszKod;
        lstWsfLezarasMessages.Items.Clear();
          lstWsfLezarasMessages.Items.Add().Caption := messageList;
    end;

  end else if (outputObject is WebShopFizetesAdatokLista) then begin
    // tranzakcilekrdezs vlasznak megjelentse
    lstDataOutput.Values['posId'] := (outputObject as WebShopFizetesAdatokLista).posId;

    lstMessages.Items.Clear();
    lstMessages.Items.Add().Caption := (outputObject as WebShopFizetesAdatokLista).valaszKod;

    if ((outputObject as WebShopFizetesAdatokLista).webShopFizetesAdatok = nil)
      or (length((outputObject as WebShopFizetesAdatokLista).webShopFizetesAdatok) <= index) then
      exit;
      
    fizAdatok := (outputObject as WebShopFizetesAdatokLista).webShopFizetesAdatok[index];
    lstDataOutput.Values['nev'] := fizAdatok.nev;
    lstDataOutput.Values['iranyitoszam'] := fizAdatok.iranyitoszam;
    lstDataOutput.Values['orszag'] := fizAdatok.orszag;
    lstDataOutput.Values['megye'] := fizAdatok.megye;
    lstDataOutput.Values['telepules'] := fizAdatok.varos;
    lstDataOutput.Values['utcaHazszam'] := fizAdatok.utcaHazszam;
    lstDataOutput.Values['kozlemeny'] := fizAdatok.kozlemeny;
    lstDataOutput.Values['mailCim'] := fizAdatok.mailCim;
    lstDataOutput.Values['tranz.azon'] := fizAdatok.azonosito;

      lstDataOutput.Values['teljesites'] := fizAdatok.teljesites;
      lstDataOutput.Values['authorizaciosKod'] := fizAdatok.autorizaciosKod;

    if (selectedTranTab = tabTrLek) then begin
      lstDataOutput.Values['nevKell'] := BoolToStr(fizAdatok.nevKell, true);
      lstDataOutput.Values['iranyitoszamKell'] := BoolToStr(fizAdatok.iranyitoszamKell, true);
      lstDataOutput.Values['orszagKell'] := BoolToStr(fizAdatok.orszagKell, true);
      lstDataOutput.Values['megyeKell'] := BoolToStr(fizAdatok.megyeKell, true);
      lstDataOutput.Values['telepulesKell'] := BoolToStr(fizAdatok.telepulesKell, true);
      lstDataOutput.Values['utcaHazszamKell'] := BoolToStr(fizAdatok.utcaHazszamKell, true);
      lstDataOutput.Values['kozlemenyKell'] := BoolToStr(fizAdatok.kozlemenyKell, true);
      lstDataOutput.Values['mailCimKell'] := BoolToStr(fizAdatok.mailCimKell, true);
      lstDataOutput.Values['vevoVisszaigazolasKell'] := BoolToStr(fizAdatok.vevoVisszaigazolasKell, true);
      lstDataOutput.Values['ugyfelRegisztracioKell'] := BoolToStr(fizAdatok.ugyfelRegisztracioKell, true);
      lstDataOutput.Values['regisztraltUgyfelId'] := fizAdatok.regisztraltUgyfelId;

      lstDataOutput.Values['statuszKod'] := fizAdatok.statuszKod;
      lstDataOutput.Values['posValaszkod'] := fizAdatok.posValaszkod;
      lstDataOutput.Values['authorizaciosKod'] := fizAdatok.autorizaciosKod;
      lstDataOutput.Values['devizanem'] := fizAdatok.devizanem;
      lstDataOutput.Values['osszeg'] := fizAdatok.osszeg;
      lstDataOutput.Values['nyelvkod'] := fizAdatok.nyelvkod;

      lstDataOutput.Values['shopMegjegyzes'] := fizAdatok.shopMegjegyzes;
      lstDataOutput.Values['backURL'] := fizAdatok.backURL;

    end;

  end else if (outputObject is WebShopFizetesJovairasValasz) then begin



  end;


end;

procedure TfmMain.ShowTransactionAnswer(Sender: TObject);
var s: WebShopTranzAzon;
    xml: string;
    outputXml: TOutputXml;        // az MWAccess vlasza
    recordIndex: integer;
    i: integer;
begin
  try
    if (Sender = btnTranDataOutputPrev)
        or (Sender = btnTranDataOutputNext) then begin
      resultState := currentTranLekResultState;
      resultObject := currentTranLekResultObject;
      recordIndex := TComponent(Sender).Tag;
    end else
      recordIndex := 0;

    if (selectedTranTab = tabTrLek) then begin
      btnTranDataOutputPrev.Tag := recordIndex - 1;
      btnTranDataOutputNext.Tag := recordIndex + 1;

      btnTranDataOutputPrev.Enabled := btnTranDataOutputPrev.Tag >= 0;
    end;
    
    if ((rdbCallMWAccess.Checked) and (resultState <> nil)) then begin
      try
        // vlasz rtelmezs, megjelents
        outputXml := TOutputXml.create(resultState.result, self);

        edtWfXmlOutput.Lines.Clear();
        edtWfXmlOutput.Lines.AddStrings(outputXml.doc.XML);
        lstMessages.Clear();
        for i:=0 to outputXml.messageList.Count-1 do
          lstMessages.Items.Add().Caption := outputXml.messageList[i];

        outputXmlToListControl(outputXml, selectedTranTab.Tag, recordIndex);

        if (selectedTranTab = tabTrLek) then begin
          btnTranDataOutputPrev.Enabled :=
            (inputXml.workflowName = WORKFLOW_NAME[3]) and (recordIndex > 0);
          btnTranDataOutputNext.Enabled :=
            (inputXml.workflowName = WORKFLOW_NAME[3]) and
            (recordIndex + 1 < outputXml.recordList.Count);

          lblTranDataOutputIndex.Caption :=
            inttostr(recordIndex+1) + ' / ' + inttostr(outputXml.recordList.Count);

          btnTranDataOutputNext.Enabled :=
            outputXml.recordList.Count > btnTranDataOutputNext.Tag;
        end;
      except
        on e: Exception do begin
          Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
        end;
      end;

      if not (isDemoMode) then begin
        edtSoapXmlInput.Text :=
          THTTPReqRespLogger(rioMWAccess.HTTPWebNode).sentString;

        edtSoapXmlOutput.Text :=
          THTTPReqRespLogger(rioMWAccess.HTTPWebNode).receivedString;
      end;

    end else if (rdbCallWebShopService.Checked and (resultObject <> nil)) then begin
      try
        outputXmlToListControl(resultObject, selectedTranTab.Tag, recordIndex);
      except
        on e: Exception do begin
          Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
        end;
      end;

      edtWSServiceInput.Text :=
        THTTPReqRespLogger(rioShopClient.HTTPWebNode).sentString;

      edtWSServiceOutput.Text :=
        THTTPReqRespLogger(rioShopClient.HTTPWebNode).receivedString;

      if (selectedTranTab = tabTrLek) then begin

        btnTranDataOutputPrev.Enabled :=
          (resultObject is WebShopFizetesAdatokLista) and (recordIndex > 0);
        btnTranDataOutputNext.Enabled :=
          (resultObject is WebShopFizetesValasz) and
          (recordIndex + 1 < length(WebShopFizetesAdatokLista(resultObject).webShopFizetesAdatok));

        if (length(WebShopFizetesAdatokLista(resultObject).webShopFizetesAdatok) = 0) then
          recordIndex := -1;

        lblTranDataOutputIndex.Caption :=
          inttostr(recordIndex+1) + ' / ' + inttostr(length(WebShopFizetesAdatokLista(resultObject).webShopFizetesAdatok));

        btnTranDataOutputNext.Enabled :=
          length(WebShopFizetesAdatokLista(resultObject).webShopFizetesAdatok) >
            btnTranDataOutputNext.Tag;
      end;
    end;
  except
    on e: Exception do begin
      stbMain.Panels[0].Text := 'Mvelet sikertelen.';
      Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
    end;
  end;
  Screen.Cursor := crDefault;
end;

procedure TfmMain.pgcWebshopTranzakciokChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  AllowChange := (requestStarter = nil);
end;

procedure TfmMain.lstTrLekTranDataInputEditButtonClick(Sender: TObject);
var
   rect: TRect;
   idoszakNap, idoszakOra: TDateTimePicker;
begin
   rect := lstTrLekTranDataInput.CellRect(
    lstTrLekTranDataInput.Selection.Left, lstTrLekTranDataInput.Selection.Top);

   if (lstTrLekTranDataInput.Selection.Top = 3) then begin
    idoszakNap := pckIdoszakElejeNap;
    idoszakOra := pckIdoszakElejeOra;
   end else if (lstTrLekTranDataInput.Selection.Top = 4) then begin
    idoszakNap := pckIdoszakVegeNap;
    idoszakOra := pckIdoszakVegeOra;
   end else if (lstTrLekTranDataInput.Selection.Top = 2)
      and (lstInditottTranzakciok.Items.Count > 0) then begin
    lstInditottTranzakciok.Top := rect.Bottom + 2;
    lstInditottTranzakciok.Visible := true;
    lstInditottTranzakciok.SetFocus();
    exit;
   end else
    exit;

   idoszakNap.Top := rect.Top;
   idoszakOra.Top := rect.Top;
   idoszakNap.Visible := true;
   idoszakOra.Visible := true;

   idoszakNap.SetFocus();
end;

procedure TfmMain.pckIdoszakExit(Sender: TObject);
var
   rect: TRect;
   idoszakNap, idoszakOra: TDateTimePicker;
   tmp: TDateTime;
begin
   pckIdoszakNapChange(Sender);

   if (lstTrLekTranDataInput.Selection.Top = 3) then begin
    idoszakNap := pckIdoszakElejeNap;
    idoszakOra := pckIdoszakElejeOra;
   end else if (lstTrLekTranDataInput.Selection.Top = 4) then begin
    idoszakNap := pckIdoszakVegeNap;
    idoszakOra := pckIdoszakVegeOra;
   end else
    exit;

   idoszakNap.SetTextBuf(PAnsichar(lstTrLekTranDataInput.Cells[
      lstTrLekTranDataInput.Selection.Left,
      lstTrLekTranDataInput.Selection.Top]));

   if (not idoszakNap.Focused) and (not idoszakOra.Focused) then begin
    idoszakNap.Visible := false;
    idoszakOra.Visible := false;
   end;
end;

procedure TfmMain.pckIdoszakNapChange(Sender: TObject);
var
   idoszakNap, idoszakOra: TDateTimePicker;
begin
   if (lstTrLekTranDataInput.Selection.Top = 3) then begin
    idoszakNap := pckIdoszakElejeNap;
    idoszakOra := pckIdoszakElejeOra;
   end else if (lstTrLekTranDataInput.Selection.Top = 4) then begin
    idoszakNap := pckIdoszakVegeNap;
    idoszakOra := pckIdoszakVegeOra;
   end else
    exit;

  idoszakOra.Enabled := idoszakNap.Checked;
  if (not idoszakNap.Checked) then begin
    lstTrLekTranDataInput.Cells[
      lstTrLekTranDataInput.Selection.Left,
      lstTrLekTranDataInput.Selection.Top] := '';
  end else begin
    idoszakNap.Time := idoszakOra.Time;
    lstTrLekTranDataInput.Cells[
      lstTrLekTranDataInput.Selection.Left,
      lstTrLekTranDataInput.Selection.Top] :=
        FormatDateTime(DATE_FORMAT_WF_INPUT,
          idoszakNap.DateTime);
  end;
end;

procedure TfmMain.lstInditottTranzakciokExit(Sender: TObject);
begin
   lstInditottTranzakciok.Visible := false;

   if (lstInditottTranzakciok.ItemFocused <> nil) then
   lstTrLekTranDataInput.Cells[
      lstTrLekTranDataInput.Selection.Left,
      lstTrLekTranDataInput.Selection.Top] :=
        lstInditottTranzakciok.ItemFocused.SubItems[0];
end;

procedure TfmMain.lstInditottKetlepcsosTranzakciokExit(Sender: TObject);
begin
   lstInditottKetlepcsosTranzakciok.Visible := false;

   if (lstInditottKetlepcsosTranzakciok.ItemFocused <> nil) then
   begin
     lstWsfLezarasTranDataInput.Cells[
        lstWsfLezarasTranDataInput.Selection.Left,
        lstWsfLezarasTranDataInput.Selection.Top] :=
          lstInditottKetlepcsosTranzakciok.ItemFocused.SubItems[0];
     //Fizets jvrs:
//     lstFizJovairasTranDataInput.Cells[
//        lstFizJovairasTranDataInput.Selection.Left,
//        lstFizJovairasTranDataInput.Selection.Top] :=
//          lstInditottKetlepcsosTranzakciok.ItemFocused.SubItems[0];

   end;

end;

procedure TfmMain.lstWf3TranDataInputStringsChange(Sender: TObject);
begin
  edtCustomerWebPage.Text := webCustomerUrl
    + '?posId=' + HTTPEncode(lstWf3TranDataInput.Strings.Values['posId'])
    + '&azonosito=' + HTTPEncode(lstWf3TranDataInput.Strings.Values['tranz.azon']);
  if (lstWf3TranDataInput.Strings.Values['nyelvkod'] <> 'hu') then
    edtCustomerWebPage.Text := edtCustomerWebPage.Text +
    '&nyelvkod=' + HTTPEncode(lstWf3TranDataInput.Strings.Values['nyelvkod']);
end;

procedure TfmMain.lstWf3TranDataInputEditButtonClick(Sender: TObject);
var
   rect: TRect;
   senderList: TValueListEditor;
   currentPage: TTabSheet;
begin
   senderList := Sender as TValueListEditor;
   rect := senderList.CellRect(senderList.Selection.Left, senderList.Selection.Top);

   if (senderList.Keys[senderList.Selection.Top] = 'tranz.azon') then begin
      if senderList = lstWsf2TranDataInput then
        lstTrIdGenTranDataInput.Values['posId'] := lstWsf2TranDataInput.Values['posId']
      else
        lstTrIdGenTranDataInput.Values['posId'] := lstWf3TranDataInput.Values['posId'];
      currentPage := pgcWebshopTranzakciok.ActivePage;
      pgcWebshopTranzakciok.ActivePage := tabTrIdGen;
      pgcWebshopTranzakciokChange(Sender);
      btnSendClick(Sender);
      pgcWebshopTranzakciok.ActivePage := currentPage;
      pgcWebshopTranzakciokChange(Sender);
      senderList.Values['tranz.azon'] :=
        lstTrIdGenTranDataOutput.Values['tranz.azon'];
   end;
end;

procedure TfmMain.btnMWAccessPingClick(Sender: TObject);
begin
  try
    rioMwAccess.URL := edtMWAccessUrl.Text;
//    mws := (rioMwAccess as MWAccessService);

    Screen.Cursor := crHourGlass;
    stbMain.Panels[0].Text := 'Banki fellet - ping folyamatban';
    stbMain.Repaint();

    (rioMwAccess as MWAccessService).ping();
    stbMain.Panels[0].Text := 'Banki fellet - ping sikeres';

    Screen.Cursor := crDefault;
  except
    on e: Exception do begin
      Screen.Cursor := crDefault;
      stbMain.Panels[0].Text := 'Ping sikertelen.';

      btnLoadWebInput.Enabled := false;
      Application.MessageBox(PAnsiChar(e.Message), 'Hiba!', MB_OK);
    end;
  end;
end;

procedure TfmMain.lstWsfLezarasTranDataInputEditButtonClick(Sender: TObject);
var
   rect: TRect;
begin
   rect := lstWsfLezarasTranDataInput.CellRect(
    lstWsfLezarasTranDataInput.Selection.Left, lstWsfLezarasTranDataInput.Selection.Top);

   if (lstWsfLezarasTranDataInput.Selection.Top = 2)
      and (lstInditottKetlepcsosTranzakciok.Items.Count > 0) then begin
    lstInditottKetlepcsosTranzakciok.Top := rect.Bottom + 2;
    lstInditottKetlepcsosTranzakciok.Visible := true;
    lstInditottKetlepcsosTranzakciok.SetFocus();
   end;
end;

procedure TfmMain.lstFizJovairasTranDataInputEditButtonClick(
  Sender: TObject);
var
   rect: TRect;
begin
   rect := lstFizJovairasTranDataInput.CellRect(
           lstFizJovairasTranDataInput.Selection.Left, lstFizJovairasTranDataInput.Selection.Top);

   if (lstFizJovairasTranDataInput.Selection.Top = 1)
      and (lstJovairhatoTranz.Items.Count > 0) then begin
      lstJovairhatoTranz.Top := rect.Bottom + 2;
      lstJovairhatoTranz.Visible := true;
      lstJovairhatoTranz.SetFocus();
      exit;
   end;
end;

procedure TfmMain.lstJovairhatoTranzExit(Sender: TObject);
begin
   lstJovairhatoTranz.Visible := false;

   if (lstJovairhatoTranz.ItemFocused <> nil) then
      lstFizJovairasTranDataInput.Cells[
        lstFizJovairasTranDataInput.Selection.Left,
        lstFizJovairasTranDataInput.Selection.Top] := lstJovairhatoTranz.ItemFocused.SubItems[0];

end;

end.
