package hu.iqsoft.otp.webshop.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Hashtable;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/**
 * hu.iqsoft.otp.webshop.util.NoClientAuthJSSESocketFactory
 * 
 * Nem azonostott kliens - azonostott szerver kapcsolaton alapul
 * SSLSocket pldnyost
 * 
 * @author Bodnr Imre (c) IQSys Rt.
 */
public class NoClientAuthJSSESocketFactory extends DefaultSocketFactory implements SecureSocketFactory {

    public NoClientAuthJSSESocketFactory(Hashtable attributes)
    {
        super(attributes);
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL)
        throws Exception
    {
        if(port == -1)
            port = 443;
        TransportClientProperties tcp = TransportClientPropertiesFactory.create("https");
        boolean hostInNonProxyList = isHostInNonProxyList(host, tcp.getNonProxyHosts());
        Socket sslSocket = null;
        if(tcp.getProxyHost().length() == 0 || hostInNonProxyList)
        {
            sslSocket = createSSLFactory().createSocket(host, port);
        } else
        {
            int tunnelPort = tcp.getProxyPort().length() == 0 ? 80 : Integer.parseInt(tcp.getProxyPort());
            if(tunnelPort < 0)
                tunnelPort = 80;
            Socket tunnel = new Socket(tcp.getProxyHost(), tunnelPort);
            java.io.OutputStream tunnelOutputStream = tunnel.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
            out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: AxisClient");
            if(tcp.getProxyUser().length() != 0 && tcp.getProxyPassword().length() != 0)
            {
                String encodedPassword = XMLUtils.base64encode((tcp.getProxyUser() + ":" + tcp.getProxyPassword()).getBytes());
                out.print("\nProxy-Authorization: Basic " + encodedPassword);
            }
            out.print("\nContent-Length: 0");
            out.print("\nPragma: no-cache");
            out.print("\r\n\r\n");
            out.flush();
            InputStream tunnelInputStream = tunnel.getInputStream();
            if(DefaultSocketFactory.log.isDebugEnabled())
                DefaultSocketFactory.log.debug(Messages.getMessage("isNull00", "tunnelInputStream", "" + (tunnelInputStream == null)));
            String replyStr = "";
            int newlinesSeen = 0;
            boolean headerDone = false;
            while(newlinesSeen < 2)
            {
                int i = tunnelInputStream.read();
                if(i < 0)
                    throw new IOException("Unexpected EOF from proxy");
                if(i == 10)
                {
                    headerDone = true;
                    newlinesSeen++;
                } else
                if(i != 13)
                {
                    newlinesSeen = 0;
                    if(!headerDone)
                        replyStr = replyStr + String.valueOf((char)i);
                }
            }
            if(!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200"))
                throw new IOException(Messages.getMessage("cantTunnel00", new String[] {
                    tcp.getProxyHost(), "" + tunnelPort, replyStr
                }));
            sslSocket = createSSLFactory().createSocket(tunnel, host, port, true);
            if(DefaultSocketFactory.log.isDebugEnabled())
                DefaultSocketFactory.log.debug(Messages.getMessage("setupTunnel00", tcp.getProxyHost(), "" + tunnelPort));
        }
        ((SSLSocket)sslSocket).startHandshake();
        if(DefaultSocketFactory.log.isDebugEnabled())
            DefaultSocketFactory.log.debug(Messages.getMessage("createdSSL00"));
        return sslSocket;
    }

    public static SSLSocketFactory createSSLFactory()  {

        SSLContext ctx;
        TrustManagerFactory tmf;
        SSLSocketFactory factory = null;
        try {
            ctx = SSLContext.getInstance("SSLv3", "SunJSSE");
            ctx.init(null, new TrustManager[]{new unauthenticatedClientTM()}, null);
            factory = ctx.getSocketFactory();
            return factory;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * A nem azonostott kliens - azonostott szerver kapcsolatot
     * megvalst TrustManager implementci
     */
    public static class unauthenticatedClientTM
        implements TrustManager, X509TrustManager {
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }
        public boolean isServerTrusted(
            java.security.cert.X509Certificate[] certs) {
            return true;
        }
        public boolean isClientTrusted(
            java.security.cert.X509Certificate[] certs) {
            return true;
        }
        public void checkServerTrusted(
            java.security.cert.X509Certificate[] certs,
            String authType)
            throws java.security.cert.CertificateException {
            return;
        }
        public void checkClientTrusted(
            java.security.cert.X509Certificate[] certs,
            String authType)
            throws java.security.cert.CertificateException {
            return;
        }
    }

}
