package hu.iqsoft.otp.webshop.util;

import java.io.Serializable;
import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.InputSource;
import org.w3c.dom.Document;

public class TransactionState implements Serializable {

  private final static String SIMPLE_DATE_FORMAT_PATTERN = "yyyy.MM.dd. HH:mm:ss";

  private Date m_start = null;
  private Date m_end = null;
  private byte[] m_result = null;
  private String m_strInstanceId = null;
  private boolean m_bTimeout = false;
  private String m_strTemplateName = null;
  private SimpleDateFormat m_dateFormat = 
    new SimpleDateFormat(SIMPLE_DATE_FORMAT_PATTERN);

  public TransactionState() {
  }

  public TransactionState(
    String strInstanceId, 
    String start, 
    String end,
    byte[] result, 
    String bTimeout) {
    m_strInstanceId = strInstanceId;
    setStartTime(start);
    setEndTime(end);
    m_result = result;
    m_bTimeout = "true".equals(bTimeout) && m_end == null;
  }

  public void setTemplateName(String strTemplateName) {
    m_strTemplateName = strTemplateName;
  }

  public String getTemplateName() {
    return m_strTemplateName;
  }

  public boolean isCompleted() {
    return m_end != null;
  }

  public void setCompleted(boolean b) {
  }

  public byte[] getResult() {
    return m_result;
  }

  public void setResult(byte[] b) {
    m_result = b;
  }

  public void setTimeout(boolean b) {
    m_bTimeout = b;
  }

  public boolean isTimeout() {
    return m_bTimeout;
  }

  public String getInstanceId() {
    return m_strInstanceId;
  }

  public void setInstanceId(String s) {
    m_strInstanceId = s;
  }

  public String getStartTime() {
    if(m_start == null) {
      return null;
    }
    return m_dateFormat.format(m_start);
  }

  public void setStartTime(String t) {
    try {
      m_start = m_dateFormat.parse(t);
    }
    catch(Exception e) {
      m_start = null;
    }
  }

  public String getEndTime() {
    if(m_end == null) {
      return null;
    }
    return m_dateFormat.format(m_end);
  }

  public void setEndTime(String t) {
    try {
      m_end = m_dateFormat.parse(t);
    }
    catch(Exception e) {
      m_end = null;
    }
  }

  public Document returnXmlResult() throws Exception {
    DOMParser parser = new DOMParser();
    parser.parse(new InputSource(
      new ByteArrayInputStream((byte[])m_result)));
    return parser.getDocument();
  }

  public String toString() {
    StringBuffer sb = new StringBuffer();
    sb.append("State of " + m_strInstanceId + ": ");
    sb.append("Started: " + m_start);
    sb.append("; Completed: " + m_end);
    if(m_result != null) {
      sb.append("; Result: ok");
    }
    else {
      sb.append("; Result: null");
    }
    sb.append("; Timeout: " + m_bTimeout);
    return sb.toString();
  }

}
