package hu.iqsoft.otp.webshop.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;


/**
 * hu.iqsys.otp.webshop.WebShopXmlUtils
 * Eljrs gyjtemny folyamat indt xml sszelltsnak tmogastshoz 
 * 
 * 
 * @author Bodnr Imre (c) IQSys Rt.
 */
public class WebShopXmlUtils  {

    /* Az indthat folyamatok nevei: */
    public static String WF_TRANZAZONGENERALAS = "WEBSHOPTRANZAZONGENERALAS";
    public static String WF_HAROMSZEREPLOSFIZETES = "WEBSHOPFIZETES"; 
    public static String WF_KETSZEREPLOSFIZETES = "WEBSHOPFIZETESKETSZEREPLOS"; 
    public static String WF_TRANZAKCIOSTATUSZ = "WEBSHOPTRANZAKCIOLEKERDEZES"; 
    public static String WF_KETLEPCSOSFIZETESLEZARAS = "WEBSHOPFIZETESLEZARAS"; 
    
    public static String ROOTELEMENT_TAG  = "answer";
    public static String MESSAGELIST_PATH = ROOTELEMENT_TAG + "/messagelist";
    public static String MESSAGEITEM      = "message";
	
    /* Input xml vltoz nevek. */
    public static String AMOUNT = "isAmount";
    public static String BACKURL = "isBackURL";
    public static String CONSUMERRECEIPTNEEDED = "isConsumerReceiptNeeded";
    public static String COUNTRYNEEDED = "isCountryNeeded";
    public static String COUNTYNEEDED = "isCountyNeeded";
    public static String EXCHANGE = "isExchange";
    public static String LANGUAGECODE = "isLanguageCode";
    public static String MAILADDRESSNEEDED = "isMailAddressNeeded";
    public static String NAMENEEDED = "isNameNeeded";
    public static String NARRATIONNEEDED = "isNarrationNeeded";
    public static String POSID = "isPOSID";
    public static String SETTLEMENTNEEDED = "isSettlementNeeded";
    public static String SHOPCOMMENT = "isShopComment";
    public static String STREETNEEDED = "isStreetNeeded";
    public static String TRANSACTIONID = "isTransactionID";
    public static String ZIPCODENEEDED = "isZipcodeNeeded";
    public static String CLIENTSIGNATURE = "isClientSignature";
    public static String CONSUMERREGISTRATIONNEEDED = "isConsumerRegistrationNeeded";
    public static String CONSUMERREGISTRATIONID = "isConsumerRegistrationID";
    public static String TWOSTAGED = "isTwoStaged";
    
    /* Input xml vltoz nevek - ktszerepls fizetshez. */
    public static String CARDNUMBER = "isCardNumber";
    public static String CVCCVV = "isCVCCVV";
    public static String EXPIRATIONDATE = "isExpirationDate";
    public static String NAME = "isName";
    public static String FULLADDRESS = "isFullAddress";
    public static String IPADDRESS = "isIPAddress";
    public static String MAILADDRESS = "isMailAddress";
    public static String TELEPHONE = "isTelephone";

    /* Input xml vltoz nevek - tranzakcik lekrdezshez. */
    public static String QUERYMAXRECORDS = "isMaxRecords";
    public static String QUERYSTARTDATE = "isStartDate";
    public static String QUERYENDDATE = "isEndDate";

    /* Input xml vltoz nevek - ktlpcss fizets lezrshoz. */
    public static String APPROVED = "isApproval";
    
    public static String REQUEST_DATEFORMAT = "yyyy.MM.dd HH:mm:ss";
    
        
    public static String REQUEST_SKELETON =
        "<?xml version=\"1.0\" encoding=\"ISO-8859-2\"?>" + "<StartWorkflow>" +
        "  <TemplateName/>" + "  <Variables>" +
        "    <isClientCode>WEBSHOP</isClientCode>" + "  </Variables>" +
        "</StartWorkflow>";

    public static String TEMPLATENAME_TAGNAME = "TemplateName";

    public static String VARIABLES_TAGNAME = "Variables";

    public static String DOMToXMLString(Document domContent)
        throws IOException {
        ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setLineSeparator("\n");
        format.setIndenting(false);
        format.setIndent(2);
        format.setOmitXMLDeclaration(false);
        format.setEncoding("ISO-8859-2");

        XMLSerializer serializer = new XMLSerializer(outStrm, format);
        serializer.serialize(domContent);

        return outStrm.toString();
    }

    public static final Document byteArrayToDOM (byte[] arrayValue) 
    	throws SAXException, IOException {

        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new java.io.ByteArrayInputStream(arrayValue));
        parser.parse(is);
        Document doc = parser.getDocument();
        return doc;
/*
    	DOMImplementation domFactory =
    		DOMImplementationImpl.getDOMImplementation();
    	Document doc =
    		domFactory.createDocument(null, "StartWorkflow", null);
        doc.getDocumentElement().appendChild(doc.createElement("TemplateName"));	
        //doc.appendChild(doc.createElement("Variables"));

System.out.println(DOMToXMLString(doc));

        return doc;
*/        
    }

    /**
     * Legenerl egy res WorkflowStarter xml-t
     */
    public static Document getRequestSkeleton() 
        throws IOException, SAXException {
        return WebShopXmlUtils.byteArrayToDOM(REQUEST_SKELETON.getBytes());
    }

    /**
     * Egy WorkflowStart-er xml-be beilleszti a megadott paramtert a
     * megfelel helyre
     */
    public static void addParameter(Document dom, Node variables, String name,
        String value) {
        Node nodeText = dom.createTextNode(name);
        nodeText.setNodeValue(value);

        Node node = null;
        if (dom.getDocumentElement().getNamespaceURI() != null) {
        	node = dom.createElementNS(dom.getDocumentElement().getNamespaceURI(), name);
        	node.setPrefix(dom.getDocumentElement().getPrefix());
        }
        else {
        	node = dom.createElement(name);
        }
        variables.appendChild(node);
        node.appendChild(nodeText);
    }

    /**
     * Egy WorkflowStart-er xml-be beilleszti a megadott logikai paramtert a
     * megfelel helyre
     */
    public static void addParameter(Document dom, Node variables, String name,
        boolean value) {
        addParameter(dom, variables, name, (value ? "TRUE" : "FALSE"));
    }

    /***************
     * XPath-hoz hasonl tag lekrdezs, tag tartalmra vonatkozan
     *
     * @param   doc     XML documentum
     * @param   path    tag-tvonal, plda: Workflow/nodes/Start
     *
     * @return  a tag szveg-tartalma, illetve null, ha nem tallhat
     */
    public static String getTagTextByPath(Document doc, String path) {
        Element elmt;

        elmt = getElementByPath(doc, path);
        if (elmt==null)
          return null;
        else if (elmt!=null && elmt.getFirstChild()!=null)
          return getElementLongText(elmt);
        else
          return "";
    }

    /***************
     * XPath-hoz hasonl tag lekrdezs, tag Element-jre vonatkozan
     *
     * @param   doc     XML documentum
     * @param   path    tag-tvonal, plda: Workflow/nodes/Start
     *
     * @return  a tag Element, illetve null, ha nem tallhat
     */
    public static Element getElementByPath(Document doc, String path) {
        String   pathElement;
        Element  domElement, child;
        int      startIndex = 0;
        int      endIndex = 0;

        // gykr, mint elso path elem ellenorzse
        domElement = doc.getDocumentElement();
        endIndex = path.indexOf('/', startIndex);
        if (endIndex==0) {
          // A kezdo / jelet kivgjuk
          startIndex = 1;
          endIndex = path.indexOf('/', startIndex);
        }
        pathElement = (endIndex == -1) ? path.substring(startIndex) : path.substring(startIndex, endIndex);
        if (!pathElement.equals(domElement.getTagName()))
            return null;
        startIndex = endIndex + 1;

        // tovbbi elemek keresse
        while (endIndex != -1 && startIndex<path.length()) {
          endIndex = path.indexOf('/', startIndex);
          pathElement = (endIndex == -1) ? path.substring(startIndex) : path.substring(startIndex, endIndex);
          startIndex = endIndex + 1;
          if (endIndex==startIndex) continue;

          child = getChildOfElement(domElement, pathElement);
          if (child == null) {
            return null;
          }
          domElement = child;
        }
        return domElement;
    }

    /***************
     * XPath-hoz hasonl tag lekrdezs, tag Element-jre vonatkozan
     *
     * @param   doc     XML documentum
     * @param   path    tag-tvonal, plda: Workflow/nodes/Start
     *
     * @return  a tag Element, illetve null, ha nem tallhat
     */
    public static Element getElementByPath(Element element, String path) {
        String   pathElement;
        Element  domElement, child;
        int      startIndex = 0;
        int      endIndex = 0;

        domElement = element;

        endIndex = path.indexOf('/', startIndex);
        if (endIndex==0) {
          // A kezdo / jelet kivgjuk
          startIndex = 1;
          endIndex = path.indexOf('/', startIndex);
        }
        else if (endIndex==-1)
          endIndex = 0;

        // az elemek keresse
        while (endIndex != -1) {
          endIndex = path.indexOf('/', startIndex);
          pathElement = (endIndex == -1) ? path.substring(startIndex) : path.substring(startIndex, endIndex);
          child = getChildOfElement(domElement, pathElement);
          if (child == null) {
            return null;
          }
          domElement = child;
          startIndex = endIndex + 1;
        }
        return domElement;
    }

    /***************
     * Tag Element tartalmnak (text node) lekrdezse. Ha tbb bejegyzs is van,
     * sszef?zi azokat
     *
     * @param   elmt        Tag Element
     *
     * @return  a tartalom szvege, illetve null, ha nem definilt
     */
    public static String getElementLongText(Element elmt) {
        StringBuffer result = new StringBuffer("");
        Node child = elmt.getFirstChild();

        while (child!=null) {
            if (child.getNodeType()==Node.TEXT_NODE) {
              result.append(child.getNodeValue());
            }
            child=child.getNextSibling();
            if (child != null) {
              result.append("\n");
            }
        }
        if (result.length()==0) {
          return null;
        }
        else {
          return result.toString();
        }
    }

    /***************
     * Tag Element adott nev? kzvetlen leszrmazottjnak lekrdezse
     *
     * @param   elmt        Tag Element
     * @param   childTag    a keresett leszrmazott tag neve
     *
     * @return  a keresett tag Element, illetve null, ha nem tallhat
     */
    public static Element getChildOfElement(Node elmt, String childTag) {
        NodeList nodes;
        Node     found,child;

        nodes = elmt.getChildNodes();
        found = null;
        for (int i=0; i<nodes.getLength(); i++) {
          child = nodes.item(i);
          if (child.getNodeType()!=Node.ELEMENT_NODE) continue;

          if (childTag==null || childTag.equals(child.getLocalName())) {
            if (found==null)
              found = child;
            else
              return (Element)found;
          }
        }
        return (Element)found;
    }

    /***************
     * Tag Element sszes Element tpus, adott nev? gyermeknek lekrdezse
     *
     * @param elmt Tag Element
     * @param childTag a tag neve, amire sz?rni kell
     *
     * @return  a gyeremekek Element listja
     */
    public static List getChildElements(Element elmt, String childTag) {
        Vector   result = new Vector();
        NodeList nodes;
        Node     child;

        nodes = elmt.getChildNodes();
        for (int i=0; i<nodes.getLength(); i++) {
          child = nodes.item(i);
          if ((child.getNodeType()==Node.ELEMENT_NODE) &&
              ((childTag==null) || (childTag.equals(child.getLocalName())))) {
            result.add(child);
          }
        }
        return result;
    }

    /***************
     * A folyamat-pldny vlasznak messagelist betltse.
     * Sikeres lefuts esetn a vlaszul kapott lista egyetlen "SIKER" elemet
     * tartalmaz. Sikertelen lefuts esetn egy- vagy tbb hibakdot tartalmaz a
     * lista.
     * 
     * @param answerXml a folyamat vlasz xml-je
     * @return lista a folyamat vlasz zeneteivel
     */
    public static List extractMessages(Document answerXml) {
        List messages = null;
        
        List messagesList;
        Element message;
        String messageText;
        Element messageList = 
        	getElementByPath(answerXml, MESSAGELIST_PATH);
        if (messageList != null) {
          messages = new Vector();
          messagesList = getChildElements(messageList, MESSAGEITEM);
          for (int i=0; i<messagesList.size(); i++) {
            message = (Element)messagesList.get(i);
            messageText = getElementLongText(message);
            messages.add(messageText);
          }
        }

		return messages; 
    }
	
}
